/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional;

import java.util.Collections;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.jbpm.test.tools.TrackingListenerAssert;
import org.jbpm.workflow.instance.node.DynamicUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;

public class FlexibleProcessTest
extends JbpmTestCase {
    public static final String PROCESS = "org/jbpm/test/functional/FlexibleProcess.bpmn";
    public static final String PROCESS_ID = "org.jbpm.test.functional.FlexibleProcess";

    public FlexibleProcessTest() {
        super(false);
    }

    @Ignore
    @Test(timeout=30000L)
    public void testFlexibleProcess() throws Exception {
        KieSession ksession = this.createKSession(PROCESS);
        TrackingProcessEventListener tpel = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)tpel);
        JbpmJUnitBaseTestCase.TestWorkItemHandler handler = new JbpmJUnitBaseTestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance pi = ksession.startProcess(PROCESS_ID);
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)tpel, (String)PROCESS_ID);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"start");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)"task1");
        ksession.signalEvent("userTask", null, pi.getId());
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)"userTask");
        ksession = this.restoreKSession(PROCESS);
        Assertions.assertThat((Iterable)ksession.getProcessEventListeners()).isNotEmpty();
        WorkItem item = handler.getWorkItem();
        ksession.getWorkItemManager().completeWorkItem(item.getId(), null);
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)"userTask2");
        ksession.signalEvent("task21", null, pi.getId());
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"task21");
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"task22");
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"end1");
        TrackingListenerAssert.assertProcessCompleted((TrackingProcessEventListener)tpel, (String)PROCESS_ID);
        Assert.assertFalse((boolean)tpel.wasNodeTriggered("task3"));
        Assert.assertFalse((boolean)tpel.wasNodeTriggered("end2"));
    }

    @Test(timeout=30000L)
    public void testFlexibleProcessAddWorkItem() {
        KieSession ksession = this.createKSession(PROCESS);
        TrackingProcessEventListener tpel = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)tpel);
        JbpmJUnitBaseTestCase.TestWorkItemHandler handler = new JbpmJUnitBaseTestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("addedWorkItem", (WorkItemHandler)handler);
        ProcessInstance pi = ksession.startProcess(PROCESS_ID);
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)tpel, (String)PROCESS_ID);
        DynamicUtils.addDynamicWorkItem((ProcessInstance)pi, (KieRuntime)ksession, (String)"addedWorkItem", Collections.emptyMap());
        WorkItem wi = handler.getWorkItem();
        ksession.getWorkItemManager().completeWorkItem(wi.getId(), new HashMap());
        Assert.assertEquals((Object)wi.getName(), (Object)"addedWorkItem");
    }
}

