/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.appformer.maven.support.AFReleaseId;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.command.KieCommands;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JbpmTestCase
extends JbpmJUnitBaseTestCase {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String EMPTY_CASE = "EmptyCase.bpmn2";
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            System.out.println(" >>> " + description.getMethodName() + " <<< ");
        }

        protected void finished(Description description) {
            System.out.println();
        }
    };

    public JbpmTestCase() {
        this(true);
    }

    public JbpmTestCase(boolean persistence) {
        this(persistence, persistence);
    }

    public JbpmTestCase(boolean setupDataSource, boolean sessionPersistence) {
        this(setupDataSource, sessionPersistence, "org.jbpm.test.persistence");
    }

    public JbpmTestCase(boolean setupDataSource, boolean sessionPersistence, String persistenceUnit) {
        super(setupDataSource, sessionPersistence, persistenceUnit);
    }

    protected Properties getDataSourceProperties() {
        Properties dsProps = PersistenceUtil.getDatasourceProperties();
        dsProps.setProperty("POOL_CONNECTIONS", "false");
        return dsProps;
    }

    public KieSession createKSession(String ... process) {
        this.createRuntimeManager(process);
        return this.getRuntimeEngine().getKieSession();
    }

    public KieSession createKSession(Map<String, ResourceType> res) {
        this.createRuntimeManager(res);
        return this.getRuntimeEngine().getKieSession();
    }

    public KieSession restoreKSession(String ... process) {
        this.disposeRuntimeManager();
        this.createRuntimeManager(process);
        return this.getRuntimeEngine().getKieSession();
    }

    public void assertProcessInstanceNeverRun(long processId) {
        ((ObjectAssert)Assertions.assertThat((Object)this.getLogService().findProcessInstance(processId)).as("Process has been running", new Object[0])).isNull();
    }

    protected static KieServices getServices() {
        return KieServices.Factory.get();
    }

    protected static KieCommands getCommands() {
        return JbpmTestCase.getServices().getCommands();
    }

    protected byte[] createAndDeployJar(KieServices ks, ReleaseId releaseId, Resource ... resources) throws Exception {
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId);
        for (int i = 0; i < resources.length; ++i) {
            if (resources[i] == null) continue;
            kfs.write(resources[i]);
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        ((InternalKieBuilder)kieBuilder).buildAll(o -> true);
        Results results = kieBuilder.getResults();
        if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new IllegalStateException(results.getMessages(new Message.Level[]{Message.Level.ERROR}).toString());
        }
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] pomXmlContent = IOUtils.toByteArray((InputStream)kieModule.getPomAsStream());
        File pom = new File("target", UUID.randomUUID().toString());
        Files.write(pom.toPath(), pomXmlContent, new OpenOption[0]);
        KieMavenRepository.getKieMavenRepository().installArtifact((AFReleaseId)releaseId, kieModule, pom);
        byte[] jar = kieModule.getBytes();
        return jar;
    }
}

