/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.jbpm.runtime.manager.impl.task.SynchronizedTaskService;
import org.jbpm.services.task.identity.LDAPUserGroupCallbackImpl;
import org.jbpm.test.LdapJbpmTestCase;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Status;

public class HumanTaskWithLDAPTest
extends LdapJbpmTestCase {
    private static final String LDAP_HUMAN_TASK = "org/jbpm/test/functional/task/HumanTask-ldap.bpmn2";
    private static final String LDAP_HUMAN_TASK_ID = "org.jbpm.test.functional.task.HumanTask-ldap";
    private static final String LDAP_TASK_LDIF = "src/test/resources/org/jbpm/test/functional/task/HumanTask-task.ldif";
    private KieSession kieSession;
    private TaskService taskService;

    public HumanTaskWithLDAPTest() {
        super(LDAP_TASK_LDIF);
    }

    @Before
    public void init() {
        this.userGroupCallback = new LDAPUserGroupCallbackImpl(this.createUserGroupCallbackProperties());
        this.createRuntimeManager(new String[]{LDAP_HUMAN_TASK});
        this.kieSession = this.getRuntimeEngine().getKieSession();
        this.taskService = this.getRuntimeEngine().getTaskService();
    }

    @Test
    public void testCompleteTask() {
        long pid = this.kieSession.startProcess(LDAP_HUMAN_TASK_ID).getId();
        long taskId = (Long)this.taskService.getTasksByProcessInstanceId(pid).get(0);
        this.taskService.start(taskId, "john");
        this.taskService.complete(taskId, "john", null);
        Status status = this.taskService.getTaskById(taskId).getTaskData().getStatus();
        Assertions.assertThat((Comparable)status).isEqualTo((Object)Status.Completed);
    }

    @Test
    public void testUpdateTaskComment() {
        long pid = this.kieSession.startProcess(LDAP_HUMAN_TASK_ID).getId();
        long taskId = (Long)this.taskService.getTasksByProcessInstanceId(pid).get(0);
        this.taskService.start(taskId, "john");
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("Content", "testing save");
        values.put("Author", "mary");
        ((SynchronizedTaskService)this.taskService).addContentFromUser(taskId, "mary", values);
        this.taskService.complete(taskId, "john", null);
        Status status = this.taskService.getTaskById(taskId).getTaskData().getStatus();
        Assertions.assertThat((Comparable)status).isEqualTo((Object)Status.Completed);
    }
}

