/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;
import org.assertj.core.api.Assertions;
import org.jbpm.kie.services.impl.admin.commands.AddPeopleAssignmentsCommand;
import org.jbpm.services.task.events.DefaultTaskEventListener;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.test.JbpmTestCase;
import org.junit.After;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.OrganizationalEntity;

public class TaskAssignmentAddedListenersTest
extends JbpmTestCase {
    private KieSession ksession;
    private TaskService ts;
    List<OrganizationalEntity> beforePotentialOwners;
    List<OrganizationalEntity> beforeEntitiesToSet;
    List<OrganizationalEntity> afterPotentialOwners;
    List<OrganizationalEntity> afterEntitiesToSet;
    MutableInt triggeredBeforeListenerCounter;
    MutableInt triggeredAfterListenerCounter;
    private static final String PROCESS = "org/jbpm/test/functional/task/HumanTask-simple.bpmn2";
    private static final String PROCESS_ID = "org.jbpm.test.functional.task.HumanTask-simple";

    private void init() {
        this.createRuntimeManager(new String[]{PROCESS});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        this.ksession = runtimeEngine.getKieSession();
        this.ts = runtimeEngine.getTaskService();
    }

    @After
    public void clenaup() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
        this.disposeRuntimeManager();
    }

    @Test
    public void testAddedAssignmentListenersThreeParamApiRegression() {
        DefaultTaskEventListener listener = new DefaultTaskEventListener(){

            public void beforeTaskAssignmentsAddedEvent(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities) {
                TaskAssignmentAddedListenersTest.this.triggeredBeforeListenerCounter.increment();
                TaskAssignmentAddedListenersTest.this.beforePotentialOwners.addAll(event.getTask().getPeopleAssignments().getPotentialOwners());
                TaskAssignmentAddedListenersTest.this.beforeEntitiesToSet.addAll(entities);
                TaskAssignmentAddedListenersTest.this.logger.debug("before potentialOwners: " + TaskAssignmentAddedListenersTest.this.beforePotentialOwners);
                TaskAssignmentAddedListenersTest.this.logger.debug("before entities: " + TaskAssignmentAddedListenersTest.this.beforeEntitiesToSet);
            }

            public void afterTaskAssignmentsAddedEvent(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities) {
                TaskAssignmentAddedListenersTest.this.triggeredAfterListenerCounter.increment();
                TaskAssignmentAddedListenersTest.this.afterPotentialOwners.addAll(event.getTask().getPeopleAssignments().getPotentialOwners());
                TaskAssignmentAddedListenersTest.this.afterEntitiesToSet.addAll(entities);
                TaskAssignmentAddedListenersTest.this.logger.debug("after potentialOwners: " + TaskAssignmentAddedListenersTest.this.afterPotentialOwners);
                TaskAssignmentAddedListenersTest.this.logger.debug("after entities: " + TaskAssignmentAddedListenersTest.this.afterEntitiesToSet);
            }
        };
        this.testRegression((TaskLifeCycleEventListener)listener);
    }

    @Test
    public void testAddedAssignmentListenersFourParamApiRegression() {
        DefaultTaskEventListener listener = new DefaultTaskEventListener(){

            public void beforeTaskAssignmentsAddedEvent(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities, List<OrganizationalEntity> beforeChangeEntities) {
                TaskAssignmentAddedListenersTest.this.triggeredBeforeListenerCounter.increment();
                TaskAssignmentAddedListenersTest.this.beforePotentialOwners.addAll(event.getTask().getPeopleAssignments().getPotentialOwners());
                TaskAssignmentAddedListenersTest.this.beforeEntitiesToSet.addAll(entities);
                TaskAssignmentAddedListenersTest.this.logger.debug("before potentialOwners: " + TaskAssignmentAddedListenersTest.this.beforePotentialOwners);
                TaskAssignmentAddedListenersTest.this.logger.debug("before entities: " + TaskAssignmentAddedListenersTest.this.beforeEntitiesToSet);
            }

            public void afterTaskAssignmentsAddedEvent(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities, List<OrganizationalEntity> afterChangeEntities) {
                TaskAssignmentAddedListenersTest.this.triggeredAfterListenerCounter.increment();
                TaskAssignmentAddedListenersTest.this.afterPotentialOwners.addAll(event.getTask().getPeopleAssignments().getPotentialOwners());
                TaskAssignmentAddedListenersTest.this.afterEntitiesToSet.addAll(entities);
                TaskAssignmentAddedListenersTest.this.logger.debug("after potentialOwners: " + TaskAssignmentAddedListenersTest.this.afterPotentialOwners);
                TaskAssignmentAddedListenersTest.this.logger.debug("after entities: " + TaskAssignmentAddedListenersTest.this.afterEntitiesToSet);
            }
        };
        this.testRegression((TaskLifeCycleEventListener)listener);
    }

    @Test
    public void testAddedAssignmentListenersFourParamApi() {
        this.triggeredBeforeListenerCounter = new MutableInt(0);
        this.triggeredAfterListenerCounter = new MutableInt(0);
        final ArrayList beforeChangeEntitiesResult = new ArrayList();
        final ArrayList afterChangeEntitiesResult = new ArrayList();
        DefaultTaskEventListener listener = new DefaultTaskEventListener(){

            public void beforeTaskAssignmentsAddedEvent(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities, List<OrganizationalEntity> beforeChangeEntities) {
                TaskAssignmentAddedListenersTest.this.triggeredBeforeListenerCounter.increment();
                beforeChangeEntitiesResult.addAll(beforeChangeEntities);
                TaskAssignmentAddedListenersTest.this.logger.debug("beforeChangeEntities: " + beforeChangeEntities);
            }

            public void afterTaskAssignmentsAddedEvent(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities, List<OrganizationalEntity> afterChangeEntities) {
                TaskAssignmentAddedListenersTest.this.triggeredAfterListenerCounter.increment();
                afterChangeEntitiesResult.addAll(afterChangeEntities);
                TaskAssignmentAddedListenersTest.this.logger.debug("afterChangeEntities: " + afterChangeEntities);
            }
        };
        this.addTaskEventListener((TaskLifeCycleEventListener)listener);
        this.init();
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID);
        long pid = pi.getId();
        this.assertProcessInstanceActive(pi.getId(), this.ksession);
        this.assertNodeTriggered(pi.getId(), new String[]{"Start", "Task"});
        long taskId = (Long)this.ts.getTasksByProcessInstanceId(pid).get(0);
        UserImpl john = new UserImpl("john");
        UserImpl mary = new UserImpl("mary");
        UserImpl jim = new UserImpl("jim");
        this.ts.execute((Command)new AddPeopleAssignmentsCommand("Administrator", taskId, 0, (OrganizationalEntity[])new UserImpl[]{john}, false));
        Assertions.assertThat(beforeChangeEntitiesResult).isEmpty();
        Assertions.assertThat(afterChangeEntitiesResult).hasSize(1);
        Assertions.assertThat(afterChangeEntitiesResult).contains((Object[])new OrganizationalEntity[]{john});
        this.clearLists(beforeChangeEntitiesResult, afterChangeEntitiesResult);
        this.ts.execute((Command)new AddPeopleAssignmentsCommand("Administrator", taskId, 0, (OrganizationalEntity[])new UserImpl[]{mary}, false));
        Assertions.assertThat(beforeChangeEntitiesResult).hasSize(1);
        Assertions.assertThat(beforeChangeEntitiesResult).contains((Object[])new OrganizationalEntity[]{john}).doesNotContain((Object[])new OrganizationalEntity[]{mary});
        Assertions.assertThat(afterChangeEntitiesResult).hasSize(2);
        Assertions.assertThat(afterChangeEntitiesResult).contains((Object[])new OrganizationalEntity[]{john, mary});
        this.clearLists(beforeChangeEntitiesResult, afterChangeEntitiesResult);
        this.ts.execute((Command)new AddPeopleAssignmentsCommand("Administrator", taskId, 0, (OrganizationalEntity[])new UserImpl[]{jim}, true));
        Assertions.assertThat(beforeChangeEntitiesResult).hasSize(2);
        Assertions.assertThat(beforeChangeEntitiesResult).contains((Object[])new OrganizationalEntity[]{john, mary}).doesNotContain((Object[])new OrganizationalEntity[]{jim});
        Assertions.assertThat(afterChangeEntitiesResult).hasSize(1);
        Assertions.assertThat(afterChangeEntitiesResult).contains((Object[])new OrganizationalEntity[]{jim}).doesNotContain((Object[])new OrganizationalEntity[]{john, mary});
        this.clearLists(beforeChangeEntitiesResult, afterChangeEntitiesResult);
        Assertions.assertThat((Integer)this.triggeredBeforeListenerCounter.getValue()).isEqualTo(3);
        Assertions.assertThat((Integer)this.triggeredAfterListenerCounter.getValue()).isEqualTo(3);
    }

    private void testRegression(TaskLifeCycleEventListener listener) {
        this.triggeredBeforeListenerCounter = new MutableInt(0);
        this.triggeredAfterListenerCounter = new MutableInt(0);
        this.beforePotentialOwners = new ArrayList<OrganizationalEntity>();
        this.beforeEntitiesToSet = new ArrayList<OrganizationalEntity>();
        this.afterPotentialOwners = new ArrayList<OrganizationalEntity>();
        this.afterEntitiesToSet = new ArrayList<OrganizationalEntity>();
        this.addTaskEventListener(listener);
        this.init();
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID);
        long pid = pi.getId();
        this.assertProcessInstanceActive(pi.getId(), this.ksession);
        this.assertNodeTriggered(pi.getId(), new String[]{"Start", "Task"});
        long taskId = (Long)this.ts.getTasksByProcessInstanceId(pid).get(0);
        UserImpl john = new UserImpl("john");
        UserImpl mary = new UserImpl("mary");
        UserImpl jim = new UserImpl("jim");
        this.ts.execute((Command)new AddPeopleAssignmentsCommand("Administrator", taskId, 0, (OrganizationalEntity[])new UserImpl[]{john}, false));
        Assertions.assertThat(this.beforePotentialOwners).hasSize(1);
        Assertions.assertThat(this.beforePotentialOwners).contains((Object[])new OrganizationalEntity[]{john});
        Assertions.assertThat(this.beforeEntitiesToSet).hasSize(1);
        Assertions.assertThat(this.beforeEntitiesToSet).contains((Object[])new OrganizationalEntity[]{john});
        Assertions.assertThat(this.afterPotentialOwners).hasSize(1);
        Assertions.assertThat(this.afterPotentialOwners).contains((Object[])new OrganizationalEntity[]{john});
        Assertions.assertThat(this.afterEntitiesToSet).hasSize(1);
        Assertions.assertThat(this.afterEntitiesToSet).contains((Object[])new OrganizationalEntity[]{john});
        this.clearLists(this.beforePotentialOwners, this.beforeEntitiesToSet, this.afterPotentialOwners, this.afterEntitiesToSet);
        this.ts.execute((Command)new AddPeopleAssignmentsCommand("Administrator", taskId, 0, (OrganizationalEntity[])new UserImpl[]{mary}, false));
        Assertions.assertThat(this.beforePotentialOwners).hasSize(2);
        Assertions.assertThat(this.beforePotentialOwners).contains((Object[])new OrganizationalEntity[]{john, mary});
        Assertions.assertThat(this.beforeEntitiesToSet).hasSize(1);
        Assertions.assertThat(this.beforeEntitiesToSet).contains((Object[])new OrganizationalEntity[]{mary});
        Assertions.assertThat(this.afterPotentialOwners).hasSize(2);
        Assertions.assertThat(this.afterPotentialOwners).contains((Object[])new OrganizationalEntity[]{john, mary});
        Assertions.assertThat(this.afterEntitiesToSet).hasSize(1);
        Assertions.assertThat(this.afterEntitiesToSet).contains((Object[])new OrganizationalEntity[]{mary});
        this.clearLists(this.beforePotentialOwners, this.beforeEntitiesToSet, this.afterPotentialOwners, this.afterEntitiesToSet);
        this.ts.execute((Command)new AddPeopleAssignmentsCommand("Administrator", taskId, 0, (OrganizationalEntity[])new UserImpl[]{jim}, true));
        Assertions.assertThat(this.beforePotentialOwners).hasSize(1);
        Assertions.assertThat(this.beforePotentialOwners).contains((Object[])new OrganizationalEntity[]{jim}).doesNotContain((Object[])new OrganizationalEntity[]{john, mary});
        Assertions.assertThat(this.beforeEntitiesToSet).hasSize(1);
        Assertions.assertThat(this.beforeEntitiesToSet).contains((Object[])new OrganizationalEntity[]{jim}).doesNotContain((Object[])new OrganizationalEntity[]{john, mary});
        Assertions.assertThat(this.afterPotentialOwners).isEmpty();
        Assertions.assertThat(this.afterEntitiesToSet).hasSize(1);
        Assertions.assertThat(this.afterEntitiesToSet).contains((Object[])new OrganizationalEntity[]{jim}).doesNotContain((Object[])new OrganizationalEntity[]{john, mary});
        this.clearLists(this.beforePotentialOwners, this.beforeEntitiesToSet, this.afterPotentialOwners, this.afterEntitiesToSet);
        Assertions.assertThat((Integer)this.triggeredBeforeListenerCounter.getValue()).isEqualTo(3);
        Assertions.assertThat((Integer)this.triggeredAfterListenerCounter.getValue()).isEqualTo(3);
    }

    @SafeVarargs
    private final void clearLists(List<OrganizationalEntity> ... listsToClear) {
        for (List<OrganizationalEntity> l : listsToClear) {
            l.clear();
            Assertions.assertThat(l).isEmpty();
        }
    }
}

