/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.assertj.core.api.Assertions;
import org.jbpm.services.task.events.DefaultTaskEventListener;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;

public class TaskCompletedListenersTest
extends JbpmTestCase {
    private KieSession ksession;
    private TaskService ts;
    Map<String, Object> formerVars;
    Map<String, Object> actualVars;
    MutableInt triggeredBeforeTaskCompletedListenerCounter;
    private static final String PROCESS = "org/jbpm/test/functional/task/HumanTask-simple-with-outputvars.bpmn2";
    private static final String PROCESS_ID = "org.jbpm.test.functional.task.HumanTask_simple_with_outputvars";

    private void init() {
        this.createRuntimeManager(new String[]{PROCESS});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        this.ksession = runtimeEngine.getKieSession();
        this.ts = runtimeEngine.getTaskService();
    }

    @Test
    public void testBeforeCompletedListenersRegression() {
        DefaultTaskEventListener listener = new DefaultTaskEventListener(){

            public void beforeTaskCompletedEvent(TaskEvent event) {
                TaskCompletedListenersTest.this.putAllNullSafe(TaskCompletedListenersTest.this.actualVars, event.getTask().getTaskData().getTaskOutputVariables());
                TaskCompletedListenersTest.this.triggeredBeforeTaskCompletedListenerCounter.increment();
                TaskCompletedListenersTest.this.logger.debug("taskOutputVariables: " + event.getTask().getTaskData().getTaskOutputVariables());
            }
        };
        this.triggeredBeforeTaskCompletedListenerCounter = new MutableInt(0);
        this.actualVars = new HashMap<String, Object>();
        this.addTaskEventListener((TaskLifeCycleEventListener)listener);
        this.init();
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID);
        long pid = pi.getId();
        this.assertProcessInstanceActive(pi.getId(), this.ksession);
        this.assertNodeTriggered(pi.getId(), new String[]{"Start", "Task"});
        HashMap<String, String> outputParams = new HashMap<String, String>();
        outputParams.put("Output", "RHPAM-4446");
        Iterator iterator = this.ts.getTasksByProcessInstanceId(pid).iterator();
        while (iterator.hasNext()) {
            long taskId = (Long)iterator.next();
            this.ts.start(taskId, "john");
            this.ts.complete(taskId, "john", outputParams);
        }
        Assertions.assertThat((Integer)this.triggeredBeforeTaskCompletedListenerCounter.getValue()).isEqualTo(1);
        Assertions.assertThat(this.actualVars).hasSize(1);
        Assertions.assertThat(this.actualVars).containsKey((Object)"Output");
    }

    @Test
    public void testBeforeCompletedListener() {
        this.triggeredBeforeTaskCompletedListenerCounter = new MutableInt(0);
        this.formerVars = new HashMap<String, Object>();
        this.actualVars = new HashMap<String, Object>();
        DefaultTaskEventListener listener = new DefaultTaskEventListener(){

            public void beforeTaskCompletedEvent(TaskEvent event) {
                TaskCompletedListenersTest.this.putAllNullSafe(TaskCompletedListenersTest.this.actualVars, event.getTask().getTaskData().getTaskOutputVariables());
                Map contextData = event.getTaskContext().getContextData();
                Map taskOutputVarsCtx = (Map)contextData.get("beforeTaskExecutedOutputVariables");
                TaskCompletedListenersTest.this.putAllNullSafe(TaskCompletedListenersTest.this.formerVars, taskOutputVarsCtx);
                TaskCompletedListenersTest.this.triggeredBeforeTaskCompletedListenerCounter.increment();
                TaskCompletedListenersTest.this.logger.debug("taskOutputVariables: " + event.getTask().getTaskData().getTaskOutputVariables());
                TaskCompletedListenersTest.this.logger.debug("before completed TaskOutputVariables: " + taskOutputVarsCtx);
            }
        };
        this.addTaskEventListener((TaskLifeCycleEventListener)listener);
        this.init();
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID);
        long pid = pi.getId();
        this.assertProcessInstanceActive(pi.getId(), this.ksession);
        this.assertNodeTriggered(pi.getId(), new String[]{"Start", "Task"});
        HashMap<String, String> outputParams = new HashMap<String, String>();
        outputParams.put("Output", "RHPAM-4446");
        Iterator iterator = this.ts.getTasksByProcessInstanceId(pid).iterator();
        while (iterator.hasNext()) {
            long taskId = (Long)iterator.next();
            this.ts.start(taskId, "john");
            this.ts.complete(taskId, "john", outputParams);
        }
        Assertions.assertThat((Integer)this.triggeredBeforeTaskCompletedListenerCounter.getValue()).isEqualTo(1);
        Assertions.assertThat(this.formerVars).hasSize(0);
        Assertions.assertThat(this.formerVars).doesNotContainKey((Object)"Output");
        Assertions.assertThat(this.actualVars).hasSize(1);
        Assertions.assertThat(this.actualVars).containsKey((Object)"Output");
    }

    private <K, V> void putAllNullSafe(Map<K, V> target, Map<K, V> source) {
        if (source == null || target == null) {
            return;
        }
        target.putAll(source);
    }
}

