/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.timer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.command.UpdateTimerCommand;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.functional.timer.TimerPersistenceTest;
import org.jbpm.test.listener.process.DefaultCountDownProcessEventListener;
import org.jbpm.test.listener.process.NodeLeftCountDownProcessEventListener;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerUpdateTest
extends JbpmTestCase {
    private static final Logger logger = LoggerFactory.getLogger(TimerPersistenceTest.class);
    private static final String TIMER_FILE = "org/jbpm/test/functional/timer/UpdateTimer.bpmn2";
    private static final String PROCESS_NAME = "UpdateTimer";
    private static final String TIMER_NAME = "Timer";
    private static final String TIMER_NO_NAME_FILE = "org/jbpm/test/functional/timer/UpdateTimerNoName.bpmn2";
    private static final String START_TIMER_FILE = "org/jbpm/test/functional/timer/UpdateStartTimer.bpmn2";
    private static final String START_PROCESS_NAME = "UpdateStartTimer";
    private static final String START_TIMER_NAME = "StartTimer";
    private static final String BOUNDARY_TIMER_FILE = "org/jbpm/test/functional/timer/UpdateBoundaryTimer.bpmn2";
    private static final String BOUNDARY_PROCESS_NAME = "UpdateBoundaryTimer";
    private static final String BOUNDARY_TIMER_NAME = "BoundaryTimer";
    private static final String BOUNDARY_TIMER_ATTACHED_TO_NAME = "User";
    private static final String TIMER_SUBPROCESS_FILE = "org/jbpm/test/functional/timer/UpdateSubprocessTimer.bpmn2";
    private static final String PROCESS_SUBPROCESS_NAME = "UpdateSubProcessTimer";
    private static final String TIMER_SUBPROCESS_NAME = "Timer";
    private static final String ISO_TIMER_FILE = "org/jbpm/test/regression/ISOTimerTest.bpmn2";
    private static final String ISO_TIMER_NAME = "ISOTimerTest";
    private RuntimeEngine runtimeEngine;
    private KieSession kieSession;
    private static final String TIMER_FIRED_TEXT = "Hello Adele";
    private static final String TIMER_FIRED_TIME_PROP = "Time Adele";

    @Before
    public void setup() {
        this.runtimeEngine = null;
        this.kieSession = null;
        System.clearProperty(TIMER_FIRED_TEXT);
        System.clearProperty(TIMER_FIRED_TIME_PROP);
    }

    @Test(timeout=30000L)
    public void updateTimerLongerDelayTest() {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Timer", 1);
        this.setProcessScenario(TIMER_FILE);
        this.kieSession.addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.kieSession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        Assertions.assertThat(list).isEmpty();
        long id = this.kieSession.startProcess(PROCESS_NAME).getId();
        long startTime = System.currentTimeMillis();
        Assertions.assertThat(list).isNotEmpty();
        this.kieSession.execute((Command)new UpdateTimerCommand(id, "Timer", 8L));
        countDownListener.waitTillCompleted();
        Assertions.assertThat((boolean)this.timerHasFired()).isTrue();
        long firedTime = this.timerFiredTime();
        long timeDifference = Math.abs(firedTime - startTime - 8000L);
        logger.info("Start time: " + startTime + ", fired time: " + firedTime + ", difference: " + (firedTime - startTime));
        Assertions.assertThat((long)timeDifference).isLessThan(500L);
        Assertions.assertThat((Object)this.kieSession.getProcessInstance(id)).isNull();
    }

    @Test(timeout=30000L)
    public void updateTimerShortherDelayTest() {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Timer", 1);
        this.setProcessScenario(TIMER_FILE);
        this.kieSession.addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.kieSession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        Assertions.assertThat(list).isEmpty();
        long id = this.kieSession.startProcess(PROCESS_NAME).getId();
        long startTime = System.currentTimeMillis();
        Assertions.assertThat(list).isNotEmpty();
        this.kieSession.execute((Command)new UpdateTimerCommand(id, "Timer", 3L));
        countDownListener.waitTillCompleted();
        Assertions.assertThat((boolean)this.timerHasFired()).isTrue();
        long firedTime = this.timerFiredTime();
        long timeDifference = Math.abs(firedTime - startTime - 3000L);
        logger.info("Start time: " + startTime + ", fired time: " + firedTime + ", difference: " + (firedTime - startTime));
        Assertions.assertThat((long)timeDifference).isLessThan(500L);
        Assertions.assertThat((Object)this.kieSession.getProcessInstance(id)).isNull();
    }

    @Test(timeout=30000L)
    public void updateTimerWithoutNameTest() {
        DefaultCountDownProcessEventListener listener = new DefaultCountDownProcessEventListener(1){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName() == null) {
                    this.countDown();
                }
            }
        };
        this.setProcessScenario(TIMER_NO_NAME_FILE);
        this.kieSession.addEventListener((ProcessEventListener)listener);
        final ArrayList list = new ArrayList();
        this.kieSession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        Assertions.assertThat(list).isEmpty();
        long id = this.kieSession.startProcess(PROCESS_NAME).getId();
        long startTime = System.currentTimeMillis();
        Assertions.assertThat(list).isNotEmpty();
        Collection timers = this.getTimerManager(this.kieSession).getTimers();
        Assertions.assertThat((Iterable)timers).hasSize(1);
        long timerId = ((TimerInstance)timers.iterator().next()).getId();
        this.kieSession.execute((Command)new UpdateTimerCommand(id, timerId, 3L));
        listener.waitTillCompleted();
        Assertions.assertThat((boolean)this.timerHasFired()).isTrue();
        long firedTime = this.timerFiredTime();
        long timeDifference = Math.abs(firedTime - startTime - 3000L);
        logger.info("Start time: " + startTime + ", fired time: " + firedTime + ", difference: " + (firedTime - startTime));
        Assertions.assertThat((long)timeDifference).isLessThan(500L);
        Assertions.assertThat((Object)this.kieSession.getProcessInstance(id)).isNull();
    }

    @Test(timeout=30000L)
    public void updateTimerBeforeDelayTest() {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Timer", 1);
        this.setProcessScenario(TIMER_FILE);
        this.kieSession.addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.kieSession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        Assertions.assertThat(list).isEmpty();
        long id = this.kieSession.startProcess(PROCESS_NAME).getId();
        long startTime = System.currentTimeMillis();
        Assertions.assertThat(list).isNotEmpty();
        this.kieSession.execute((Command)new UpdateTimerCommand(id, "Timer", -5L));
        countDownListener.waitTillCompleted();
        Assertions.assertThat((boolean)this.timerHasFired()).isTrue();
        long firedTime = this.timerFiredTime();
        long timeDifference = Math.abs(firedTime - startTime);
        logger.info("Start time: " + startTime + ", fired time: " + firedTime + ", difference: " + (firedTime - startTime));
        Assertions.assertThat((long)timeDifference).isLessThan(500L);
        Assertions.assertThat((Object)this.kieSession.getProcessInstance(id)).isNull();
    }

    @Test(timeout=30000L)
    public void updateBoundaryTimerTest() {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener(BOUNDARY_TIMER_NAME, 1);
        this.setProcessScenario(BOUNDARY_TIMER_FILE);
        final ArrayList list = new ArrayList();
        this.kieSession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        this.kieSession.addEventListener((ProcessEventListener)countDownListener);
        Assertions.assertThat(list).isEmpty();
        long id = this.kieSession.startProcess(BOUNDARY_PROCESS_NAME).getId();
        long startTime = System.currentTimeMillis();
        Assertions.assertThat(list).isNotEmpty();
        this.kieSession.execute((Command)new UpdateTimerCommand(id, BOUNDARY_TIMER_ATTACHED_TO_NAME, 3L));
        countDownListener.waitTillCompleted();
        Assertions.assertThat((boolean)this.timerHasFired()).isTrue();
        long firedTime = this.timerFiredTime();
        long timeDifference = Math.abs(firedTime - startTime - 3000L);
        logger.info("Start time: " + startTime + ", fired time: " + firedTime + ", difference: " + (firedTime - startTime));
        Assertions.assertThat((long)timeDifference).isLessThan(1000L);
        Assertions.assertThat((Object)this.kieSession.getProcessInstance(id)).isNull();
    }

    @Test(timeout=30000L)
    public void updateTimerSubprocessLongerDelayTest() {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Timer", 1);
        this.setProcessScenario(TIMER_SUBPROCESS_FILE);
        this.kieSession.addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.kieSession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if ("Timer".equals(event.getNodeInstance().getNodeName())) {
                    System.setProperty(TimerUpdateTest.TIMER_FIRED_TEXT, "");
                    System.setProperty(TimerUpdateTest.TIMER_FIRED_TIME_PROP, String.valueOf(System.currentTimeMillis()));
                }
            }
        });
        Assertions.assertThat(list).isEmpty();
        long id = this.kieSession.startProcess(PROCESS_SUBPROCESS_NAME).getId();
        long startTime = System.currentTimeMillis();
        Assertions.assertThat(list).isNotEmpty();
        this.kieSession.execute((Command)new UpdateTimerCommand(id, "Timer", 8L));
        countDownListener.waitTillCompleted();
        Assertions.assertThat((boolean)this.timerHasFired()).isTrue();
        long firedTime = this.timerFiredTime();
        long timeDifference = Math.abs(firedTime - startTime - 8000L);
        logger.info("Start time: " + startTime + ", fired time: " + firedTime + ", difference: " + (firedTime - startTime));
        Assertions.assertThat((long)timeDifference).isLessThan(500L);
        Assertions.assertThat((Object)this.kieSession.getProcessInstance(id)).isNull();
    }

    private void setProcessScenario(String file) {
        this.createRuntimeManager(new String[]{file});
        this.runtimeEngine = this.getRuntimeEngine();
        this.kieSession = this.runtimeEngine.getKieSession();
        Assertions.assertThat((Object)this.kieSession).isNotNull();
    }

    private boolean timerHasFired() {
        String hasFired = System.getProperty(TIMER_FIRED_TEXT);
        return hasFired != null;
    }

    private int timerFiredCount() {
        String timerFiredCount = System.getProperty(TIMER_FIRED_TEXT);
        if (timerFiredCount == null) {
            return 0;
        }
        return Integer.parseInt(timerFiredCount);
    }

    private long timerFiredTime() {
        String timerFiredTime = System.getProperty(TIMER_FIRED_TIME_PROP);
        if (timerFiredTime == null) {
            return 0L;
        }
        return Long.parseLong(timerFiredTime);
    }

    @Test(timeout=10000L)
    public void emptyISOTimerTest() throws Exception {
        this.setProcessScenario(ISO_TIMER_FILE);
        HashMap parameters = new HashMap();
        Assertions.assertThatThrownBy(() -> this.kieSession.startProcess(ISO_TIMER_NAME, parameters)).hasCauseInstanceOf(IllegalArgumentException.class);
    }

    private TimerManager getTimerManager(KieSession ksession) {
        KieSession internal = ksession;
        if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            internal = ((SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getRunner()).getKieSession();
        }
        return ((InternalProcessRuntime)((StatefulKnowledgeSessionImpl)internal).getProcessRuntime()).getTimerManager();
    }
}

