/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.workitem;

import java.util.HashMap;
import org.jbpm.process.workitem.rest.RESTWorkItemHandler;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.functional.workitem.MockRestWorkItemHandler;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.ProcessWorkItemHandlerException;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class WorkItemExceptionHandlingMultipleWIHRetryTest
extends JbpmTestCase {
    private static final String FAILING_PROCESS_ID = "ParentProcessMultipleRestWIH";
    private static final String EXCEPTION_HANDLING_PROCESS_ID = "ExceptionHandlingProcess";

    public WorkItemExceptionHandlingMultipleWIHRetryTest() {
        super(true, true);
    }

    @Test
    public void exceptionHandlingAbortProcessWithOneWIH() {
        KieSession kieSession = this.createSession();
        kieSession.getWorkItemManager().registerWorkItemHandler("Rest", (WorkItemHandler)new RESTWorkItemHandler(((Object)((Object)this)).getClass().getClassLoader(), EXCEPTION_HANDLING_PROCESS_ID, ProcessWorkItemHandlerException.HandlingStrategy.RETRY.name()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", "one");
        ProcessInstance pi = kieSession.startProcess(FAILING_PROCESS_ID, params);
        this.assertProcessInstanceActive(pi.getId(), kieSession);
        try {
            kieSession.signalEvent("moveon", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        kieSession.abortProcessInstance(pi.getId());
        this.assertProcessInstanceAborted(pi.getId());
    }

    @Test
    public void exceptionHandlingAbortProcessWithTwoWIH() {
        KieSession kieSession = this.createSession();
        kieSession.getWorkItemManager().registerWorkItemHandler("Rest", (WorkItemHandler)new RESTWorkItemHandler(((Object)((Object)this)).getClass().getClassLoader(), EXCEPTION_HANDLING_PROCESS_ID, ProcessWorkItemHandlerException.HandlingStrategy.RETRY.name()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", "two");
        ProcessInstance pi = kieSession.startProcess(FAILING_PROCESS_ID, params);
        this.assertProcessInstanceActive(pi.getId(), kieSession);
        try {
            kieSession.signalEvent("moveon", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        kieSession.abortProcessInstance(pi.getId());
        this.assertProcessInstanceAborted(pi.getId());
    }

    @Test
    public void exceptionHandlingAbortProcessWithTwoMockRestWIH() {
        KieSession kieSession = this.createSession();
        kieSession.getWorkItemManager().registerWorkItemHandler("Rest", (WorkItemHandler)new MockRestWorkItemHandler(EXCEPTION_HANDLING_PROCESS_ID, ProcessWorkItemHandlerException.HandlingStrategy.RETRY.name()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", "two");
        ProcessInstance pi = kieSession.startProcess(FAILING_PROCESS_ID, params);
        this.assertProcessInstanceActive(pi.getId(), kieSession);
        try {
            kieSession.signalEvent("moveon", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        kieSession.abortProcessInstance(pi.getId());
        this.assertProcessInstanceAborted(pi.getId());
    }

    private KieSession createSession() {
        this.manager = this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, null, new String[]{"org/jbpm/test/functional/workitem/ParentProcessMultipleRestWIH.bpmn", "org/jbpm/test/functional/workitem/ExceptionHandlingProcess.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession kieSession = runtimeEngine.getKieSession();
        return kieSession;
    }
}

