/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.subprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.DebugProcessEventListener;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.jbpm.test.tools.IterableListenerAssert;
import org.jbpm.test.tools.TrackingListenerAssert;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItemHandler;

public class MultipleInstancesSubProcessTest
extends JbpmTestCase {
    private static final String MULTIPLE_INSTANCES = "org/jbpm/test/functional/subprocess/MultipleInstancesSubProcess.bpmn";
    private static final String MULTIPLE_INSTANCES_ID = "org.jbpm.test.functional.subprocess.MultipleInstancesSubProcess";
    private static final String MULTIPLE_INSTANCES_WITH_BOUNDARY_EVENT = "org/jbpm/test/functional/subprocess/MultipleSubprocessInstanceWithBoundaryEvent.bpmn2";
    private static final String MULTIPLE_INSTANCES_WITH_BOUNDARY_EVENT_ID = "MultipleSubprocessInstanceWithBoundaryEvent";
    private static final String MULTIPLE_INSTANCES_WITH_CALL_SUBPROCESS = "org/jbpm/test/functional/subprocess/MultipleSubprocessInstanceWithSubprocessCall.bpmn2";
    private static final String MULTIPLE_INSTANCES_WITH_CALL_SUBPROCESS_ID = "MultipleSubprocessInstanceWithSubprocessCall";

    public MultipleInstancesSubProcessTest() {
        super(false);
    }

    @Test(timeout=30000L)
    public void testMultipleInstances() {
        KieSession kieSession = this.createKSession(MULTIPLE_INSTANCES);
        IterableProcessEventListener eventListener = new IterableProcessEventListener();
        kieSession.addEventListener((ProcessEventListener)eventListener);
        kieSession.addEventListener((ProcessEventListener)new DebugProcessEventListener());
        ArrayList<String> items = new ArrayList<String>();
        items.add("breakfast");
        items.add("lunch");
        items.add("dinner");
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        params.put("list", items);
        kieSession.execute(MultipleInstancesSubProcessTest.getCommands().newStartProcess(MULTIPLE_INSTANCES_ID, params));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)eventListener, (String)"list", null, items);
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)eventListener, (String)MULTIPLE_INSTANCES_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"script");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)eventListener, (String)"multipleInstances");
        for (String str : items) {
            IterableListenerAssert.assertChangedMultipleInstancesVariable((IterableProcessEventListener)eventListener, (String)"listItem", null, (Object)str);
        }
        for (String str : items) {
            IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"innerStart");
            IterableListenerAssert.assertTriggered((IterableProcessEventListener)eventListener, (String)"innerScript");
            IterableListenerAssert.assertChangedMultipleInstancesVariable((IterableProcessEventListener)eventListener, (String)"listItem", (Object)str, (Object)(str + "-eaten"));
            IterableListenerAssert.assertLeft((IterableProcessEventListener)eventListener, (String)"innerScript");
            IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"innerEnd");
        }
        IterableListenerAssert.assertLeft((IterableProcessEventListener)eventListener, (String)"multipleInstances");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)eventListener, (String)MULTIPLE_INSTANCES_ID);
    }

    @Test
    public void testMultipleInstancesWithBoundaryEvent() {
        TrackingProcessEventListener eventListener = new TrackingProcessEventListener();
        this.addProcessEventListener((ProcessEventListener)eventListener);
        this.addWorkItemHandler("Human Task", (WorkItemHandler)this.getTestWorkItemHandler());
        KieSession kieSession = this.createKSession(MULTIPLE_INSTANCES_WITH_BOUNDARY_EVENT);
        long pid = kieSession.startProcess(MULTIPLE_INSTANCES_WITH_BOUNDARY_EVENT_ID, Collections.singletonMap("list", new ArrayList())).getId();
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)eventListener, (String)MULTIPLE_INSTANCES_WITH_BOUNDARY_EVENT_ID);
        kieSession.signalEvent("escal-1", null, pid);
        kieSession.signalEvent("escal-2", null, pid);
        TrackingListenerAssert.assertProcessCompleted((TrackingProcessEventListener)eventListener, (String)MULTIPLE_INSTANCES_WITH_BOUNDARY_EVENT_ID);
    }

    @Test
    public void testMultipleInstancesWithSubprocessCall() {
        TrackingProcessEventListener eventListener = new TrackingProcessEventListener();
        this.addProcessEventListener((ProcessEventListener)eventListener);
        KieSession kieSession = this.createKSession(MULTIPLE_INSTANCES_WITH_CALL_SUBPROCESS);
        kieSession.startProcess(MULTIPLE_INSTANCES_WITH_CALL_SUBPROCESS_ID, Collections.singletonMap("list", new ArrayList()));
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)eventListener, (String)MULTIPLE_INSTANCES_WITH_CALL_SUBPROCESS_ID);
        kieSession.signalEvent("mi-1", null);
        kieSession.signalEvent("mi-2", null);
        TrackingListenerAssert.assertProcessCompleted((TrackingProcessEventListener)eventListener, (String)MULTIPLE_INSTANCES_WITH_CALL_SUBPROCESS_ID);
    }
}

