/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.subprocess;

import java.util.concurrent.CountDownLatch;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.jbpm.test.tools.IterableListenerAssert;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;

public class ReusableSubProcessTest
extends JbpmTestCase {
    private static final String CALL_ACTIVITY_PARENT = "org/jbpm/test/functional/subprocess/ReusableSubProcess-parent.bpmn";
    private static final String CALL_ACTIVITY_PARENT_ID = "org.jbpm.test.functional.subprocess.ReusableSubProcess-parent";
    private static final String CALL_ACTIVITY_CHILD = "org/jbpm/test/functional/subprocess/ReusableSubProcess-child.bpmn";
    private static final String CALL_ACTIVITY_CHILD_ID = "org.jbpm.test.functional.subprocess.ReusableSubProcess-child";
    private static final String ERROR_HANDLING_MAIN_PROCESS = "org/jbpm/test/functional/subprocess/ErrorHandlingMainProcess.bpmn";
    private static final String ERROR_HALDING_CHILD_PROCESS = "org/jbpm/test/functional/subprocess/ErrorHandlingSubprocess.bpmn";
    private static final String ERROR_HANDLING_MAIN_PROCESS_ID = "ExceptionHandling.MainProcess";

    public ReusableSubProcessTest() {
        super(false);
    }

    @Test(timeout=30000L)
    public void testCallActivity() {
        KieSession ksession = this.createKSession(CALL_ACTIVITY_CHILD, CALL_ACTIVITY_PARENT);
        IterableProcessEventListener eventListener = new IterableProcessEventListener();
        ksession.addEventListener((ProcessEventListener)eventListener);
        ksession.execute(ReusableSubProcessTest.getCommands().newStartProcess(CALL_ACTIVITY_PARENT_ID));
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)eventListener, (String)CALL_ACTIVITY_PARENT_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)eventListener, (String)"script");
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)eventListener, (String)"var", null, (Object)1);
        IterableListenerAssert.assertLeft((IterableProcessEventListener)eventListener, (String)"script");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)eventListener, (String)"reusable");
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)eventListener, (String)"inSubVar", null, (Object)1);
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)eventListener, (String)CALL_ACTIVITY_CHILD_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"rs-start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)eventListener, (String)"rs-script");
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)eventListener, (String)"outSubVar", null, (Object)"one");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)eventListener, (String)"rs-script");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"rs-end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)eventListener, (String)CALL_ACTIVITY_CHILD_ID);
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)eventListener, (String)"var", (Object)1, (Object)"one");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)eventListener, (String)"reusable");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)eventListener, (String)CALL_ACTIVITY_PARENT_ID);
    }

    @Test(timeout=30000L)
    public void testErrorHandlingActivity() throws Exception {
        KieSession ksession = this.createKSession(ERROR_HANDLING_MAIN_PROCESS, ERROR_HALDING_CHILD_PROCESS);
        final CountDownLatch latch = new CountDownLatch(1);
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                if ("Task".equals(event.getNodeInstance().getNodeName())) {
                    latch.countDown();
                }
            }
        });
        ksession.getWorkItemManager().registerWorkItemHandler("Rest", (WorkItemHandler)new RestWorkItemHandler());
        ksession.startProcess(ERROR_HANDLING_MAIN_PROCESS_ID);
        latch.await();
        Assertions.assertThat((long)latch.getCount()).isEqualTo(0L);
    }

    class RestWorkItemHandler
    implements WorkItemHandler {
        RestWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            throw new RuntimeException("failure for rest handler");
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }
    }
}

