/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.workitem;

import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.functional.workitem.ExceptionWorkItemHandler;
import org.jbpm.test.functional.workitem.PersistentExceptionWorkItemHandler;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.ProcessWorkItemHandlerException;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class WorkItemExceptionHandlingStrategyTest
extends JbpmTestCase {
    private static final String FAILING_PROCESS_ID = "com.sample.boolean.waitSignal";
    private static final String EXCEPTION_HANDLING_PROCESS_ID = "WaitSignal";

    public WorkItemExceptionHandlingStrategyTest() {
        super(true, true);
    }

    @Test
    public void exceptionHandlingAbortProcess() {
        KieSession kieSession = this.createSession();
        kieSession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new ExceptionWorkItemHandler(EXCEPTION_HANDLING_PROCESS_ID, ProcessWorkItemHandlerException.HandlingStrategy.ABORT.name()));
        ProcessInstance pi = kieSession.startProcess(FAILING_PROCESS_ID);
        this.assertProcessInstanceActive(pi.getId(), kieSession);
        kieSession.abortProcessInstance(pi.getId());
        this.assertProcessInstanceAborted(pi.getId());
    }

    @Test
    public void exceptionHandlingNotTriggeringSubprocessWhenPersistentException() {
        KieSession kieSession = this.createSession();
        kieSession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new PersistentExceptionWorkItemHandler(EXCEPTION_HANDLING_PROCESS_ID, ProcessWorkItemHandlerException.HandlingStrategy.ABORT.name()));
        Assertions.assertThatThrownBy(() -> kieSession.startProcess(FAILING_PROCESS_ID)).isInstanceOf(WorkflowRuntimeException.class);
    }

    private KieSession createSession() {
        this.manager = this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, null, new String[]{"org/jbpm/test/functional/workitem/BPMN2-UserTaskWithBooleanOutputWaitSignal.bpmn2", "org/jbpm/test/functional/workitem/BPMN2-WaitSignal.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession kieSession = runtimeEngine.getKieSession();
        return kieSession;
    }
}

