/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.workitem;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.drools.core.process.instance.WorkItemManager;
import org.drools.persistence.api.PersistenceContext;
import org.drools.persistence.jpa.JpaPersistenceContext;
import org.jbpm.persistence.JpaProcessPersistenceContextManager;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.functional.workitem.ExceptionWorkItemHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;

@RunWith(value=Parameterized.class)
public class RetrySyncWorkItemByJPATest
extends JbpmTestCase {
    private static final String RETRY_WORKITEM_JPA_PROCESS_ID = "org.jbpm.test.retryWorkitem-jpa";
    private boolean pessimistic;

    public RetrySyncWorkItemByJPATest(boolean pessimistic) {
        super(true, true);
        this.pessimistic = pessimistic;
    }

    @Parameterized.Parameters(name="pessimistic locking={0}")
    public static Collection<Object[]> pessimisticLocking() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    @Test
    public void workItemRecoveryTestByJPA() {
        this.addEnvironmentEntry("org.kie.api.persistence.pessimistic", this.pessimistic);
        this.addWorkItemHandler("ExceptionWorkitem", (WorkItemHandler)new ExceptionWorkItemHandler());
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/workitem/retry-workitem-jpa.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession kieSession = runtimeEngine.getKieSession();
        Environment env = kieSession.getEnvironment();
        kieSession.getEnvironment().set("org.kie.api.persistence.PersistenceContextManager", (Object)new MyJpaProcessPersistenceContextManager(env));
        ProcessInstance pi = kieSession.startProcess(RETRY_WORKITEM_JPA_PROCESS_ID);
        TaskService taskService = runtimeEngine.getTaskService();
        this.assertProcessInstanceActive(pi.getId());
        this.assertNodeTriggered(pi.getId(), new String[]{"lockingNode"});
        this.assertNodeActive(pi.getId(), kieSession, new String[]{"lockingNode"});
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        taskService.start(taskSummary.getId().longValue(), "john");
        taskService.complete(taskSummary.getId().longValue(), "john", null);
        ProcessInstance processInstance = kieSession.getProcessInstance(pi.getId());
        Collection nis = ((WorkflowProcessInstance)processInstance).getNodeInstances();
        this.retryWorkItem((WorkItemManager)kieSession.getWorkItemManager(), nis);
        this.assertProcessInstanceCompleted(processInstance.getId());
    }

    private void retryWorkItem(WorkItemManager workItemManager, Collection<NodeInstance> nis) {
        for (NodeInstance di : nis) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("exception", "no");
            workItemManager.retryWorkItem(Long.valueOf(di.getId()), map);
        }
    }

    private class MyJpaProcessPersistenceContextManager
    extends JpaProcessPersistenceContextManager {
        public MyJpaProcessPersistenceContextManager(Environment env) {
            super(env);
        }

        public PersistenceContext getCommandScopedPersistenceContext() {
            return new JpaPersistenceContext(this.getCommandScopedEntityManager(), true, RetrySyncWorkItemByJPATest.this.pessimistic, null, this.txm);
        }
    }
}

