/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.tools;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.test.listener.TrackingProcessEventListener;

public class TrackingListenerAssert {
    public static void assertTriggeredAndLeft(TrackingProcessEventListener listener, String nodeName) {
        TrackingListenerAssert.assertTriggered(listener, nodeName);
        TrackingListenerAssert.assertLeft(listener, nodeName);
    }

    public static void assertTriggered(TrackingProcessEventListener listener, String nodeName) {
        Assertions.assertThat((boolean)listener.wasNodeTriggered(nodeName)).isTrue();
    }

    public static void assertLeft(TrackingProcessEventListener listener, String nodeName) {
        Assertions.assertThat((boolean)listener.wasNodeLeft(nodeName)).isTrue();
    }

    public static void assertProcessStarted(TrackingProcessEventListener listener, String processId) {
        Assertions.assertThat((boolean)listener.wasProcessStarted(processId)).isTrue();
    }

    public static void assertProcessCompleted(TrackingProcessEventListener listener, String processId) {
        Assertions.assertThat((boolean)listener.wasProcessCompleted(processId)).isTrue();
    }

    public static void assertChangedVariable(TrackingProcessEventListener listener, String variableId) {
        Assertions.assertThat((boolean)listener.wasVariableChanged(variableId)).isTrue();
    }

    public static void assertTriggered(TrackingProcessEventListener listener, String nodeName, int count) {
        Assertions.assertThat((int)TrackingListenerAssert.containsNode(listener.getNodesTriggered(), nodeName)).isEqualTo(count);
    }

    public static void assertLeft(TrackingProcessEventListener listener, String nodeName, int count) {
        Assertions.assertThat((int)TrackingListenerAssert.containsNode(listener.getNodesLeft(), nodeName)).isEqualTo(count);
    }

    private static int containsNode(List<String> nodes, String nodeName) {
        int count = 0;
        for (String node : nodes) {
            if (!node.equals(nodeName)) continue;
            ++count;
        }
        return count;
    }
}

