/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.drools.core.command.runtime.process.SetProcessInstanceVariablesCommand;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.test.JbpmTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessPersistenceHumanTaskTest
extends JbpmTestCase {
    private static final Logger logger = LoggerFactory.getLogger(ProcessPersistenceHumanTaskTest.class);

    public ProcessPersistenceHumanTaskTest() {
        super(true, true);
    }

    @Test
    public void testProcessWithMutableDescription() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/ProcessWithMutableDescription.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processHTInput", "start");
        ProcessInstance processInstance = ksession.startProcess("processWithMutableDescription", parameters);
        ProcessInstanceLog log = (ProcessInstanceLog)this.getLogService().findProcessInstance(processInstance.getId());
        Assert.assertEquals((Object)"updated::start", (Object)log.getProcessInstanceDescription());
        parameters.put("processHTInput", "end");
        ksession.execute((Command)new SetProcessInstanceVariablesCommand(processInstance.getId(), parameters));
        log = (ProcessInstanceLog)this.getLogService().findProcessInstance(processInstance.getId());
        Assert.assertEquals((Object)"updated::end", (Object)log.getProcessInstanceDescription());
        List listIds = taskService.getTasksByProcessInstanceId(processInstance.getId());
        List list = listIds.stream().map(arg_0 -> ((TaskService)taskService).getTaskById(arg_0)).collect(Collectors.toList());
        Task task = (Task)list.get(0);
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcess() throws Exception {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        this.assertProcessInstanceActive(processInstance.getId());
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        logger.debug("Reloading the environemnt to simulate system restart");
        this.disposeRuntimeManager();
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        runtimeEngine = this.getRuntimeEngine();
        ksession = runtimeEngine.getKieSession();
        taskService = runtimeEngine.getTaskService();
        String taskGroup = "en-UK";
        List list = taskService.getTasksAssignedAsPotentialOwner("john", taskGroup);
        TaskSummary task = (TaskSummary)list.get(0);
        logger.debug("John is executing task " + task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        logger.debug("Reloading the environemnt to simulate system restart once again");
        this.disposeRuntimeManager();
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        runtimeEngine = this.getRuntimeEngine();
        ksession = runtimeEngine.getKieSession();
        taskService = runtimeEngine.getTaskService();
        String taskUser = "mary";
        list = taskService.getTasksAssignedAsPotentialOwner(taskUser, taskGroup);
        Assert.assertTrue((String)("No tasks found for potential owner " + taskUser + "/" + taskGroup), (list.size() > 0 ? 1 : 0) != 0);
        task = (TaskSummary)list.get(0);
        logger.debug("Mary is executing task " + task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceCompleted(processInstance.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactions() throws Exception {
        long processId;
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        try {
            ut.begin();
            ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
            processId = processInstance.getId();
        }
        finally {
            ut.rollback();
        }
        Assert.assertNull((Object)ksession.getProcessInstance(processId));
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)0L, (long)list.size());
    }
}

