/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.persistence.scripts.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jbpm.test.persistence.scripts.DatabaseType;

public final class SQLScriptUtil {
    private static final String REGEX_OR = "|";
    private static final String DELIMITER_STANDARD = ";";
    private static final String DELIMITER_MSSQL_SYBASE = "GO";
    private static final String DOLLAR_QUOTED_BLOCK = "\\$.*\\$";
    private static final String DELIMITER_ALTER = "@";

    public static List<String> getCommandsFromScript(File script, DatabaseType databaseType) throws IOException {
        String delimiterRegex = SQLScriptUtil.getDelimiterByFileAndDatabase(script, databaseType);
        String delimiter = delimiterRegex.indexOf(REGEX_OR) != -1 ? delimiterRegex.substring(0, delimiterRegex.indexOf(REGEX_OR)) : delimiterRegex;
        String escapedDelimiter = DELIMITER_STANDARD.equals(delimiter) ? "\\;" : delimiter;
        List scriptLines = FileUtils.readLines((File)script, (Charset)StandardCharsets.UTF_8);
        ArrayList<String> foundCommands = new ArrayList<String>();
        StringBuilder command = new StringBuilder();
        int pgBlockCounter = 0;
        for (String line : scriptLines) {
            String trimmedLine = line.trim();
            if (SQLScriptUtil.shouldSkip(trimmedLine)) continue;
            if (databaseType == DatabaseType.POSTGRESQL && trimmedLine.matches(DOLLAR_QUOTED_BLOCK)) {
                ++pgBlockCounter;
            }
            if (trimmedLine.toUpperCase().matches(delimiterRegex) && !"".equals(command.toString())) {
                foundCommands.add(command.toString());
                command.setLength(0);
                command.trimToSize();
                continue;
            }
            if (trimmedLine.contains(delimiter) && databaseType != DatabaseType.POSTGRESQL && databaseType != DatabaseType.SYBASE || trimmedLine.contains(delimiter) && databaseType == DatabaseType.POSTGRESQL && SQLScriptUtil.isEven(pgBlockCounter)) {
                SQLScriptUtil.extractCommandsFromLine(trimmedLine, escapedDelimiter, command, foundCommands);
                continue;
            }
            command.append(trimmedLine).append(" ");
        }
        if (!"".equals(command.toString())) {
            foundCommands.add(command.toString());
        }
        return foundCommands;
    }

    private static void extractCommandsFromLine(String line, String delimiter, StringBuilder bufferedCommand, List<String> extractedCommands) {
        String[] lineParts = line.split(delimiter);
        for (int i = 0; i < lineParts.length; ++i) {
            if (i == 0) {
                extractedCommands.add(bufferedCommand.toString() + " " + lineParts[i]);
                bufferedCommand.setLength(0);
                bufferedCommand.trimToSize();
                continue;
            }
            if (i == lineParts.length - 1 && !line.endsWith(delimiter)) {
                bufferedCommand.append(lineParts[i]);
                continue;
            }
            extractedCommands.add(lineParts[i]);
        }
    }

    private SQLScriptUtil() {
    }

    private static boolean shouldSkip(String trimmedLine) {
        return "".equals(trimmedLine) || trimmedLine.startsWith("--") || trimmedLine.startsWith("#") || trimmedLine.startsWith("/*") || trimmedLine.equals("SET CURRENT SCHEMA BPMS@");
    }

    private static boolean isEven(int i) {
        return i % 2 == 0;
    }

    private static String getDelimiterByFileAndDatabase(File script, DatabaseType databaseType) {
        String delimiter = DELIMITER_STANDARD;
        if (databaseType == DatabaseType.SQLSERVER || databaseType == DatabaseType.SQLSERVER2008) {
            if (script.getName().contains("quartz")) {
                delimiter = DELIMITER_MSSQL_SYBASE;
            }
            if (script.getName().contains("jbpm-6.1-to-6.2") || script.getName().contains("bpms-6.0-to-6.1")) {
                delimiter = DELIMITER_STANDARD.concat(REGEX_OR).concat(DELIMITER_MSSQL_SYBASE);
            }
        }
        if (databaseType == DatabaseType.DB2 && (script.getName().contains("bpms-6.0-to-6.1") || script.getName().contains("jbpm-6.1-to-6.2"))) {
            delimiter = DELIMITER_ALTER;
        }
        if (databaseType == DatabaseType.SYBASE) {
            delimiter = DELIMITER_MSSQL_SYBASE;
        }
        return delimiter;
    }
}

