/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.listener.process;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.drools.persistence.api.TransactionSynchronization;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCountDownProcessEventListener
extends DefaultProcessEventListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCountDownProcessEventListener.class);
    protected CountDownLatch latch;
    protected int threads;

    public DefaultCountDownProcessEventListener() {
    }

    public DefaultCountDownProcessEventListener(int threads) {
        this.threads = threads;
        this.latch = new CountDownLatch(threads);
    }

    public void waitTillCompleted() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            logger.debug("Interrputed thread while waiting for all triggers");
        }
    }

    public void waitTillCompleted(long timeOut) {
        try {
            this.latch.await(timeOut, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.debug("Interrputed thread while waiting for all triggers");
        }
    }

    public void reset(int threads) {
        this.latch = new CountDownLatch(threads);
    }

    protected void countDown() {
        try {
            TransactionManager tm = TransactionManagerFactory.get().newTransactionManager();
            if (tm != null && tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
                tm.registerTransactionSynchronization(new TransactionSynchronization(){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int status) {
                        DefaultCountDownProcessEventListener.this.latch.countDown();
                    }
                });
            } else {
                this.latch.countDown();
            }
        }
        catch (Exception e) {
            this.latch.countDown();
        }
    }

    public void reset() {
        this.latch = new CountDownLatch(this.threads);
    }
}

