/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.persistence.scripts;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.hibernate.Version;
import org.jbpm.test.persistence.scripts.PersistenceUnit;
import org.jbpm.test.persistence.scripts.TestPersistenceContextBase;
import org.jbpm.test.persistence.scripts.util.ScriptFilter;
import org.jbpm.test.persistence.scripts.util.TestsUtil;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptsBase {
    protected static final String DB_DDL_SCRIPTS_RESOURCE_PATH = "/db/ddl-scripts";
    protected static final String TEST_PROCESS_ID = "minimalProcess";
    private static final Logger logger = LoggerFactory.getLogger(ScriptsBase.class);
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            logger.info(">>>> Starting test: " + description.getMethodName());
        }
    };

    @BeforeClass
    public static void cleanUp() throws IOException, SQLException {
        logger.info("Running with Hibernate " + Version.getVersionString());
        TestsUtil.clearSchema();
        ScriptsBase.executeScriptRunner(DB_DDL_SCRIPTS_RESOURCE_PATH, ScriptFilter.init(false, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeScriptRunner(String resourcePath, ScriptFilter scriptFilter, String type) throws IOException, SQLException {
        TestPersistenceContextBase scriptRunnerContext = TestPersistenceContextBase.createAndInitContext(PersistenceUnit.SCRIPT_RUNNER);
        try {
            scriptRunnerContext.executeScripts(new File(ScriptsBase.class.getResource(resourcePath).getFile()), scriptFilter, type);
        }
        finally {
            scriptRunnerContext.clean();
        }
    }

    public static void executeScriptRunner(String resourcePath, ScriptFilter scriptFilter) throws IOException, SQLException {
        TestPersistenceContextBase scriptRunnerContext = TestPersistenceContextBase.createAndInitContext(PersistenceUnit.SCRIPT_RUNNER);
        try {
            scriptRunnerContext.executeScripts(new File(ScriptsBase.class.getResource(resourcePath).getFile()), scriptFilter);
        }
        finally {
            scriptRunnerContext.clean();
        }
    }
}

