/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.persistence.scripts.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.jbpm.test.persistence.scripts.DatabaseType;
import org.jbpm.test.persistence.scripts.DistributionType;

public class ScriptFilter {
    private Set<DatabaseType> dbTypes;
    private Set<Option> options;
    private List<Predicate<File>> predicates = new ArrayList<Predicate<File>>();
    private Map<String, Object> env;

    @SafeVarargs
    public ScriptFilter(Predicate<File> ... filters) {
        this.options = new TreeSet<Option>();
        this.dbTypes = new TreeSet<DatabaseType>();
        Collections.addAll(this.dbTypes, DatabaseType.values());
        Collections.addAll(this.predicates, filters);
        this.env = new HashMap<String, Object>();
    }

    @SafeVarargs
    public static ScriptFilter create(Predicate<File> ... filters) {
        return new ScriptFilter(filters);
    }

    public static ScriptFilter filter(String ... scripts) {
        Predicate predicate = Arrays.asList(scripts).stream().map(s -> file -> file.getName().contains((CharSequence)s)).reduce(x -> false, Predicate::or);
        ScriptFilter filter = new ScriptFilter(predicate);
        return filter;
    }

    public ScriptFilter env(String key, Object value) {
        this.env.put(key, value);
        return this;
    }

    public static ScriptFilter init(boolean springboot, boolean create) {
        Predicate<File> filterExtension = file -> file.getName().toLowerCase().endsWith(".sql");
        Predicate<File> filterSpringboot = file -> file.getName().toLowerCase().contains("springboot");
        filterSpringboot = springboot ? filterSpringboot : filterSpringboot.negate();
        Predicate<File> filterBytea = file -> !file.getName().toLowerCase().contains("bytea");
        Predicate<File> filterName = file -> file.getName().contains("drop");
        filterName = !create ? filterName : filterName.negate();
        ScriptFilter filter = new ScriptFilter(filterExtension, filterName, filterSpringboot, filterBytea);
        if (create) {
            filter.setOptions(Option.DISALLOW_EMTPY_RESULTS, Option.THROW_ON_SCRIPT_ERROR);
        }
        return filter;
    }

    public ScriptFilter setSupportedDatabase(DatabaseType ... types) {
        this.dbTypes.clear();
        Collections.addAll(this.dbTypes, types);
        return this;
    }

    public ScriptFilter setDistribution(DistributionType type) {
        this.predicates.add(type.predicate);
        return this;
    }

    public boolean isSupportedDatabase(DatabaseType type) {
        return this.dbTypes.contains((Object)type);
    }

    public ScriptFilter setOptions(Option ... elements) {
        Collections.addAll(this.options, elements);
        return this;
    }

    public boolean hasOption(Option option) {
        return this.options.contains((Object)option);
    }

    public Predicate<File> build() {
        return this.predicates.stream().reduce(x -> true, Predicate::and);
    }

    public Set<DatabaseType> getSupportedDatabase() {
        return this.dbTypes;
    }

    public Map<String, Object> getEnvironent() {
        return this.env;
    }

    public static enum Option {
        DISALLOW_EMTPY_RESULTS,
        THROW_ON_SCRIPT_ERROR;

    }
}

