/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.util;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.SecureRandom;
import javax.net.ServerSocketFactory;

public final class SocketUtils {
    static final int PORT_RANGE_MIN = 49152;
    static final int PORT_RANGE_MAX = 65535;
    private static final SecureRandom RND = new SecureRandom();

    private SocketUtils() {
    }

    public static int findAvailablePort() {
        int candidatePort;
        int portRange = 16383;
        int searchCounter = 0;
        do {
            if (searchCounter > portRange) {
                throw new IllegalStateException(String.format("Could not find an available port in the range [%d, %d] after %d attempts", 49152, 65535, searchCounter));
            }
            candidatePort = SocketUtils.findRandomPort(49152, 65535);
            ++searchCounter;
        } while (!SocketUtils.isPortAvailable(candidatePort));
        return candidatePort;
    }

    private static int findRandomPort(int minPort, int maxPort) {
        int portRange = maxPort - minPort;
        return minPort + RND.nextInt(portRange + 1);
    }

    public static boolean isPortAvailable(int port) {
        boolean bl;
        block8: {
            ServerSocket ignored = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
            try {
                bl = true;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }
}

