/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jbpm.test.util;

import org.junit.Test;

import static org.junit.Assert.assertEquals;


public class DatabaseScriptTest {

    @Test
    public void test() {
        DatabaseScript script = new DatabaseScript("jbpm-7.58-to-7.59-CorrelationKeyInfo_name.sql");
        assertEquals("7.58", script.getFrom().toString());
        assertEquals("7.59", script.getTo().toString());
        assertEquals("CorrelationKeyInfo_name", script.getQualifier());
    }
}
