/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.util;

public enum CaseStatus {
    OPEN("Open"),
    CLOSED("Closed"),
    CANCELED("Canceled");

    private String label;

    private CaseStatus(String label) {
        this.label = label;
    }

    public static CaseStatus fromName(String name) {
        return CaseStatus.valueOf(name.toUpperCase());
    }

    public static CaseStatus fromId(Integer id) {
        switch (id) {
            case 1: {
                return OPEN;
            }
            case 2: {
                return CLOSED;
            }
            case 3: {
                return CANCELED;
            }
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public Integer getId() {
        switch (this) {
            case OPEN: {
                return 1;
            }
            case CLOSED: {
                return 2;
            }
            case CANCELED: {
                return 3;
            }
        }
        return null;
    }
}

