/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.roles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jbpm.workbench.cm.client.roles.CaseRolesPresenter;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenterTest;
import org.jbpm.workbench.cm.client.util.CaseRolesAssignmentFilterBy;
import org.jbpm.workbench.cm.client.util.CaseRolesValidations;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseRolesPresenterTest
extends AbstractCaseInstancePresenterTest {
    private static final String USER = "User";
    private static final String GROUP = "Group";
    private static final String CASE_ROLE = "Role";
    private static final String CASE_DEFINITION_ID = "org.jbpm.case";
    @Mock
    CaseRolesPresenter.CaseRolesView view;
    @Mock
    CaseRolesValidations caseRolesValidations;
    @Mock
    CaseRolesPresenter.EditRoleAssignmentView editRoleAssignmentView;
    @InjectMocks
    CaseRolesPresenter presenter;
    final String serverTemplateId = "serverTemplateId";
    final CaseInstanceSummary caseInstance = CaseRolesPresenterTest.newCaseInstanceSummary();
    CaseDefinitionSummary caseDefinition;

    public CaseRolesPresenter getPresenter() {
        return this.presenter;
    }

    @Before
    public void setUp() {
        Mockito.when((Object)this.view.getFilterValue()).thenReturn((Object)CaseRolesAssignmentFilterBy.ALL.getLabel());
    }

    @Test
    public void testClearCaseInstance() {
        this.presenter.clearCaseInstance();
        this.verifyClearCaseInstance();
    }

    private void verifyClearCaseInstance() {
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).removeAllRoles();
    }

    @Test
    public void testLoadCaseInstance() {
        this.caseDefinition = CaseDefinitionSummary.builder().roles(Collections.singletonMap(CASE_ROLE, 3)).build();
        this.caseInstance.setRoleAssignments(Collections.singletonList(CaseRoleAssignmentSummary.builder().name(CASE_ROLE).groups(Collections.singletonList(GROUP)).users(Collections.singletonList(USER)).build()));
        this.setCaseDefinitionID(CASE_DEFINITION_ID, this.caseDefinition, this.caseInstance);
        Mockito.when((Object)this.caseManagementService.getCaseDefinition("serverTemplateId", this.caseInstance.getContainerId(), this.caseInstance.getCaseDefinitionId())).thenReturn((Object)this.caseDefinition);
        this.setupCaseInstance(this.caseInstance, "serverTemplateId");
        this.verifyClearCaseInstance();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).setRolesAssignmentList((List)captor.capture());
        Assert.assertEquals((long)1L, (long)((List)captor.getValue()).size());
        Assert.assertEquals((Object)CASE_ROLE, (Object)((CaseRoleAssignmentSummary)((List)captor.getValue()).get(0)).getName());
        Assert.assertEquals((Object)USER, ((CaseRoleAssignmentSummary)((List)captor.getValue()).get(0)).getUsers().get(0));
        Assert.assertEquals((Object)GROUP, ((CaseRoleAssignmentSummary)((List)captor.getValue()).get(0)).getGroups().get(0));
    }

    @Test
    public void testFiltering() {
        String caseRole_1 = "Role_1";
        String caseRole_2 = "Role_2";
        String caseRole_3 = "Role_3";
        HashMap<String, Integer> roles = new HashMap<String, Integer>();
        roles.put("Role_1", -1);
        roles.put("Role_2", 2);
        roles.put("Role_3", 1);
        CaseDefinitionSummary caseDefinition = CaseDefinitionSummary.builder().roles(roles).build();
        CaseInstanceSummary caseInstance = CaseRolesPresenterTest.newCaseInstanceSummary();
        caseInstance.setRoleAssignments(Arrays.asList(this.createTestCaseRoleAssignmentSummary("Role_1", Arrays.asList(USER), Arrays.asList(GROUP)), this.createTestCaseRoleAssignmentSummary("Role_2", Collections.EMPTY_LIST, Collections.EMPTY_LIST), this.createTestCaseRoleAssignmentSummary("Role_3", Collections.EMPTY_LIST, Arrays.asList(GROUP))));
        this.setCaseDefinitionID(CASE_DEFINITION_ID, caseDefinition, caseInstance);
        Mockito.when((Object)this.caseManagementService.getCaseDefinition("serverTemplateId", caseInstance.getContainerId(), caseInstance.getCaseDefinitionId())).thenReturn((Object)caseDefinition);
        this.setupCaseInstance(caseInstance, "serverTemplateId");
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).setRolesAssignmentList((List)captor.capture());
        Assert.assertEquals((long)3L, (long)((List)captor.getValue()).size());
        Assert.assertEquals((Object)"Role_1", (Object)((CaseRoleAssignmentSummary)((List)captor.getValue()).get(0)).getName());
        Assert.assertEquals((Object)"Role_2", (Object)((CaseRoleAssignmentSummary)((List)captor.getValue()).get(1)).getName());
        Assert.assertEquals((Object)"Role_3", (Object)((CaseRoleAssignmentSummary)((List)captor.getValue()).get(2)).getName());
        Assert.assertEquals((Object)USER, ((CaseRoleAssignmentSummary)((List)captor.getValue()).get(0)).getUsers().get(0));
        Assert.assertEquals((Object)GROUP, ((CaseRoleAssignmentSummary)((List)captor.getValue()).get(0)).getGroups().get(0));
        Assert.assertEquals((Object)GROUP, ((CaseRoleAssignmentSummary)((List)captor.getValue()).get(2)).getGroups().get(0));
        Mockito.when((Object)this.view.getFilterValue()).thenReturn((Object)CaseRolesAssignmentFilterBy.ASSIGNED.getLabel());
        this.presenter.filterElements();
        ArgumentCaptor captor2 = ArgumentCaptor.forClass(List.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setRolesAssignmentList((List)captor2.capture());
        Assert.assertEquals((long)2L, (long)((List)captor2.getValue()).size());
        Assert.assertEquals((Object)"Role_1", (Object)((CaseRoleAssignmentSummary)((List)captor2.getValue()).get(0)).getName());
        Assert.assertEquals((Object)"Role_3", (Object)((CaseRoleAssignmentSummary)((List)captor2.getValue()).get(1)).getName());
        Assert.assertEquals((Object)USER, ((CaseRoleAssignmentSummary)((List)captor2.getValue()).get(0)).getUsers().get(0));
        Assert.assertEquals((Object)GROUP, ((CaseRoleAssignmentSummary)((List)captor2.getValue()).get(0)).getGroups().get(0));
        Assert.assertEquals((Object)GROUP, ((CaseRoleAssignmentSummary)((List)captor2.getValue()).get(1)).getGroups().get(0));
        Mockito.when((Object)this.view.getFilterValue()).thenReturn((Object)CaseRolesAssignmentFilterBy.UNASSIGNED.getLabel());
        this.presenter.filterElements();
        ArgumentCaptor captor3 = ArgumentCaptor.forClass(List.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).setRolesAssignmentList((List)captor3.capture());
        Assert.assertEquals((long)1L, (long)((List)captor3.getValue()).size());
        Assert.assertEquals((Object)"Role_2", (Object)((CaseRoleAssignmentSummary)((List)captor3.getValue()).get(0)).getName());
    }

    @Test
    public void testEditAction() {
        String newUser = "userTest";
        String newGroup = "groupTest";
        this.loadTestCase();
        CaseRoleAssignmentSummary caseRoleAssignmentSummary = this.createTestCaseRoleAssignmentSummary(CASE_ROLE, new ArrayList<String>(Arrays.asList(USER, newUser)), new ArrayList<String>(Arrays.asList(GROUP, newGroup)));
        CaseRoleAssignmentSummary previous = this.createTestCaseRoleAssignmentSummary(CASE_ROLE, Collections.singletonList(USER), Collections.singletonList(GROUP));
        Mockito.when((Object)this.editRoleAssignmentView.getValue()).thenReturn((Object)caseRoleAssignmentSummary);
        this.presenter.editAction(previous);
        ArgumentCaptor captor = ArgumentCaptor.forClass(CaseRoleAssignmentSummary.class);
        ((CaseRolesPresenter.EditRoleAssignmentView)Mockito.verify((Object)this.editRoleAssignmentView)).setValue(captor.capture());
        Assert.assertTrue((captor.getValue() != caseRoleAssignmentSummary ? 1 : 0) != 0);
        Assert.assertEquals((Object)((CaseRoleAssignmentSummary)captor.getValue()).getName(), (Object)caseRoleAssignmentSummary.getName());
        ArgumentCaptor commandArgumentCaptor = ArgumentCaptor.forClass(Command.class);
        ((CaseRolesPresenter.EditRoleAssignmentView)Mockito.verify((Object)this.editRoleAssignmentView)).show((Command)commandArgumentCaptor.capture());
        Command cmd = (Command)commandArgumentCaptor.getValue();
        cmd.execute();
        ((CaseRolesPresenter.EditRoleAssignmentView)Mockito.verify((Object)this.editRoleAssignmentView)).hide();
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).assignUserToRole((String)Matchers.eq((Object)"serverTemplateId"), (String)Matchers.eq((Object)this.caseInstance.getContainerId()), (String)Matchers.eq((Object)this.caseInstance.getCaseId()), (String)Matchers.eq((Object)CASE_ROLE), (String)Matchers.eq((Object)newUser));
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).assignGroupToRole((String)Matchers.eq((Object)"serverTemplateId"), (String)Matchers.eq((Object)this.caseInstance.getContainerId()), (String)Matchers.eq((Object)this.caseInstance.getCaseId()), (String)Matchers.eq((Object)CASE_ROLE), (String)Matchers.eq((Object)newGroup));
    }

    @Test
    public void testSetupNewRoleAssignments_rolesNotDefined() {
        CaseDefinitionSummary caseDefinition = CaseDefinitionSummary.builder().build();
        CaseInstanceSummary caseInstance = CaseRolesPresenterTest.newCaseInstanceSummary();
        this.setCaseDefinitionID(CASE_DEFINITION_ID, caseDefinition, caseInstance);
        Mockito.when((Object)this.caseManagementService.getCaseDefinition(Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)CASE_DEFINITION_ID))).thenReturn((Object)caseDefinition);
        this.presenter.setupExistingAssignments(caseInstance);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setRolesAssignmentList(Mockito.anyList());
    }

    @Test
    public void testAssignToRole_rolesAvailableForAssignment() {
        CaseRoleAssignmentSummary previous = this.createTestCaseRoleAssignmentSummary(CASE_ROLE, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        CaseRoleAssignmentSummary editedRoleAssignmentSummary = this.createTestCaseRoleAssignmentSummary(CASE_ROLE, new ArrayList<String>(Arrays.asList("user1", "user2", "user3")), Collections.EMPTY_LIST);
        Mockito.when((Object)this.editRoleAssignmentView.getValue()).thenReturn((Object)editedRoleAssignmentSummary);
        Mockito.when((Object)this.caseRolesValidations.validateRolesAssignments((CaseDefinitionSummary)Mockito.any(CaseDefinitionSummary.class), Mockito.anyList())).thenReturn(Arrays.asList("error"));
        this.presenter.setupExistingAssignments(this.caseInstance);
        this.presenter.assignToRole(previous);
        ((CaseRolesPresenter.EditRoleAssignmentView)Mockito.verify((Object)this.editRoleAssignmentView)).showValidationError(Mockito.anyList());
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.never())).assignUserToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        Mockito.when((Object)this.caseRolesValidations.validateRolesAssignments((CaseDefinitionSummary)Mockito.any(CaseDefinitionSummary.class), Mockito.anyList())).thenReturn((Object)Collections.EMPTY_LIST);
        CaseRoleAssignmentSummary editedRoleAssignmentSummary2 = this.createTestCaseRoleAssignmentSummary(CASE_ROLE, new ArrayList<String>(Arrays.asList("user1", "user2")), Collections.EMPTY_LIST);
        Mockito.when((Object)this.editRoleAssignmentView.getValue()).thenReturn((Object)editedRoleAssignmentSummary2);
        this.presenter.assignToRole(previous);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)2))).assignUserToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testStoreRoleAssignments_noChangesInRoleAssignments() {
        CaseRoleAssignmentSummary cras = CaseRoleAssignmentSummary.builder().name(CASE_ROLE).users(Collections.singletonList(USER)).groups(Collections.singletonList(GROUP)).build();
        this.presenter.storeRoleAssignments(cras, new ArrayList<String>(Arrays.asList(USER)), new ArrayList<String>(Arrays.asList(GROUP)));
        this.verifyStoreRoleAssignmentsCalls(0, 0, 0, 0);
    }

    @Test
    public void testStoreRoleAssignments_removePreviousUser() {
        CaseRoleAssignmentSummary cras = CaseRoleAssignmentSummary.builder().name(CASE_ROLE).users(Arrays.asList(USER, "test_user")).groups(Arrays.asList(GROUP, "test_group")).build();
        this.presenter.storeRoleAssignments(cras, new ArrayList<String>(Arrays.asList(USER)), new ArrayList<String>(Arrays.asList(GROUP)));
        this.verifyStoreRoleAssignmentsCalls(0, 0, 1, 1);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeUserFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)"test_user"));
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeGroupFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)"test_group"));
    }

    @Test
    public void testStoreRoleAssignments_replaceAssignment() {
        CaseRoleAssignmentSummary cras = this.createTestCaseRoleAssignmentSummary(CASE_ROLE, Collections.singletonList("test_user"), Collections.singletonList("test_group"));
        this.presenter.storeRoleAssignments(cras, new ArrayList<String>(Arrays.asList(USER)), new ArrayList<String>(Arrays.asList(GROUP)));
        this.verifyStoreRoleAssignmentsCalls(1, 1, 1, 1);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).assignUserToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)USER));
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).assignGroupToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)GROUP));
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeUserFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)"test_user"));
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeGroupFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)"test_group"));
    }

    private void verifyStoreRoleAssignmentsCalls(int timesAddUser, int timesAddGroup, int timesRemoveUser, int timesRemoveGroup) {
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)timesAddUser))).assignUserToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)timesAddGroup))).assignGroupToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)timesRemoveUser))).removeUserFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)timesRemoveGroup))).removeGroupFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
    }

    private void setCaseDefinitionID(String caseDefinitionID, CaseDefinitionSummary caseDefinition, CaseInstanceSummary caseInstance) {
        caseDefinition.setId(caseDefinitionID);
        caseInstance.setCaseDefinitionId(caseDefinitionID);
    }

    private CaseRoleAssignmentSummary createTestCaseRoleAssignmentSummary(String roleName, List<String> users, List<String> groups) {
        return CaseRoleAssignmentSummary.builder().name(roleName).users(users).groups(groups).build();
    }

    private void loadTestCase() {
        this.caseDefinition = CaseDefinitionSummary.builder().roles(Collections.singletonMap(CASE_ROLE, 3)).build();
        this.setCaseDefinitionID(CASE_DEFINITION_ID, this.caseDefinition, this.caseInstance);
        Mockito.when((Object)this.caseManagementService.getCaseDefinition("serverTemplateId", this.caseInstance.getContainerId(), this.caseInstance.getCaseDefinitionId())).thenReturn((Object)this.caseDefinition);
        this.setupCaseInstance(this.caseInstance, "serverTemplateId");
    }
}

