/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.cm.client.util.CaseRolesValidations;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseRolesValidationsTest {
    @Mock
    TranslationService translationService;
    @InjectMocks
    CaseRolesValidations caseRolesValidations;

    @Test
    public void testValidateRolesAssignments_SingleAssignmentUser() {
        Map<String, Integer> role = Collections.singletonMap("test", 1);
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().roles(role).build();
        List<CaseRoleAssignmentSummary> roles = Collections.singletonList(CaseRoleAssignmentSummary.builder().name("test").users(Collections.singletonList("user1")).build());
        List errors = this.caseRolesValidations.validateRolesAssignments(cds, roles);
        Assert.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testValidateRolesAssignments_SingleAssignmentGroup() {
        Map<String, Integer> role = Collections.singletonMap("test", 1);
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().roles(role).build();
        List<CaseRoleAssignmentSummary> roles = Collections.singletonList(CaseRoleAssignmentSummary.builder().name("test").groups(Collections.singletonList("group1")).build());
        List errors = this.caseRolesValidations.validateRolesAssignments(cds, roles);
        Assert.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testValidateRolesAssignments_InvalidAssignment() {
        Map<String, Integer> role = Collections.singletonMap("test", 1);
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().roles(role).build();
        List<CaseRoleAssignmentSummary> roles = Collections.singletonList(CaseRoleAssignmentSummary.builder().name("test").users(Collections.singletonList("user1")).groups(Collections.singletonList("group1")).build());
        List errors = this.caseRolesValidations.validateRolesAssignments(cds, roles);
        Assert.assertFalse((boolean)errors.isEmpty());
    }

    @Test
    public void testValidateRolesAssignments_MultipleAssignments() {
        Map<String, Integer> role = Collections.singletonMap("test", -1);
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().roles(role).build();
        List<CaseRoleAssignmentSummary> roles = Collections.singletonList(CaseRoleAssignmentSummary.builder().name("test").users(Collections.singletonList("user1")).groups(Collections.singletonList("group1")).build());
        List errors = this.caseRolesValidations.validateRolesAssignments(cds, roles);
        Assert.assertTrue((boolean)errors.isEmpty());
    }
}

