/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jbpm.workbench.common.preferences;

import java.lang.RuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.preferences.shared.annotations.PortablePreference;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.PropertyFormType;
import org.uberfire.preferences.shared.PropertyValidator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Portable( mapSuperTypes = true )
@PortablePreference
@Generated("org.uberfire.ext.preferences.processors.WorkbenchPreferenceProcessor")
/*
* WARNING! This class is generated. Do not modify.
*/
public class ManagePreferencesPortableGeneratedImpl extends ManagePreferences implements BasePreferencePortable<ManagePreferences> {

    public ManagePreferencesPortableGeneratedImpl() {
    }

    public ManagePreferencesPortableGeneratedImpl( @MapsTo("itemsPerPage") java.lang.Integer itemsPerPage, @MapsTo("processInstanceDiagramCompletedNodeColor") java.lang.String processInstanceDiagramCompletedNodeColor, @MapsTo("processInstanceDiagramCompletedNodeBorderColor") java.lang.String processInstanceDiagramCompletedNodeBorderColor, @MapsTo("processInstanceDiagramActiveNodeBorderColor") java.lang.String processInstanceDiagramActiveNodeBorderColor ) {
        setItemsPerPage( itemsPerPage );
        setProcessInstanceDiagramCompletedNodeColor( processInstanceDiagramCompletedNodeColor );
        setProcessInstanceDiagramCompletedNodeBorderColor( processInstanceDiagramCompletedNodeBorderColor );
        setProcessInstanceDiagramActiveNodeBorderColor( processInstanceDiagramActiveNodeBorderColor );
    }

    @Override
    public Class<ManagePreferences> getPojoClass() {
        return ManagePreferences.class;
    }

    @Override
    public String identifier() {
        return "ManagePreferences";
    }

    @Override
    public String[] parents() {
        return new String[] { "" };
    }

    @Override
    public String bundleKey() {
        return "ManagePreferences.Label";
    }

    @Override
    public void set( String property, Object value ) {
        if ( property.equals( "itemsPerPage" ) ) {
            setItemsPerPage( (java.lang.Integer) value );
        } else
        if ( property.equals( "processInstanceDiagramCompletedNodeColor" ) ) {
            setProcessInstanceDiagramCompletedNodeColor( (java.lang.String) value );
        } else
        if ( property.equals( "processInstanceDiagramCompletedNodeBorderColor" ) ) {
            setProcessInstanceDiagramCompletedNodeBorderColor( (java.lang.String) value );
        } else
        if ( property.equals( "processInstanceDiagramActiveNodeBorderColor" ) ) {
            setProcessInstanceDiagramActiveNodeBorderColor( (java.lang.String) value );
        } else
        {
            throw new RuntimeException( "Unknown property: " + property );
        }
    }

    @Override
    public Object get( String property ) {
        if ( property.equals( "itemsPerPage" ) ) {
            return getItemsPerPage();
        } else
        if ( property.equals( "processInstanceDiagramCompletedNodeColor" ) ) {
            return getProcessInstanceDiagramCompletedNodeColor();
        } else
        if ( property.equals( "processInstanceDiagramCompletedNodeBorderColor" ) ) {
            return getProcessInstanceDiagramCompletedNodeBorderColor();
        } else
        if ( property.equals( "processInstanceDiagramActiveNodeBorderColor" ) ) {
            return getProcessInstanceDiagramActiveNodeBorderColor();
        } else
        {
            throw new RuntimeException( "Unknown property: " + property );
        }
    }

    @Override
    public Map<String, PropertyFormType> getPropertiesTypes() {
        Map<String, PropertyFormType> propertiesTypes = new HashMap<>();

        propertiesTypes.put( "itemsPerPage", PropertyFormType.NATURAL_NUMBER);
        propertiesTypes.put( "processInstanceDiagramCompletedNodeColor", PropertyFormType.COLOR);
        propertiesTypes.put( "processInstanceDiagramCompletedNodeBorderColor", PropertyFormType.COLOR);
        propertiesTypes.put( "processInstanceDiagramActiveNodeBorderColor", PropertyFormType.COLOR);

        return propertiesTypes;
    }

    @Override
    public Map<String, List<PropertyValidator>> getPropertiesValidators() {
        Map<String, List<PropertyValidator>> validatorsByProperty = new HashMap<>();

        List<PropertyValidator> validatorsItemsPerPage = new ArrayList<>();
        validatorsItemsPerPage.add(new org.jbpm.workbench.common.preferences.ItemPerPageValidator());
        validatorsByProperty.put("itemsPerPage", validatorsItemsPerPage);


        return validatorsByProperty;
    }

    @Override
    public boolean equals( final Object o ) {
        if ( this == o ) {
            return true;
        }
        if ( o == null || getClass() != o.getClass() ) {
            return false;
        }

        final ManagePreferencesPortableGeneratedImpl that = (ManagePreferencesPortableGeneratedImpl) o;

        if ( getItemsPerPage() != null ? !getItemsPerPage().equals( that.getItemsPerPage() ) : that.getItemsPerPage() != null ) {
            return false;
        }
        if ( getProcessInstanceDiagramCompletedNodeColor() != null ? !getProcessInstanceDiagramCompletedNodeColor().equals( that.getProcessInstanceDiagramCompletedNodeColor() ) : that.getProcessInstanceDiagramCompletedNodeColor() != null ) {
            return false;
        }
        if ( getProcessInstanceDiagramCompletedNodeBorderColor() != null ? !getProcessInstanceDiagramCompletedNodeBorderColor().equals( that.getProcessInstanceDiagramCompletedNodeBorderColor() ) : that.getProcessInstanceDiagramCompletedNodeBorderColor() != null ) {
            return false;
        }
        if ( getProcessInstanceDiagramActiveNodeBorderColor() != null ? !getProcessInstanceDiagramActiveNodeBorderColor().equals( that.getProcessInstanceDiagramActiveNodeBorderColor() ) : that.getProcessInstanceDiagramActiveNodeBorderColor() != null ) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;

        result = 31 * result + ( getItemsPerPage() != null ? getItemsPerPage().hashCode() : 0 );
        result = ~~result;
        result = 31 * result + ( getProcessInstanceDiagramCompletedNodeColor() != null ? getProcessInstanceDiagramCompletedNodeColor().hashCode() : 0 );
        result = ~~result;
        result = 31 * result + ( getProcessInstanceDiagramCompletedNodeBorderColor() != null ? getProcessInstanceDiagramCompletedNodeBorderColor().hashCode() : 0 );
        result = ~~result;
        result = 31 * result + ( getProcessInstanceDiagramActiveNodeBorderColor() != null ? getProcessInstanceDiagramActiveNodeBorderColor().hashCode() : 0 );
        result = ~~result;

        return result;
    }

    @Override
    public boolean isPersistable() {
        return true;
    }
}
