/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.client.panel;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.DataSetHandler;
import org.dashbuilder.displayer.client.DataSetHandlerImpl;
import org.dashbuilder.displayer.client.DisplayerCoordinator;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.client.formatter.ValueFormatter;
import org.dashbuilder.renderer.client.metric.MetricDisplayer;
import org.dashbuilder.renderer.client.table.TableDisplayer;
import org.jboss.errai.common.client.dom.Element;
import org.jbpm.dashboard.renderer.client.panel.formatter.DurationFormatter;
import org.jbpm.dashboard.renderer.client.panel.i18n.DashboardI18n;
import org.jbpm.dashboard.renderer.client.panel.widgets.ProcessBreadCrumb;
import org.jbpm.workbench.common.client.menu.PrimaryActionMenuBuilder;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.ks.integration.ConsoleDataSetLookup;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ClosePlaceEvent;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.Commands;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

public abstract class AbstractDashboard {
    protected DataSetClientServices dataSetClientServices;
    protected PlaceManager placeManager;
    protected DashboardI18n i18n;
    protected MetricDisplayer selectedMetric = null;
    protected String selectedProcess = null;
    protected ProcessBreadCrumb processBreadCrumb;
    protected DisplayerLocator displayerLocator;
    protected DisplayerCoordinator displayerCoordinator;
    protected ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder;
    UberfireBreadcrumbs breadcrumbs;
    protected Event<NotificationEvent> notificationEvent;
    private PerspectiveManager perspectiveManager;
    private String detailScreenId;

    @Inject
    public void setNotificationEvent(Event<NotificationEvent> notificationEvent) {
        this.notificationEvent = notificationEvent;
    }

    public String getPerspectiveId() {
        return this.perspectiveManager.getCurrentPerspective().getIdentifier();
    }

    protected void displayNotification(String message) {
        this.notificationEvent.fire((Object)new NotificationEvent(message));
    }

    public AbstractDashboard() {
    }

    public AbstractDashboard(DataSetClientServices dataSetClientServices, PlaceManager placeManager, DashboardI18n i18n, ProcessBreadCrumb processBreadCrumb, DisplayerLocator displayerLocator, DisplayerCoordinator displayerCoordinator, ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder) {
        this.dataSetClientServices = dataSetClientServices;
        this.placeManager = placeManager;
        this.i18n = i18n;
        this.processBreadCrumb = processBreadCrumb;
        this.displayerLocator = displayerLocator;
        this.displayerCoordinator = displayerCoordinator;
        this.serverTemplateSelectorMenuBuilder = serverTemplateSelectorMenuBuilder;
    }

    @PostConstruct
    public void setBreadcrumbs() {
        this.createListBreadcrumb();
        this.breadcrumbs.addToolbar(this.getPerspectiveId(), (Element)this.serverTemplateSelectorMenuBuilder.getView().getElement());
    }

    @Inject
    public void setServerTemplateSelectorMenuBuilder(ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder) {
        this.serverTemplateSelectorMenuBuilder = serverTemplateSelectorMenuBuilder;
    }

    public abstract void showTable();

    public abstract void showDashboard();

    public abstract void createListBreadcrumb();

    public abstract void tableRedraw();

    public void setupListBreadcrumb(String listLabel) {
        this.breadcrumbs.clearBreadcrumbs(this.getPerspectiveId());
        this.breadcrumbs.addBreadCrumb(this.getPerspectiveId(), this.i18n.Home(), () -> this.placeManager.goTo("HomePerspective"));
        this.breadcrumbs.addBreadCrumb(this.getPerspectiveId(), listLabel, Commands.DO_NOTHING);
    }

    public void setupDetailBreadcrumb(String listLabel, String detailLabel, String detailScreenId) {
        this.breadcrumbs.clearBreadcrumbs(this.getPerspectiveId());
        this.breadcrumbs.addBreadCrumb(this.getPerspectiveId(), this.i18n.Home(), () -> this.placeManager.goTo("HomePerspective"));
        this.breadcrumbs.addBreadCrumb(this.getPerspectiveId(), listLabel, () -> this.closeDetails(detailScreenId));
        this.breadcrumbs.addBreadCrumb(this.getPerspectiveId(), detailLabel, Commands.DO_NOTHING);
        this.detailScreenId = detailScreenId;
    }

    private void closeDetails(String detailScreenId) {
        this.placeManager.closePlace(detailScreenId);
        this.createListBreadcrumb();
        this.tableRedraw();
    }

    public void onDetailScreenClosed(@Observes ClosePlaceEvent closed) {
        if (closed.getPlace() != null && this.detailScreenId != null && this.detailScreenId.equals(closed.getPlace().getIdentifier())) {
            this.createListBreadcrumb();
            this.tableRedraw();
        }
    }

    public Menus getMenus() {
        PrimaryActionMenuBuilder viewTableAction = new PrimaryActionMenuBuilder(this.i18n.viewTable(), "fa-table", this.i18n.viewTable(), () -> this.showTable(), true);
        PrimaryActionMenuBuilder viewDashboardAction = new PrimaryActionMenuBuilder(this.i18n.viewDashboard(), "fa-th", this.i18n.viewDashboard(), () -> this.showDashboard(), true);
        viewTableAction.addChangeListener(enabled -> {
            viewTableAction.setVisible(false);
            viewDashboardAction.setVisible(true);
        });
        viewDashboardAction.addChangeListener(enabled -> {
            viewTableAction.setVisible(true);
            viewDashboardAction.setVisible(false);
        });
        viewTableAction.setVisible(true);
        viewDashboardAction.setVisible(false);
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)viewTableAction).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)viewDashboardAction).endMenu()).build();
    }

    public MetricDisplayer createMetricDisplayer(DisplayerSettings settings) {
        PortablePreconditions.checkNotNull((String)"displayerSettings", (Object)settings);
        MetricDisplayer metricDisplayer = (MetricDisplayer)this.displayerLocator.lookupDisplayer(settings);
        metricDisplayer.setDisplayerSettings(settings);
        metricDisplayer.setDataSetHandler((DataSetHandler)new DataSetHandlerImpl(this.dataSetClientServices, this.getDataSetLookup(settings)));
        return metricDisplayer;
    }

    private DataSetLookup getDataSetLookup(DisplayerSettings settings) {
        return ConsoleDataSetLookup.fromInstance((DataSetLookup)settings.getDataSetLookup(), (String)this.serverTemplateSelectorMenuBuilder.getSelectedServerTemplate());
    }

    public TableDisplayer createTableDisplayer(DisplayerSettings settings, String columnId, DurationFormatter durationFormatter) {
        PortablePreconditions.checkNotNull((String)"displayerSettings", (Object)settings);
        final TableDisplayer tableDisplayer = (TableDisplayer)this.displayerLocator.lookupDisplayer(settings);
        tableDisplayer.setDisplayerSettings(settings);
        tableDisplayer.setDataSetHandler((DataSetHandler)new DataSetHandlerImpl(this.dataSetClientServices, this.getDataSetLookup(settings)));
        tableDisplayer.addFormatter(columnId, (ValueFormatter)durationFormatter);
        tableDisplayer.addOnCellSelectedCommand(new Command(){

            public void execute() {
                AbstractDashboard.this.tableCellSelected(tableDisplayer.getSelectedCellColumn(), tableDisplayer.getSelectedCellRow());
            }
        });
        return tableDisplayer;
    }

    public MetricDisplayer getSelectedMetric() {
        return this.selectedMetric;
    }

    public abstract View getView();

    public void resetCurrentMetric() {
        this.selectedMetric = null;
        this.updateHeaderText();
    }

    public abstract void tableCellSelected(String var1, int var2);

    public void changeCurrentMetric(MetricDisplayer metric) {
        if (metric.isFilterOn()) {
            if (this.selectedMetric != null && this.selectedMetric != metric) {
                MetricDisplayer metricToReset = this.selectedMetric;
                metricToReset.filterReset();
                metricToReset.redraw();
            }
            this.selectedMetric = metric;
            this.updateHeaderText();
        } else {
            this.selectedMetric = null;
            this.updateHeaderText();
        }
    }

    public abstract void updateHeaderText();

    public Widget asWidget() {
        return this.getView().asWidget();
    }

    public abstract void resetProcessBreadcrumb();

    public ProcessBreadCrumb getProcessBreadCrumb() {
        return this.processBreadCrumb;
    }

    public String getSelectedProcess() {
        return this.selectedProcess;
    }

    public AbstractDisplayer createDisplayer(DisplayerSettings settings) {
        PortablePreconditions.checkNotNull((String)"displayerSettings", (Object)settings);
        AbstractDisplayer displayer = (AbstractDisplayer)this.displayerLocator.lookupDisplayer(settings);
        displayer.setDataSetHandler((DataSetHandler)new DataSetHandlerImpl(this.dataSetClientServices, this.getDataSetLookup(settings)));
        return displayer;
    }

    public void changeCurrentProcess(String name) {
        this.selectedProcess = name;
        this.updateHeaderText();
        this.getView().showBreadCrumb(name);
    }

    public void resetCurrentProcess() {
        this.selectedProcess = null;
        this.updateHeaderText();
        this.getView().hideBreadCrumb();
    }

    @Inject
    public void setPerspectiveManager(PerspectiveManager perspectiveManager) {
        this.perspectiveManager = perspectiveManager;
    }

    @Inject
    public void setUberfireBreadcrumbs(UberfireBreadcrumbs uberfireBreadcrumbs) {
        this.breadcrumbs = uberfireBreadcrumbs;
    }

    public static interface View
    extends IsWidget {
        public void showBreadCrumb(String var1);

        public void hideBreadCrumb();

        public void setHeaderText(String var1);

        public void showLoading();

        public void hideLoading();

        public void showDashboard();

        public void showInstances();

        public DashboardI18n getI18nService();
    }
}

