/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.client.panel.widgets;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.displayer.client.Displayer;
import org.jbpm.dashboard.renderer.client.panel.i18n.DashboardConstants;
import org.jbpm.dashboard.renderer.client.panel.widgets.DisplayerContainer;
import org.jbpm.dashboard.renderer.client.panel.widgets.DisplayerContainerView;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.workbench.common.workbench.client.resources.i18n.DefaultWorkbenchConstants;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DisplayerContainerTest {
    private DisplayerContainer container;
    @Mock
    private DisplayerContainerView view;
    @Mock
    private Displayer currentDisplayer;

    @Before
    public void setup() {
        this.container = (DisplayerContainer)Mockito.spy((Object)new DisplayerContainer(new HashMap(), false));
        this.container.view = this.view;
        this.container.currentDisplayer = this.currentDisplayer;
    }

    @Test
    public void testShowErrorWhenIsKieServerForbiddenException() {
        ClientRuntimeError clientRuntimeError = this.makeClientRuntimeError((Throwable)this.makeHttpException(403));
        this.container.showError(clientRuntimeError);
        ((DisplayerContainerView)Mockito.verify((Object)this.view)).showError(DefaultWorkbenchConstants.INSTANCE.KieServerError403(), clientRuntimeError.getCause());
    }

    @Test
    public void testShowErrorWhenIsKieServerUnauthorizedException() {
        ClientRuntimeError clientRuntimeError = this.makeClientRuntimeError((Throwable)this.makeHttpException(401));
        this.container.showError(clientRuntimeError);
        ((DisplayerContainerView)Mockito.verify((Object)this.view)).showError(DefaultWorkbenchConstants.INSTANCE.KieServerError401(), clientRuntimeError.getCause());
    }

    @Test
    public void testShowErrorWhenIsNotKieServerUnauthorizedException() {
        ClientRuntimeError clientRuntimeError = this.makeClientRuntimeError(new Throwable());
        ((DisplayerContainer)Mockito.doNothing().when((Object)this.container)).showErrorPopup((String)Mockito.any());
        this.container.showError(clientRuntimeError);
        ((DisplayerContainerView)Mockito.verify((Object)this.view)).showEmpty(this.currentDisplayer);
        ((DisplayerContainer)Mockito.verify((Object)this.container)).showErrorPopup(DashboardConstants.INSTANCE.dashboardCouldNotBeLoaded());
    }

    private KieServicesHttpException makeHttpException(int httpCode) {
        return new KieServicesHttpException("", Integer.valueOf(httpCode), "", "");
    }

    private ClientRuntimeError makeClientRuntimeError(Throwable throwable) {
        return new ClientRuntimeError("", throwable);
    }
}

