/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.client.panel;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerListener;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerCoordinator;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.renderer.client.metric.MetricDisplayer;
import org.dashbuilder.renderer.client.table.TableDisplayer;
import org.jbpm.dashboard.renderer.client.panel.AbstractDashboard;
import org.jbpm.dashboard.renderer.client.panel.DashboardKpis;
import org.jbpm.dashboard.renderer.client.panel.formatter.DurationFormatter;
import org.jbpm.dashboard.renderer.client.panel.widgets.ProcessBreadCrumb;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.common.events.ServerTemplateSelected;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="ProcessDashboardScreen")
public class ProcessDashboard
extends AbstractDashboard {
    protected View view;
    protected Event<ProcessInstanceSelectionEvent> instanceSelectionEvent;
    protected MetricDisplayer totalMetric;
    protected MetricDisplayer activeMetric;
    protected MetricDisplayer pendingMetric;
    protected MetricDisplayer suspendedMetric;
    protected MetricDisplayer abortedMetric;
    protected MetricDisplayer completedMetric;
    protected AbstractDisplayer processesByType;
    protected AbstractDisplayer processesByUser;
    protected AbstractDisplayer processesByStartDate;
    protected AbstractDisplayer processesByEndDate;
    protected AbstractDisplayer processesByRunningTime;
    protected AbstractDisplayer processesByVersion;
    protected TableDisplayer processesTable;
    protected List<Displayer> metricsGroup = new ArrayList<Displayer>();
    protected List<Displayer> chartsGroup = new ArrayList<Displayer>();
    protected String totalProcessesTitle;
    DisplayerListener dashboardListener = new AbstractDisplayerListener(){

        public void onDraw(Displayer displayer) {
            DataSet ds;
            if (ProcessDashboard.this.totalMetric == displayer && (ds = displayer.getDataSetHandler().getLastDataSet()).getRowCount() == 0) {
                ProcessDashboard.this.showBlankDashboard();
            }
        }

        public void onFilterEnabled(Displayer displayer, DataSetGroup groupOp) {
            if ("processName".equals(groupOp.getColumnGroup().getSourceId())) {
                Interval interval = (Interval)groupOp.getSelectedIntervalList().get(0);
                ProcessDashboard.this.changeCurrentProcess(interval.getName());
            }
        }

        public void onFilterReset(Displayer displayer, List<DataSetGroup> groupOps) {
            for (DataSetGroup groupOp : groupOps) {
                if (!"processName".equals(groupOp.getColumnGroup().getSourceId())) continue;
                ProcessDashboard.this.resetCurrentProcess();
                return;
            }
        }

        public void onFilterEnabled(Displayer displayer, DataSetFilter filter) {
            if (ProcessDashboard.this.metricsGroup.contains(displayer)) {
                ProcessDashboard.this.changeCurrentMetric((MetricDisplayer)displayer);
            }
        }

        public void onFilterReset(Displayer displayer, DataSetFilter filter) {
            if (ProcessDashboard.this.metricsGroup.contains(displayer)) {
                ProcessDashboard.this.resetCurrentMetric();
            }
        }
    };

    @Inject
    public ProcessDashboard(View view, ProcessBreadCrumb processBreadCrumb, DataSetClientServices dataSetClientServices, DisplayerLocator displayerLocator, DisplayerCoordinator displayerCoordinator, PlaceManager placeManager, Event<ProcessInstanceSelectionEvent> instanceSelectionEvent, ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder) {
        super(dataSetClientServices, placeManager, view.getI18nService(), processBreadCrumb, displayerLocator, displayerCoordinator, serverTemplateSelectorMenuBuilder);
        this.view = view;
        this.instanceSelectionEvent = instanceSelectionEvent;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.i18n.processDashboardName();
    }

    public void onServerTemplateSelected(@Observes ServerTemplateSelected serverTemplateSelected) {
        this.placeManager.closePlace("ProcessDashboardScreen");
        this.placeManager.goTo("ProcessDashboardScreen");
    }

    @PostConstruct
    public void init() {
        this.processBreadCrumb.setOnRootSelectedCommand(this::resetProcessBreadcrumb);
        this.view.showLoading();
        DisplayerSettings totalProcesses = DashboardKpis.processTotal(this.i18n);
        this.totalProcessesTitle = totalProcesses.getTitle();
        this.totalMetric = this.createMetricDisplayer(totalProcesses);
        this.activeMetric = this.createMetricDisplayer(DashboardKpis.processesActive(this.i18n));
        this.pendingMetric = this.createMetricDisplayer(DashboardKpis.processesPending(this.i18n));
        this.suspendedMetric = this.createMetricDisplayer(DashboardKpis.processesSuspended(this.i18n));
        this.abortedMetric = this.createMetricDisplayer(DashboardKpis.processesAborted(this.i18n));
        this.completedMetric = this.createMetricDisplayer(DashboardKpis.processesCompleted(this.i18n));
        this.processesByType = this.createDisplayer(DashboardKpis.processesByType(this.i18n));
        this.processesByUser = this.createDisplayer(DashboardKpis.processesByUser(this.i18n));
        this.processesByStartDate = this.createDisplayer(DashboardKpis.processesByStartDate(this.i18n));
        this.processesByEndDate = this.createDisplayer(DashboardKpis.processesByEndDate(this.i18n));
        this.processesByRunningTime = this.createDisplayer(DashboardKpis.processesByRunningTime(this.i18n));
        this.processesByVersion = this.createDisplayer(DashboardKpis.processesByVersion(this.i18n));
        this.processesTable = this.createTableDisplayer(DashboardKpis.processesTable(this.i18n), "duration", new DurationFormatter("start_date", "end_date"));
        this.view.init(this, (Displayer)this.totalMetric, (Displayer)this.activeMetric, (Displayer)this.pendingMetric, (Displayer)this.suspendedMetric, (Displayer)this.abortedMetric, (Displayer)this.completedMetric, (Displayer)this.processesByType, (Displayer)this.processesByUser, (Displayer)this.processesByStartDate, (Displayer)this.processesByEndDate, (Displayer)this.processesByRunningTime, (Displayer)this.processesByVersion, (Displayer)this.processesTable);
        this.totalMetric.setFilterOn(true);
        this.selectedMetric = this.totalMetric;
        this.metricsGroup.add((Displayer)this.totalMetric);
        this.metricsGroup.add((Displayer)this.activeMetric);
        this.metricsGroup.add((Displayer)this.pendingMetric);
        this.metricsGroup.add((Displayer)this.suspendedMetric);
        this.metricsGroup.add((Displayer)this.abortedMetric);
        this.metricsGroup.add((Displayer)this.completedMetric);
        this.chartsGroup.add((Displayer)this.processesByType);
        this.chartsGroup.add((Displayer)this.processesByStartDate);
        this.chartsGroup.add((Displayer)this.processesByEndDate);
        this.chartsGroup.add((Displayer)this.processesByUser);
        this.chartsGroup.add((Displayer)this.processesByRunningTime);
        this.chartsGroup.add((Displayer)this.processesByVersion);
        this.chartsGroup.add((Displayer)this.processesTable);
        this.displayerCoordinator.addDisplayers(this.metricsGroup);
        this.displayerCoordinator.addDisplayers(this.chartsGroup);
        this.displayerCoordinator.addNotificationVeto(this.metricsGroup);
        this.displayerCoordinator.addListener(new DisplayerListener[]{this.dashboardListener});
        this.displayerCoordinator.drawAll(() -> this.view.hideLoading(), () -> this.view.hideLoading());
    }

    public MetricDisplayer getTotalMetric() {
        return this.totalMetric;
    }

    public MetricDisplayer getActiveMetric() {
        return this.activeMetric;
    }

    public MetricDisplayer getPendingMetric() {
        return this.pendingMetric;
    }

    public MetricDisplayer getSuspendedMetric() {
        return this.suspendedMetric;
    }

    public MetricDisplayer getAbortedMetric() {
        return this.abortedMetric;
    }

    public MetricDisplayer getCompletedMetric() {
        return this.completedMetric;
    }

    public AbstractDisplayer getProcessesByType() {
        return this.processesByType;
    }

    public AbstractDisplayer getProcessesByUser() {
        return this.processesByUser;
    }

    public AbstractDisplayer getProcessesByStartDate() {
        return this.processesByStartDate;
    }

    public AbstractDisplayer getProcessesByEndDate() {
        return this.processesByEndDate;
    }

    public AbstractDisplayer getProcessesByRunningTime() {
        return this.processesByRunningTime;
    }

    public AbstractDisplayer getProcessesByVersion() {
        return this.processesByVersion;
    }

    public TableDisplayer getProcessesTable() {
        return this.processesTable;
    }

    @Override
    @WorkbenchPartView
    public AbstractDashboard.View getView() {
        return this.view;
    }

    @Override
    @WorkbenchMenu
    public Menus getMenus() {
        return super.getMenus();
    }

    @Override
    public void createListBreadcrumb() {
        this.setupListBreadcrumb(this.i18n.processDashboardName());
    }

    @Override
    public void tableRedraw() {
        this.processesTable.filterReset();
        this.processesTable.redraw();
    }

    @Override
    public void resetProcessBreadcrumb() {
        this.processesByType.filterReset();
        this.processesByRunningTime.filterReset();
        this.processesByType.redraw();
        this.processesByRunningTime.redraw();
        this.view.hideBreadCrumb();
    }

    public void showBlankDashboard() {
    }

    @Override
    public void updateHeaderText() {
        if (this.selectedProcess == null) {
            String selected;
            String string = selected = this.selectedMetric != null ? this.selectedMetric.getDisplayerSettings().getTitle() : null;
            if (selected == null || this.totalProcessesTitle.equals(selected)) {
                this.view.setHeaderText(this.i18n.allProcesses());
            } else {
                this.view.setHeaderText(selected);
            }
        } else {
            String status = "";
            if (this.activeMetric == this.selectedMetric) {
                status = this.i18n.processStatusActive();
            } else if (this.pendingMetric == this.selectedMetric) {
                status = this.i18n.processStatusPending();
            } else if (this.suspendedMetric == this.selectedMetric) {
                status = this.i18n.processStatusSuspended();
            } else if (this.abortedMetric == this.selectedMetric) {
                status = this.i18n.processStatusAborted();
            } else if (this.completedMetric == this.selectedMetric) {
                status = this.i18n.processStatusCompleted();
            }
            this.view.setHeaderText(this.i18n.selectedProcessStatusHeader(status, this.selectedProcess));
        }
    }

    @Override
    public void tableCellSelected(String columnId, int rowIndex) {
        DataSet ds = this.processesTable.getDataSetHandler().getLastDataSet();
        String deploymentId = ds.getValueAt(rowIndex, "externalId").toString();
        Long processInstanceId = Double.valueOf(ds.getValueAt(rowIndex, "processInstanceId").toString()).longValue();
        String processDefId = ds.getValueAt(rowIndex, "processId").toString();
        String processDefName = ds.getValueAt(rowIndex, "processName").toString();
        Integer processInstanceStatus = Double.valueOf(ds.getValueAt(rowIndex, "status").toString()).intValue();
        this.openProcessDetailsScreen();
        this.setupDetailBreadcrumb(this.i18n.processDashboardName(), this.i18n.ProcessInstanceBreadcrumb(processInstanceId), "ProcessInstanceDetailsScreen");
        this.instanceSelectionEvent.fire((Object)new ProcessInstanceSelectionEvent(deploymentId, processInstanceId, processDefId, processDefName, processInstanceStatus, true, this.serverTemplateSelectorMenuBuilder.getSelectedServerTemplateId()));
    }

    @Override
    public void showDashboard() {
        this.view.showDashboard();
        this.closeProcessDetailsScreen();
    }

    public void openProcessDetailsScreen() {
        PlaceStatus status = this.placeManager.getStatus("ProcessInstanceDetailsScreen");
        if (status == PlaceStatus.CLOSE) {
            this.placeManager.goTo("ProcessInstanceDetailsScreen");
        }
    }

    public void closeProcessDetailsScreen() {
        PlaceStatus status = this.placeManager.getStatus("ProcessInstanceDetailsScreen");
        if (status == PlaceStatus.OPEN) {
            this.placeManager.closePlace("ProcessInstanceDetailsScreen");
        }
    }

    @Override
    public void showTable() {
        this.view.showInstances();
        this.processesTable.redraw();
    }

    public static interface View
    extends AbstractDashboard.View {
        public void init(ProcessDashboard var1, Displayer var2, Displayer var3, Displayer var4, Displayer var5, Displayer var6, Displayer var7, Displayer var8, Displayer var9, Displayer var10, Displayer var11, Displayer var12, Displayer var13, Displayer var14);
    }
}

