/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.client;

import javax.enterprise.event.Event;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.Assertions;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.renderer.client.metric.MetricDisplayer;
import org.dashbuilder.renderer.client.table.TableDisplayer;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.dashboard.renderer.client.AbstractDashboardTest;
import org.jbpm.dashboard.renderer.client.TaskDashboardData;
import org.jbpm.dashboard.renderer.client.panel.AbstractDashboard;
import org.jbpm.dashboard.renderer.client.panel.TaskDashboard;
import org.jbpm.dashboard.renderer.client.panel.widgets.ProcessBreadCrumb;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mocks.CallerMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskDashboardTest
extends AbstractDashboardTest {
    @Mock
    TaskDashboard.View view;
    @Mock
    ProcessBreadCrumb processBreadCrumb;
    @Mock
    Event<TaskSelectionEvent> taskSelectionEvent;
    @Mock
    TaskService taskService;
    Caller<TaskService> taskServiceCaller;
    @Mock
    Event<NotificationEvent> notificationEvent;
    @Mock
    DisplayerListener totalMetricListener;
    @Mock
    PerspectiveManager perspectiveManagerMock;
    @Mock
    UberfireBreadcrumbs uberfireBreadcrumbsMock;
    TaskDashboard presenter;
    DataSet dataSet;

    @Override
    public void registerDataset() throws Exception {
        this.dataSet = TaskDashboardData.INSTANCE.toDataSet();
        this.dataSet.setUUID("tasksMonitoring");
        this.clientDataSetManager.registerDataSet(this.dataSet);
    }

    @Override
    protected AbstractDashboard.View getView() {
        return this.view;
    }

    @Override
    protected AbstractDashboard getPresenter() {
        return this.presenter;
    }

    @Override
    public AbstractDisplayer createNewDisplayer(DisplayerSettings settings) {
        AbstractDisplayer displayer = super.createNewDisplayer(settings);
        if ("totalTasksMetric".equals(settings.getUUID())) {
            displayer.addListener(new DisplayerListener[]{this.totalMetricListener});
        }
        return displayer;
    }

    @Override
    @Before
    public void init() throws Exception {
        super.init();
        this.taskServiceCaller = new CallerMock((Object)this.taskService);
        this.presenter = new TaskDashboard(this.view, this.processBreadCrumb, this.clientServices, this.displayerLocator, this.displayerCoordinator, this.placeManager, this.taskSelectionEvent, this.serverTemplateSelectorMenuBuilder, this.taskServiceCaller, this.notificationEvent);
        Mockito.when((Object)this.perspectiveManagerMock.getCurrentPerspective()).thenReturn(Mockito.mock(PerspectiveActivity.class));
        this.presenter.setPerspectiveManager(this.perspectiveManagerMock);
        this.presenter.setUberfireBreadcrumbs(this.uberfireBreadcrumbsMock);
        this.presenter.init();
    }

    @Test
    public void testDrawAll() {
        ((TaskDashboard.View)Mockito.verify((Object)this.view)).init(this.presenter, (Displayer)this.presenter.getTotalMetric(), (Displayer)this.presenter.getCreatedMetric(), (Displayer)this.presenter.getReadyMetric(), (Displayer)this.presenter.getReservedMetric(), (Displayer)this.presenter.getInProgressMetric(), (Displayer)this.presenter.getSuspendedMetric(), (Displayer)this.presenter.getCompletedMetric(), (Displayer)this.presenter.getFailedMetric(), (Displayer)this.presenter.getErrorMetric(), (Displayer)this.presenter.getExitedMetric(), (Displayer)this.presenter.getObsoleteMetric(), (Displayer)this.presenter.getTasksByProcess(), (Displayer)this.presenter.getTasksByOwner(), (Displayer)this.presenter.getTasksByCreationDate(), (Displayer)this.presenter.getTasksByEndDate(), (Displayer)this.presenter.getTasksByRunningTime(), (Displayer)this.presenter.getTasksByStatus(), (Displayer)this.presenter.getTasksTable());
        ((TaskDashboard.View)Mockito.verify((Object)this.view)).showLoading();
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getTotalMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getCreatedMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getReadyMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getReservedMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getInProgressMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getSuspendedMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getCompletedMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getFailedMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getErrorMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getExitedMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getObsoleteMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getTasksByProcess());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getTasksByOwner());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getTasksByCreationDate());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getTasksByEndDate());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getTasksByRunningTime());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getTasksByStatus());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getTasksTable());
        ((TaskDashboard.View)Mockito.verify((Object)this.view)).hideLoading();
    }

    @Test
    public void test_JBPM_4851_Fix() {
        Assert.assertEquals((Object)this.presenter.getTotalMetric().isFilterOn(), (Object)true);
    }

    @Test
    public void test_JBPM_5834_Fix() {
        Assert.assertEquals((Object)this.presenter.getTotalMetric().isFilterOn(), (Object)true);
        ((DisplayerListener)Mockito.verify((Object)this.totalMetricListener, (VerificationMode)Mockito.never())).onFilterEnabled((Displayer)Mockito.any(), (DataSetFilter)Mockito.any(DataSetFilter.class));
    }

    @Test
    public void testShowInstances() {
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        this.presenter.showTable();
        ((TaskDashboard.View)Mockito.verify((Object)this.view)).showInstances();
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onRedraw((Displayer)this.presenter.getTasksTable());
    }

    @Test
    public void testShowDashboard() {
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        this.presenter.showDashboard();
        ((TaskDashboard.View)Mockito.verify((Object)this.view)).showDashboard();
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.never())).onRedraw((Displayer)this.presenter.getTasksTable());
    }

    @Test
    public void testTotalMetric() {
        MetricDisplayer displayer = this.presenter.getTotalMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)9.0);
    }

    @Test
    public void testInProgressMetric() {
        MetricDisplayer displayer = this.presenter.getInProgressMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)3.0);
    }

    @Test
    public void testCompletedMetric() {
        MetricDisplayer displayer = this.presenter.getCompletedMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)2.0);
    }

    @Test
    public void testReservedMetric() {
        MetricDisplayer displayer = this.presenter.getReservedMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)1.0);
    }

    @Test
    public void testSuspendedMetric() {
        MetricDisplayer displayer = this.presenter.getSuspendedMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)1.0);
    }

    @Test
    public void testTasksByEndDate() {
        AbstractDisplayer displayer = this.presenter.getTasksByEndDate();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"2019-01", "1.00"}, {"2019-02", "0.00"}, {"2019-03", "0.00"}, {"2019-04", "0.00"}, {"2019-05", "0.00"}, {"2019-06", "0.00"}, {"2019-07", "0.00"}, {"2019-08", "0.00"}, {"2019-09", "0.00"}, {"2019-10", "0.00"}, {"2019-11", "0.00"}, {"2019-12", "1.00"}}, (int)0);
    }

    @Test
    public void testTasksByCreationDate() {
        AbstractDisplayer displayer = this.presenter.getTasksByCreationDate();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"2019-01-01", "9.00"}}, (int)0);
    }

    @Test
    public void testTasksByRunningTime() {
        AbstractDisplayer displayer = this.presenter.getTasksByRunningTime();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        DisplayerSettings displayerSettings = displayer.getDisplayerSettings();
        ColumnSettings taskDurationSettings = displayerSettings.getColumnSettings("duration");
        Assert.assertNotNull((Object)taskDurationSettings);
        Assert.assertEquals((Object)"value/60000", (Object)taskDurationSettings.getValueExpression());
        Assert.assertEquals((Object)"#,##0 min", (Object)taskDurationSettings.getValuePattern());
        Assert.assertEquals((Object)"processName", (Object)dataSet.getColumnByIndex(0).getId());
        Assert.assertEquals((Object)"Tasks", (Object)dataSet.getColumnByIndex(1).getId());
        Assert.assertEquals((Object)"duration", (Object)dataSet.getColumnByIndex(2).getId());
        Assert.assertEquals((Object)"processName", (Object)dataSet.getColumnByIndex(3).getId());
        Assert.assertEquals((Object)"Tasks", (Object)dataSet.getColumnByIndex(4).getId());
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"Process A", "1.00", "9,000.00", "Process A", "1.00"}, {"Process B", "1.00", "10,000.00", "Process B", "1.00"}}, (int)0);
    }

    @Test
    public void testTasksByStatus() {
        AbstractDisplayer displayer = this.presenter.getTasksByStatus();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"InProgress", "3.00"}, {"Completed", "2.00"}, {"Suspended", "1.00"}, {"Error", "1.00"}, {"Reserved", "1.00"}, {"Exited", "1.00"}}, (int)0);
    }

    @Test
    public void testTasksByOwner() {
        AbstractDisplayer displayer = this.presenter.getTasksByOwner();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"user1", "3.00"}, {"user2", "2.00"}, {"user3", "1.00"}, {"user4", "3.00"}}, (int)0);
    }

    @Test
    public void testTasksByProcess() {
        AbstractDisplayer displayer = this.presenter.getTasksByProcess();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"Process A", "4.00"}, {"Process B", "5.00"}}, (int)0);
    }

    @Test
    public void testTasksTable() {
        TableDisplayer displayer = this.presenter.getTasksTable();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"1.00", "Process A", "1.00", "Task 1", "user1", "InProgress", "01/01/19 10:00", "", ""}, {"4.00", "Process A", "1.00", "Task 4", "user2", "InProgress", "01/01/19 10:00", "", ""}, {"8.00", "Process B", "2.00", "Task 4", "user4", "Completed", "01/01/19 10:00", "12/02/19 16:00", "10,000.00"}, {"9.00", "Process B", "2.00", "Task 4", "user4", "Exited", "01/01/19 10:00", "", ""}, {"2.00", "Process A", "1.00", "Task 2", "user1", "Completed", "01/01/19 09:00", "01/01/19 13:00", "9,000.00"}, {"3.00", "Process A", "1.00", "Task 3", "user2", "Suspended", "01/01/19 08:00", "", ""}, {"7.00", "Process B", "2.00", "Task 3", "user4", "Reserved", "01/01/19 08:00", "", ""}, {"6.00", "Process B", "2.00", "Task 2", "user3", "Error", "01/01/19 07:00", "", ""}, {"5.00", "Process B", "2.00", "Task 2", "user1", "InProgress", "01/01/19 06:00", "", ""}}, (int)0);
    }

    @Test
    public void testSelectProcess() {
        Mockito.reset((Object[])new TaskDashboard.View[]{this.view});
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        this.presenter.getTasksByProcess().filterUpdate("processName", 1);
        String process = "Process B";
        Assert.assertEquals((Object)this.presenter.getSelectedProcess(), (Object)"Process B");
        ((TaskDashboard.View)Mockito.verify((Object)this.view)).showBreadCrumb("Process B");
        ((TaskDashboard.View)Mockito.verify((Object)this.view)).setHeaderText(this.i18n.selectedTaskStatusHeader("", "Process B"));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.times((int)17))).onRedraw((Displayer)Mockito.any(Displayer.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.never())).onError((Displayer)Mockito.any(Displayer.class), (ClientRuntimeError)Mockito.any(ClientRuntimeError.class));
    }

    @Test
    public void testResetProcess() {
        Mockito.reset((Object[])new TaskDashboard.View[]{this.view});
        this.presenter.resetCurrentProcess();
        Assert.assertNull((Object)this.presenter.getSelectedProcess());
        ((TaskDashboard.View)Mockito.verify((Object)this.view)).hideBreadCrumb();
        ((TaskDashboard.View)Mockito.verify((Object)this.view)).setHeaderText(this.i18n.allTasks());
    }

    @Test
    public void testSelectMetric() {
        this.presenter.resetCurrentMetric();
        Mockito.reset((Object[])new TaskDashboard.View[]{this.view});
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        MetricDisplayer inProgressMetric = this.presenter.getInProgressMetric();
        inProgressMetric.filterApply();
        Assert.assertEquals((Object)this.presenter.getSelectedMetric(), (Object)inProgressMetric);
        ((TaskDashboard.View)Mockito.verify((Object)this.view)).setHeaderText(this.i18n.tasksInProgress());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onFilterEnabled((Displayer)Mockito.eq((Object)inProgressMetric), (DataSetFilter)Mockito.any(DataSetFilter.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.times((int)1))).onFilterEnabled((Displayer)Mockito.any(Displayer.class), (DataSetFilter)Mockito.any(DataSetFilter.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.never())).onFilterReset((Displayer)Mockito.any(Displayer.class), (DataSetFilter)Mockito.any(DataSetFilter.class));
        DataSet dataSet = this.presenter.getTasksTable().getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"1.00", "Process A", "1.00", "Task 1", "user1", "InProgress", "01/01/19 10:00", "", ""}, {"4.00", "Process A", "1.00", "Task 4", "user2", "InProgress", "01/01/19 10:00", "", ""}, {"5.00", "Process B", "2.00", "Task 2", "user1", "InProgress", "01/01/19 06:00", "", ""}}, (int)0);
    }

    @Test
    public void testResetMetric() {
        MetricDisplayer inProgressMetric = this.presenter.getInProgressMetric();
        inProgressMetric.filterApply();
        Mockito.reset((Object[])new Object[]{this.displayerListener, this.view});
        inProgressMetric.filterReset();
        Assert.assertNull((Object)this.presenter.getSelectedMetric());
        ((TaskDashboard.View)Mockito.verify((Object)this.view)).setHeaderText(this.i18n.allTasks());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onFilterReset((Displayer)Mockito.eq((Object)inProgressMetric), (DataSetFilter)Mockito.any(DataSetFilter.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.times((int)1))).onFilterReset((Displayer)Mockito.any(Displayer.class), (DataSetFilter)Mockito.any(DataSetFilter.class));
        DataSet dataSet = this.presenter.getTasksTable().getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"1.00", "Process A", "1.00", "Task 1", "user1", "InProgress", "01/01/19 10:00", "", ""}, {"4.00", "Process A", "1.00", "Task 4", "user2", "InProgress", "01/01/19 10:00", "", ""}, {"8.00", "Process B", "2.00", "Task 4", "user4", "Completed", "01/01/19 10:00", "12/02/19 16:00", "10,000.00"}, {"9.00", "Process B", "2.00", "Task 4", "user4", "Exited", "01/01/19 10:00", "", ""}, {"2.00", "Process A", "1.00", "Task 2", "user1", "Completed", "01/01/19 09:00", "01/01/19 13:00", "9,000.00"}, {"3.00", "Process A", "1.00", "Task 3", "user2", "Suspended", "01/01/19 08:00", "", ""}, {"7.00", "Process B", "2.00", "Task 3", "user4", "Reserved", "01/01/19 08:00", "", ""}, {"6.00", "Process B", "2.00", "Task 2", "user3", "Error", "01/01/19 07:00", "", ""}, {"5.00", "Process B", "2.00", "Task 2", "user1", "InProgress", "01/01/19 06:00", "", ""}}, (int)0);
    }

    @Test
    public void testSwitchMetric() {
        MetricDisplayer inProgressMetric = this.presenter.getInProgressMetric();
        MetricDisplayer completedMetric = this.presenter.getCompletedMetric();
        inProgressMetric.filterApply();
        Mockito.reset((Object[])new Object[]{this.displayerListener, this.view, inProgressMetric.getView()});
        completedMetric.filterApply();
        Assert.assertEquals((Object)this.presenter.getSelectedMetric(), (Object)completedMetric);
        ((MetricDisplayer.View)Mockito.verify((Object)inProgressMetric.getView())).setHtml(Mockito.anyString());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onFilterReset((Displayer)Mockito.eq((Object)inProgressMetric), (DataSetFilter)Mockito.any(DataSetFilter.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onFilterEnabled((Displayer)Mockito.eq((Object)completedMetric), (DataSetFilter)Mockito.any(DataSetFilter.class));
        DataSet dataSet = this.presenter.getTasksTable().getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"8.00", "Process B", "2.00", "Task 4", "user4", "Completed", "01/01/19 10:00", "12/02/19 16:00", "10,000.00"}, {"2.00", "Process A", "1.00", "Task 2", "user1", "Completed", "01/01/19 09:00", "01/01/19 13:00", "9,000.00"}}, (int)0);
    }

    @Test
    public void testTaskInstanceNoDetailsStatusExited() {
        Mockito.when((Object)this.taskService.getTask(Mockito.anyString(), Mockito.anyString(), Long.valueOf(Mockito.anyLong()))).thenReturn(Mockito.mock(TaskSummary.class));
        Mockito.when((Object)this.placeManager.getStatus("TaskDetailsScreen")).thenReturn((Object)PlaceStatus.CLOSE);
        TableDisplayer tableDisplayer = this.presenter.getTasksTable();
        tableDisplayer.selectCell("taskId", 3);
        DataSet currentDataSet = this.presenter.getTasksTable().getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)"Exited", (Object)currentDataSet.getValueAt(0, "status"));
        ((Event)Mockito.verify(this.notificationEvent)).fire(Mockito.any(NotificationEvent.class));
        ((Event)Mockito.verify(this.taskSelectionEvent, (VerificationMode)Mockito.never())).fire(Mockito.any(TaskSelectionEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo("TaskDetailsScreen");
    }

    @Test
    public void testTaskInstanceNoDetailsStatusComplete() {
        Mockito.when((Object)this.taskService.getTask(Mockito.anyString(), Mockito.anyString(), Long.valueOf(Mockito.anyLong()))).thenReturn(Mockito.mock(TaskSummary.class));
        Mockito.when((Object)this.placeManager.getStatus("TaskDetailsScreen")).thenReturn((Object)PlaceStatus.CLOSE);
        TableDisplayer tableDisplayer = this.presenter.getTasksTable();
        tableDisplayer.selectCell("taskId", 2);
        DataSet currentDataSet = this.presenter.getTasksTable().getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)"Completed", (Object)currentDataSet.getValueAt(0, "status"));
        ((Event)Mockito.verify(this.notificationEvent)).fire(Mockito.any(NotificationEvent.class));
        ((Event)Mockito.verify(this.taskSelectionEvent, (VerificationMode)Mockito.never())).fire(Mockito.any(TaskSelectionEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo("TaskDetailsScreen");
    }

    @Test
    public void testOpenInstanceDetails() {
        Mockito.when((Object)this.taskService.getTask(Mockito.anyString(), Mockito.anyString(), Long.valueOf(Mockito.anyLong()))).thenReturn(Mockito.mock(TaskSummary.class));
        Mockito.when((Object)this.placeManager.getStatus("TaskDetailsScreen")).thenReturn((Object)PlaceStatus.CLOSE);
        TableDisplayer tableDisplayer = this.presenter.getTasksTable();
        tableDisplayer.selectCell("taskId", 0);
        ((Event)Mockito.verify(this.taskSelectionEvent)).fire(Mockito.any(TaskSelectionEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("TaskDetailsScreen");
    }

    @Test
    public void testHeaderText() {
        String task = "Task Test";
        this.verifyMetricHeaderText("Task Test", this.presenter.getTotalMetric(), this.i18n.selectedTaskStatusHeader("", "Task Test"));
        this.verifyMetricHeaderText("Task Test", this.presenter.getReadyMetric(), this.i18n.selectedTaskStatusHeader(this.i18n.taskStatusReady(), "Task Test"));
        this.verifyMetricHeaderText("Task Test", this.presenter.getReservedMetric(), this.i18n.selectedTaskStatusHeader(this.i18n.taskStatusReserved(), "Task Test"));
        this.verifyMetricHeaderText("Task Test", this.presenter.getInProgressMetric(), this.i18n.selectedTaskStatusHeader(this.i18n.taskStatusInProgress(), "Task Test"));
        this.verifyMetricHeaderText("Task Test", this.presenter.getSuspendedMetric(), this.i18n.selectedTaskStatusHeader(this.i18n.taskStatusSuspended(), "Task Test"));
        this.verifyMetricHeaderText("Task Test", this.presenter.getCompletedMetric(), this.i18n.selectedTaskStatusHeader(this.i18n.taskStatusCompleted(), "Task Test"));
        Mockito.reset((Object[])new TaskDashboard.View[]{this.view});
        this.presenter.resetCurrentProcess();
        this.presenter.resetCurrentMetric();
        ((TaskDashboard.View)Mockito.verify((Object)this.view)).setHeaderText(this.i18n.allTasks());
    }
}

