/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.client.panel.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import org.dashbuilder.dataset.client.resources.bundles.DataSetClientResources;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.widgets.DisplayerError;
import org.gwtbootstrap3.client.ui.Image;
import org.gwtbootstrap3.client.ui.ListBox;
import org.jbpm.dashboard.renderer.client.panel.i18n.DashboardConstants;
import org.jbpm.dashboard.renderer.client.panel.widgets.DisplayerContainer;

public class DisplayerContainerView
extends Composite
implements DisplayerContainer.View {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    protected Panel rootPanel;
    @UiField
    protected Panel headerPanel;
    @UiField
    protected Panel separatorPanel;
    @UiField
    protected Label titleLabel;
    @UiField
    protected ListBox displayerList;
    @UiField
    protected Panel displayerPanel;
    protected Displayer currentDisplayer;
    protected DisplayerContainer presenter;
    protected DisplayerError errorWidget = new DisplayerError();

    public DisplayerContainerView() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(DisplayerContainer presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setHeaderVisible(boolean visible) {
        this.headerPanel.setVisible(visible);
        this.separatorPanel.setVisible(visible);
    }

    @Override
    public void setHeaderText(String text) {
        this.titleLabel.setText(text);
    }

    @Override
    public void setSelectorVisible(boolean visible) {
        this.displayerList.setVisible(visible);
    }

    @Override
    public void setDisplayerList(Set<String> displayerNames) {
        this.displayerList.clear();
        for (String name : displayerNames) {
            this.displayerList.addItem(name);
        }
    }

    @Override
    public void setDisplayerHeight(int h) {
        this.displayerPanel.setHeight(h + 25 + "px");
    }

    @Override
    public void showLoading(Displayer displayer) {
        this.currentDisplayer = null;
        VerticalPanel centeredPanel = new VerticalPanel();
        centeredPanel.setWidth("100%");
        centeredPanel.setHeight("100%");
        centeredPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        centeredPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        Image loadingIcon = new Image(DataSetClientResources.INSTANCE.images().loadingIcon().getSafeUri());
        loadingIcon.setTitle(DashboardConstants.INSTANCE.loading());
        loadingIcon.setAltText(DashboardConstants.INSTANCE.loading());
        centeredPanel.add((Widget)loadingIcon);
        this.displayerPanel.clear();
        this.displayerPanel.add((Widget)centeredPanel);
    }

    @Override
    public void showDisplayer(Displayer displayer) {
        if (displayer != this.currentDisplayer) {
            this.displayerPanel.clear();
            this.displayerPanel.add((IsWidget)displayer);
            this.currentDisplayer = displayer;
        }
    }

    @Override
    public void showEmpty(Displayer displayer) {
        this.currentDisplayer = null;
        VerticalPanel centeredPanel = new VerticalPanel();
        centeredPanel.setWidth("100%");
        centeredPanel.setHeight("100%");
        centeredPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        centeredPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        Label noDataLabel = new Label(DashboardConstants.INSTANCE.noData());
        centeredPanel.add((Widget)noDataLabel);
        this.displayerPanel.clear();
        this.displayerPanel.add((Widget)centeredPanel);
    }

    @Override
    public void showError(String message, String cause) {
        this.currentDisplayer = null;
        this.displayerPanel.clear();
        this.displayerPanel.add((Widget)this.errorWidget);
        this.errorWidget.show(message, cause);
    }

    @UiHandler(value={"displayerList"})
    protected void onDisplayerSelected(ChangeEvent event) {
        this.presenter.selectDisplayer(this.displayerList.getSelectedValue());
    }

    @Override
    public Style getHeaderStyle() {
        return this.headerPanel.getElement().getStyle();
    }

    @Override
    public Style getBodyStyle() {
        return this.displayerPanel.getElement().getStyle();
    }

    static interface Binder
    extends UiBinder<Widget, DisplayerContainerView> {
    }
}

