/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.jobdetails;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.shared.event.ModalShownEvent;
import org.gwtbootstrap3.client.shared.event.ModalShownHandler;
import org.gwtbootstrap3.client.ui.FormControlStatic;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.gwt.DataGrid;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.ErrorSummary;
import org.jbpm.workbench.es.model.RequestDetails;
import org.jbpm.workbench.es.model.RequestParameterSummary;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.service.ExecutorService;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.ext.widgets.common.client.tables.ResizableHeader;
import org.uberfire.mvp.Command;

@Dependent
public class JobDetailsPopup
extends BaseModal {
    final Constants constants = Constants.INSTANCE;
    @UiField
    public FormControlStatic jobRetries;
    @UiField
    public DataGrid<RequestParameterSummary> executionParametersGrid;
    @UiField
    public HTML errorsOccurredList;
    @UiField
    public FormGroup errorControlGroup;
    @Inject
    private Caller<ExecutorService> executorServices;
    private ListDataProvider<RequestParameterSummary> dataProvider = new ListDataProvider();
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public JobDetailsPopup() {
        this.setTitle(Constants.INSTANCE.Job_Request_Details());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        this.init();
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(Constants.INSTANCE.Ok(), new Command(){

            public void execute() {
                JobDetailsPopup.this.closePopup();
            }
        }, null, ButtonType.PRIMARY);
        this.add((Widget)footer);
    }

    public void show(String serverTemplateId, String jobId) {
        this.cleanForm(serverTemplateId, jobId);
        super.show();
    }

    public void init() {
        Column<RequestParameterSummary, String> paramKeyColumn = new Column<RequestParameterSummary, String>((Cell)new TextCell()){

            public String getValue(RequestParameterSummary rowObject) {
                return rowObject.getKey();
            }
        };
        this.executionParametersGrid.setHeight("200px");
        this.executionParametersGrid.setEmptyTableWidget((Widget)new Label(this.constants.No_Parameters_added_yet()));
        this.executionParametersGrid.addColumn((Column)paramKeyColumn, (Header)new ResizableHeader(this.constants.Key(), this.executionParametersGrid, (Column)paramKeyColumn));
        Column<RequestParameterSummary, String> paramValueColumn = new Column<RequestParameterSummary, String>((Cell)new TextCell()){

            public String getValue(RequestParameterSummary rowObject) {
                return rowObject.getValue();
            }
        };
        this.executionParametersGrid.addColumn((Column)paramValueColumn, (Header)new ResizableHeader(this.constants.Value(), this.executionParametersGrid, (Column)paramValueColumn));
        this.dataProvider.addDataDisplay(this.executionParametersGrid);
    }

    public void cleanForm(String serverTemplateId, String requestId) {
        this.addShownHandler(new ModalShownHandler(){

            public void onShown(ModalShownEvent shownEvent) {
                JobDetailsPopup.this.refreshTable();
            }
        });
        ((ExecutorService)this.executorServices.call((RemoteCallback)new RemoteCallback<RequestDetails>(){

            public void callback(RequestDetails response) {
                JobDetailsPopup.this.setRequest(response.getRequest(), response.getErrors(), response.getParams());
            }
        })).getRequestDetails(serverTemplateId, Long.valueOf(requestId));
    }

    public void closePopup() {
        this.hide();
        super.hide();
    }

    public void setRequest(RequestSummary r, List<ErrorSummary> errors, List<RequestParameterSummary> params) {
        this.jobRetries.setText(String.valueOf(r.getExecutions()));
        if (errors != null && errors.size() > 0) {
            this.errorControlGroup.setVisible(true);
            String html = "";
            for (ErrorSummary error : errors) {
                html = html + "<strong>" + error.getMessage() + "</strong><br/>" + error.getStacktrace() + "<br><br>";
            }
            this.errorsOccurredList.setHTML(SafeHtmlUtils.fromTrustedString((String)html));
        } else {
            this.errorControlGroup.setVisible(false);
        }
        if (params != null) {
            this.dataProvider.getList().clear();
            this.dataProvider.getList().addAll(params);
            this.dataProvider.refresh();
        }
    }

    public void refreshTable() {
        this.executionParametersGrid.redraw();
    }

    static interface Binder
    extends UiBinder<Widget, JobDetailsPopup> {
    }
}

