/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.errorlist;

import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.base.DataSetQueryHelper;
import org.jbpm.workbench.es.client.editors.errorlist.ExecutionErrorListPresenter;
import org.jbpm.workbench.es.client.editors.errorlist.ExecutionErrorListViewImpl;
import org.jbpm.workbench.es.model.ExecutionErrorSummary;
import org.jbpm.workbench.es.model.events.ExecErrorChangedEvent;
import org.jbpm.workbench.es.service.ExecutorService;
import org.jbpm.workbench.es.util.ExecutionErrorType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ExecutionErrorListPresenterTest {
    private CallerMock<ExecutorService> callerMockExecutorService;
    @Mock
    private ExecutorService executorServiceMock;
    @Mock
    private ExecutionErrorListViewImpl viewMock;
    @Mock
    private DataSetQueryHelper dataSetQueryHelper;
    @Mock
    private ExtendedPagedTable<ExecutionErrorSummary> extendedPagedTable;
    @Mock
    private EventSourceMock<ExecErrorChangedEvent> execErrorChangedEvent;
    @Spy
    private FilterSettings filterSettings;
    @InjectMocks
    private ExecutionErrorListPresenter presenter;

    private static ExecutionErrorSummary createTestError(int id) {
        return ExecutionErrorSummary.builder().errorId(id + "").error(id + "_stackTrace").acknowledged(false).acknowledgedAt(new Date()).acknowledgedBy("testUser").activityId(Long.valueOf(id + 20)).activityName(id + "_Act_name").errorDate(new Date()).type(ExecutionErrorType.TASK).deploymentId(id + "_deployment").processInstanceId(Long.valueOf(id)).processId(id + "_processId").jobId(Long.valueOf(id)).message(id + "_message").build();
    }

    @Before
    public void setupMocks() {
        this.callerMockExecutorService = new CallerMock((Object)this.executorServiceMock);
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn(this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.extendedPagedTable.getColumnSortList()).thenReturn(null);
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        this.presenter.setExecutorServices(this.callerMockExecutorService);
    }

    @Test
    public void getDataTest() {
        this.presenter.setAddingDefaultFilters(false);
        this.presenter.getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.ASCENDING);
        ((ExecutionErrorListViewImpl)Mockito.verify((Object)this.viewMock)).hideBusyIndicator();
    }

    @Test
    public void acknowledgeErrorTest() {
        String errorId = "errorId";
        String deploymentId = "deploymentId";
        this.presenter.acknowledgeExecutionError("errorId", "deploymentId");
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).acknowledgeError(Mockito.anyString(), (String)Mockito.eq((Object)"deploymentId"), new String[]{(String)Mockito.eq((Object)"errorId")});
    }

    @Test
    public void bulkAcknowledgeTest() {
        String error1_ID = "error1";
        String error2_ID = "error2";
        String error3_ID = "error3";
        String error1_deploymentId = "deploymentId_1";
        String error2_deploymentId = "deploymentId_2";
        String error3_deploymentId = "deploymentId_3";
        ArrayList<ExecutionErrorSummary> testErrors = new ArrayList<ExecutionErrorSummary>(Arrays.asList(ExecutionErrorSummary.builder().errorId(error1_ID).deploymentId(error1_deploymentId).acknowledged(false).build(), ExecutionErrorSummary.builder().errorId(error2_ID).deploymentId(error2_deploymentId).acknowledged(false).build(), ExecutionErrorSummary.builder().errorId(error3_ID).deploymentId(error3_deploymentId).acknowledged(true).build()));
        this.presenter.bulkAcknowledge(testErrors);
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).acknowledgeError(Mockito.anyString(), (String)Mockito.eq((Object)error1_deploymentId), new String[]{(String)Mockito.eq((Object)error1_ID)});
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).acknowledgeError(Mockito.anyString(), (String)Mockito.eq((Object)error2_deploymentId), new String[]{(String)Mockito.eq((Object)error2_ID)});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.executorServiceMock});
    }

    @Test
    public void testGetExecutionErrorSummary() {
        String errorId = "errorId";
        String errorType = "Process";
        String deploymentId = "deploymentId";
        Long processInsId = 1L;
        String processId = "processId";
        Long activityId = 1L;
        String activityName = "activityName";
        Long jobId = 1L;
        String errorMessage = "errorMessage";
        boolean ack = false;
        String ackBy = "ackBy";
        Date ackAt = new Date();
        Date errorDate = new Date();
        Mockito.when((Object)this.dataSetQueryHelper.getColumnStringValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"ERROR_ID"), Mockito.eq((int)0))).thenReturn((Object)"errorId");
        Mockito.when((Object)this.dataSetQueryHelper.getColumnStringValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"ERROR_TYPE"), Mockito.eq((int)0))).thenReturn((Object)"Process");
        Mockito.when((Object)this.dataSetQueryHelper.getColumnStringValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"DEPLOYMENT_ID"), Mockito.eq((int)0))).thenReturn((Object)"deploymentId");
        Mockito.when((Object)this.dataSetQueryHelper.getColumnLongValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"PROCESS_INST_ID"), Mockito.eq((int)0))).thenReturn((Object)processInsId);
        Mockito.when((Object)this.dataSetQueryHelper.getColumnStringValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"PROCESS_ID"), Mockito.eq((int)0))).thenReturn((Object)"processId");
        Mockito.when((Object)this.dataSetQueryHelper.getColumnLongValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"ACTIVITY_ID"), Mockito.eq((int)0))).thenReturn((Object)activityId);
        Mockito.when((Object)this.dataSetQueryHelper.getColumnStringValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"ACTIVITY_NAME"), Mockito.eq((int)0))).thenReturn((Object)"activityName");
        Mockito.when((Object)this.dataSetQueryHelper.getColumnLongValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"JOB_ID"), Mockito.eq((int)0))).thenReturn((Object)jobId);
        Mockito.when((Object)this.dataSetQueryHelper.getColumnStringValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"ERROR_MSG"), Mockito.eq((int)0))).thenReturn((Object)"errorMessage");
        Mockito.when((Object)this.dataSetQueryHelper.getColumnBooleanValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"ERROR_ACK"), Mockito.eq((int)0))).thenReturn((Object)false);
        Mockito.when((Object)this.dataSetQueryHelper.getColumnStringValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"ERROR_ACK_BY"), Mockito.eq((int)0))).thenReturn((Object)"ackBy");
        Mockito.when((Object)this.dataSetQueryHelper.getColumnDateValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"ERROR_ACK_AT"), Mockito.eq((int)0))).thenReturn((Object)ackAt);
        Mockito.when((Object)this.dataSetQueryHelper.getColumnDateValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"ERROR_DATE"), Mockito.eq((int)0))).thenReturn((Object)errorDate);
        ExecutionErrorSummary es = this.presenter.createExecutionErrorSummaryFromDataSet((DataSet)Mockito.mock(DataSet.class), Integer.valueOf(0));
        Assert.assertEquals((Object)"errorMessage", (Object)es.getErrorMessage());
        Assert.assertEquals((Object)"Process", (Object)es.getType().getType());
        Assert.assertEquals((Object)"errorMessage", (Object)es.getErrorMessage());
        Assert.assertEquals((Object)ackAt, (Object)es.getAcknowledgedAt());
        Assert.assertEquals((Object)"ackBy", (Object)es.getAcknowledgedBy());
        Assert.assertEquals((Object)false, (Object)es.isAcknowledged());
        Assert.assertEquals((Object)activityId, (Object)es.getActivityId());
        Assert.assertEquals((Object)"activityName", (Object)es.getActivityName());
        Assert.assertEquals((Object)"deploymentId", (Object)es.getDeploymentId());
        Assert.assertEquals((Object)"errorId", (Object)es.getErrorId());
        Assert.assertEquals((Object)"processId", (Object)es.getProcessId());
        Assert.assertEquals((Object)processInsId, (Object)es.getProcessInstanceId());
        Assert.assertEquals((Object)jobId, (Object)es.getJobId());
    }
}

