/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.RandomStringUtils;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.workbench.common.client.events.SearchEvent;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.base.DataSetQueryHelper;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListPresenter;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListViewImpl;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.model.events.RequestChangedEvent;
import org.jbpm.workbench.es.service.ExecutorService;
import org.jbpm.workbench.es.util.RequestStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class RequestListPresenterTest {
    private static final Long REQUESTID_ID = 1L;
    private CallerMock<ExecutorService> callerMockExecutorService;
    @Mock
    private ExecutorService executorServiceMock;
    @Mock
    private RequestListViewImpl viewMock;
    @Mock
    private DataSetQueryHelper dataSetQueryHelper;
    @Spy
    private DataSetLookup dataSetLookup;
    @Mock
    private ExtendedPagedTable<RequestSummary> extendedPagedTable;
    @Mock
    private EventSourceMock<RequestChangedEvent> requestChangedEvent;
    @Spy
    private FilterSettings filterSettings;
    private RequestListPresenter presenter;

    @Before
    public void setupMocks() {
        this.callerMockExecutorService = new CallerMock((Object)this.executorServiceMock);
        this.filterSettings.setDataSetLookup(this.dataSetLookup);
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn(this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.extendedPagedTable.getColumnSortList()).thenReturn(null);
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.viewMock.getAdvancedSearchFilterSettings()).thenReturn((Object)this.filterSettings);
        this.presenter = new RequestListPresenter(this.viewMock, this.callerMockExecutorService, this.dataSetQueryHelper, this.requestChangedEvent);
    }

    @Test
    public void getDataTest() {
        this.presenter.setAddingDefaultFilters(false);
        this.presenter.getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.ASCENDING);
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).hideBusyIndicator();
    }

    @Test
    public void cancelRequestTest() {
        this.presenter.cancelRequest(REQUESTID_ID);
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RequestChangedEvent.class));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).cancelRequest(Mockito.anyString(), (Long)Mockito.eq((Object)REQUESTID_ID));
    }

    @Test
    public void requeueRequestTest() {
        this.presenter.requeueRequest(REQUESTID_ID);
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RequestChangedEvent.class));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).requeueRequest(Mockito.anyString(), (Long)Mockito.eq((Object)REQUESTID_ID));
    }

    @Test
    public void testEmptySearchString() {
        SearchEvent searchEvent = new SearchEvent("");
        this.presenter.onSearchEvent(searchEvent);
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).applyFilterOnPresenter(Mockito.anyString());
        Assert.assertEquals((Object)searchEvent.getFilter(), (Object)this.presenter.getTextSearchStr());
    }

    @Test
    public void testSearchString() {
        SearchEvent searchEvent = new SearchEvent(RandomStringUtils.random((int)10));
        this.presenter.onSearchEvent(searchEvent);
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).applyFilterOnPresenter(Mockito.anyString());
        Assert.assertEquals((Object)searchEvent.getFilter(), (Object)this.presenter.getTextSearchStr());
    }

    @Test
    public void testSearchFilterNull() {
        List filters = this.presenter.getColumnFilters(null);
        Assert.assertTrue((boolean)filters.isEmpty());
    }

    @Test
    public void testSearchFilterEmpty() {
        List filters = this.presenter.getColumnFilters("");
        Assert.assertTrue((boolean)filters.isEmpty());
        filters = this.presenter.getColumnFilters("     ");
        Assert.assertTrue((boolean)filters.isEmpty());
    }

    @Test
    public void testSearchFilterString() {
        List filters = this.presenter.getColumnFilters("jobReference");
        Assert.assertEquals((long)3L, (long)filters.size());
        Assert.assertEquals((Object)"commandName", (Object)((ColumnFilter)filters.get(0)).getColumnId());
        Assert.assertEquals((Object)"message", (Object)((ColumnFilter)filters.get(1)).getColumnId());
        Assert.assertEquals((Object)"businessKey", (Object)((ColumnFilter)filters.get(2)).getColumnId());
    }

    @Test
    public void testGetRequestSummary() {
        Long id = 1L;
        String message = "message";
        String status = "status";
        String commandName = "commandName";
        String businessKey = "businessKey";
        Integer retries = 2;
        Integer executions = 1;
        Date time = new Date();
        String processName = "myProcessName";
        Long processInstanceId = 33L;
        String processInstanceDescription = "myProcessInstanceDescription";
        Mockito.when((Object)this.dataSetQueryHelper.getColumnLongValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"id"), Mockito.eq((int)0))).thenReturn((Object)id);
        Mockito.when((Object)this.dataSetQueryHelper.getColumnDateValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"timestamp"), Mockito.eq((int)0))).thenReturn((Object)time);
        Mockito.when((Object)this.dataSetQueryHelper.getColumnStringValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"status"), Mockito.eq((int)0))).thenReturn((Object)"status");
        Mockito.when((Object)this.dataSetQueryHelper.getColumnStringValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"commandName"), Mockito.eq((int)0))).thenReturn((Object)"commandName");
        Mockito.when((Object)this.dataSetQueryHelper.getColumnStringValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"message"), Mockito.eq((int)0))).thenReturn((Object)"message");
        Mockito.when((Object)this.dataSetQueryHelper.getColumnStringValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"businessKey"), Mockito.eq((int)0))).thenReturn((Object)"businessKey");
        Mockito.when((Object)this.dataSetQueryHelper.getColumnIntValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"retries"), Mockito.eq((int)0))).thenReturn((Object)retries);
        Mockito.when((Object)this.dataSetQueryHelper.getColumnIntValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"executions"), Mockito.eq((int)0))).thenReturn((Object)executions);
        Mockito.when((Object)this.dataSetQueryHelper.getColumnStringValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"processName"), Mockito.eq((int)0))).thenReturn((Object)"myProcessName");
        Mockito.when((Object)this.dataSetQueryHelper.getColumnLongValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"processInstanceId"), Mockito.eq((int)0))).thenReturn((Object)processInstanceId);
        Mockito.when((Object)this.dataSetQueryHelper.getColumnStringValue((DataSet)Mockito.any(DataSet.class), (String)Mockito.eq((Object)"processInstanceDescription"), Mockito.eq((int)0))).thenReturn((Object)"myProcessInstanceDescription");
        RequestSummary rs = this.presenter.getRequestSummary((DataSet)Mockito.mock(DataSet.class), Integer.valueOf(0));
        Assert.assertEquals((Object)id, (Object)rs.getId());
        Assert.assertEquals((Object)time, (Object)rs.getTime());
        Assert.assertEquals((Object)"status", (Object)rs.getStatus());
        Assert.assertEquals((Object)"commandName", (Object)rs.getCommandName());
        Assert.assertEquals((Object)"message", (Object)rs.getMessage());
        Assert.assertEquals((Object)"businessKey", (Object)rs.getKey());
        Assert.assertEquals((Object)retries, (Object)rs.getRetries());
        Assert.assertEquals((Object)executions, (Object)rs.getExecutions());
        Assert.assertEquals((Object)"myProcessName", (Object)rs.getProcessName());
        Assert.assertEquals((Object)processInstanceId, (Object)rs.getProcessInstanceId());
        Assert.assertEquals((Object)"myProcessInstanceDescription", (Object)rs.getProcessInstanceDescription());
    }

    @Test
    public void testAdvancedSearchDefaultActiveFilter() {
        this.presenter.setupAdvancedSearchView();
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((String)Mockito.eq((Object)Constants.INSTANCE.Status()), (String)Mockito.eq((Object)Constants.INSTANCE.Running()), Mockito.eq((Object)RequestStatus.RUNNING.name()), (Consumer)Mockito.any(Consumer.class));
    }
}

