/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.RandomStringUtils;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.workbench.common.client.events.SearchEvent;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.base.DataSetQueryHelper;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListPresenter;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListViewImpl;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.model.events.RequestChangedEvent;
import org.jbpm.workbench.es.service.ExecutorService;
import org.jbpm.workbench.es.util.RequestStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class RequestListPresenterTest {
    private static final Long REQUEST_ID = 1L;
    private CallerMock<ExecutorService> callerMockExecutorService;
    @Mock
    private ExecutorService executorServiceMock;
    @Mock
    private RequestListViewImpl viewMock;
    @Mock
    private DataSetQueryHelper dataSetQueryHelper;
    @Spy
    private DataSetLookup dataSetLookup;
    @Mock
    private ExtendedPagedTable<RequestSummary> extendedPagedTable;
    @Mock
    private EventSourceMock<RequestChangedEvent> requestChangedEvent;
    @Spy
    private FilterSettings filterSettings;
    private RequestListPresenter presenter;

    @Before
    public void setupMocks() {
        this.callerMockExecutorService = new CallerMock((Object)this.executorServiceMock);
        this.filterSettings.setDataSetLookup(this.dataSetLookup);
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn(this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.extendedPagedTable.getColumnSortList()).thenReturn(null);
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.viewMock.getAdvancedSearchFilterSettings()).thenReturn((Object)this.filterSettings);
        this.presenter = new RequestListPresenter(this.viewMock, this.callerMockExecutorService, this.dataSetQueryHelper, this.requestChangedEvent);
    }

    @Test
    public void getDataTest() {
        this.presenter.setAddingDefaultFilters(false);
        this.presenter.getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.ASCENDING);
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).hideBusyIndicator();
    }

    @Test
    public void cancelRequestTest() {
        this.presenter.cancelRequest(REQUEST_ID);
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RequestChangedEvent.class));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).cancelRequest(Mockito.anyString(), (Long)Mockito.eq((Object)REQUEST_ID));
    }

    @Test
    public void requeueRequestTest() {
        this.presenter.requeueRequest(REQUEST_ID);
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RequestChangedEvent.class));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).requeueRequest(Mockito.anyString(), (Long)Mockito.eq((Object)REQUEST_ID));
    }

    @Test
    public void testEmptySearchString() {
        SearchEvent searchEvent = new SearchEvent("");
        this.presenter.onSearchEvent(searchEvent);
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).applyFilterOnPresenter(Mockito.anyString());
        Assert.assertEquals((Object)searchEvent.getFilter(), (Object)this.presenter.getTextSearchStr());
    }

    @Test
    public void testSearchString() {
        SearchEvent searchEvent = new SearchEvent(RandomStringUtils.random((int)10));
        this.presenter.onSearchEvent(searchEvent);
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).applyFilterOnPresenter(Mockito.anyString());
        Assert.assertEquals((Object)searchEvent.getFilter(), (Object)this.presenter.getTextSearchStr());
    }

    @Test
    public void testSearchFilterNull() {
        List filters = this.presenter.getColumnFilters(null);
        Assert.assertTrue((boolean)filters.isEmpty());
    }

    @Test
    public void testSearchFilterEmpty() {
        List filters = this.presenter.getColumnFilters("");
        Assert.assertTrue((boolean)filters.isEmpty());
        filters = this.presenter.getColumnFilters("     ");
        Assert.assertTrue((boolean)filters.isEmpty());
    }

    @Test
    public void testSearchFilterString() {
        List filters = this.presenter.getColumnFilters("jobReference");
        Assert.assertEquals((long)3L, (long)filters.size());
        Assert.assertEquals((Object)"commandName", (Object)((ColumnFilter)filters.get(0)).getColumnId());
        Assert.assertEquals((Object)"message", (Object)((ColumnFilter)filters.get(1)).getColumnId());
        Assert.assertEquals((Object)"businessKey", (Object)((ColumnFilter)filters.get(2)).getColumnId());
    }

    @Test
    public void testGetRequestSummary() {
        Long id = 1L;
        String message = "message";
        String status = "status";
        String commandName = "commandName";
        String businessKey = "businessKey";
        Integer retries = 2;
        Integer executions = 1;
        Date time = new Date();
        String processName = "myProcessName";
        Long processInstanceId = 33L;
        String processInstanceDescription = "myProcessInstanceDescription";
        DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
        Mockito.when((Object)dataSet.getValueAt(0, "id")).thenReturn((Object)id);
        Mockito.when((Object)dataSet.getValueAt(0, "timestamp")).thenReturn((Object)time);
        Mockito.when((Object)dataSet.getValueAt(0, "status")).thenReturn((Object)"status");
        Mockito.when((Object)dataSet.getValueAt(0, "commandName")).thenReturn((Object)"commandName");
        Mockito.when((Object)dataSet.getValueAt(0, "message")).thenReturn((Object)"message");
        Mockito.when((Object)dataSet.getValueAt(0, "businessKey")).thenReturn((Object)"businessKey");
        Mockito.when((Object)dataSet.getValueAt(0, "retries")).thenReturn((Object)retries);
        Mockito.when((Object)dataSet.getValueAt(0, "executions")).thenReturn((Object)executions);
        Mockito.when((Object)dataSet.getValueAt(0, "processName")).thenReturn((Object)"myProcessName");
        Mockito.when((Object)dataSet.getValueAt(0, "processInstanceId")).thenReturn((Object)processInstanceId);
        Mockito.when((Object)dataSet.getValueAt(0, "processInstanceDescription")).thenReturn((Object)"myProcessInstanceDescription");
        RequestSummary rs = this.presenter.getRequestSummary(dataSet, Integer.valueOf(0));
        Assert.assertEquals((Object)id, (Object)rs.getId());
        Assert.assertEquals((Object)time, (Object)rs.getTime());
        Assert.assertEquals((Object)"status", (Object)rs.getStatus());
        Assert.assertEquals((Object)"commandName", (Object)rs.getCommandName());
        Assert.assertEquals((Object)"message", (Object)rs.getMessage());
        Assert.assertEquals((Object)"businessKey", (Object)rs.getKey());
        Assert.assertEquals((Object)retries, (Object)rs.getRetries());
        Assert.assertEquals((Object)executions, (Object)rs.getExecutions());
        Assert.assertEquals((Object)"myProcessName", (Object)rs.getProcessName());
        Assert.assertEquals((Object)processInstanceId, (Object)rs.getProcessInstanceId());
        Assert.assertEquals((Object)"myProcessInstanceDescription", (Object)rs.getProcessInstanceDescription());
    }

    @Test
    public void testDefaultActiveSearchFilters() {
        this.presenter.setupDefaultActiveSearchFilters();
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((String)Mockito.eq((Object)Constants.INSTANCE.Status()), (String)Mockito.eq((Object)Constants.INSTANCE.Running()), Mockito.eq((Object)RequestStatus.RUNNING.name()), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testActiveSearchFilters() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)place.getParameter(Mockito.anyString(), Mockito.anyString())).thenReturn(null);
        this.presenter.onStartup(place);
        this.presenter.setupActiveSearchFilters();
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((String)Mockito.eq((Object)Constants.INSTANCE.Status()), (String)Mockito.eq((Object)Constants.INSTANCE.Running()), Mockito.eq((Object)RequestStatus.RUNNING.name()), (Consumer)Mockito.any(Consumer.class));
    }
}

