/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.errorlist;

import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.function.Consumer;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.es.client.editors.errorlist.ExecutionErrorListPresenter;
import org.jbpm.workbench.es.client.editors.errorlist.ExecutionErrorListViewImpl;
import org.jbpm.workbench.es.client.editors.events.ExecutionErrorSelectedEvent;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.ExecutionErrorSummary;
import org.jbpm.workbench.es.service.ExecutorService;
import org.jbpm.workbench.es.util.ExecutionErrorType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=GwtMockitoTestRunner.class)
public class ExecutionErrorListPresenterTest {
    private CallerMock<ExecutorService> callerMockExecutorService;
    @Mock
    private ExecutorService executorServiceMock;
    @Mock
    private ExecutionErrorListViewImpl viewMock;
    @Mock
    private DataSetQueryHelper dataSetQueryHelper;
    @Mock
    private ExtendedPagedTable<ExecutionErrorSummary> extendedPagedTable;
    @Mock
    private EventSourceMock<ExecutionErrorSelectedEvent> executionErrorSelectedEventMock;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private User identity;
    @Spy
    private FilterSettings filterSettings;
    @Spy
    private DataSetLookup dataSetLookup;
    @InjectMocks
    private ExecutionErrorListPresenter presenter;

    @Before
    public void setupMocks() {
        this.callerMockExecutorService = new CallerMock((Object)this.executorServiceMock);
        this.filterSettings.setDataSetLookup(this.dataSetLookup);
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn(this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.extendedPagedTable.getColumnSortList()).thenReturn(null);
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.viewMock.getAdvancedSearchFilterSettings()).thenReturn((Object)this.filterSettings);
        this.presenter.setExecutorService(this.callerMockExecutorService);
    }

    @Test
    public void getDataTest() {
        this.presenter.setAddingDefaultFilters(false);
        this.presenter.getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.ASCENDING);
        ((ExecutionErrorListViewImpl)Mockito.verify((Object)this.viewMock)).hideBusyIndicator();
    }

    @Test
    public void acknowledgeErrorTest() {
        String errorId = "errorId";
        String deploymentId = "deploymentId";
        this.presenter.acknowledgeExecutionError("errorId", "deploymentId");
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).acknowledgeError(Mockito.anyString(), (String)Mockito.eq((Object)"deploymentId"), new String[]{(String)Mockito.eq((Object)"errorId")});
    }

    @Test
    public void bulkAcknowledgeTest() {
        String error1_ID = "error1";
        String error2_ID = "error2";
        String error3_ID = "error3";
        String error1_deploymentId = "deploymentId_1";
        String error2_deploymentId = "deploymentId_2";
        String error3_deploymentId = "deploymentId_3";
        ArrayList<ExecutionErrorSummary> testErrors = new ArrayList<ExecutionErrorSummary>(Arrays.asList(ExecutionErrorSummary.builder().errorId(error1_ID).deploymentId(error1_deploymentId).acknowledged(false).build(), ExecutionErrorSummary.builder().errorId(error2_ID).deploymentId(error2_deploymentId).acknowledged(false).build(), ExecutionErrorSummary.builder().errorId(error3_ID).deploymentId(error3_deploymentId).acknowledged(true).build()));
        this.presenter.bulkAcknowledge(testErrors);
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).acknowledgeError(Mockito.anyString(), (String)Mockito.eq((Object)error1_deploymentId), new String[]{(String)Mockito.eq((Object)error1_ID)});
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).acknowledgeError(Mockito.anyString(), (String)Mockito.eq((Object)error2_deploymentId), new String[]{(String)Mockito.eq((Object)error2_ID)});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.executorServiceMock});
    }

    @Test
    public void testGetExecutionErrorSummary() {
        String errorId = "errorId";
        String errorType = "Process";
        String deploymentId = "deploymentId";
        Long processInsId = 1L;
        String processId = "processId";
        Long activityId = 1L;
        String activityName = "activityName";
        Long jobId = 1L;
        String errorMessage = "errorMessage";
        Short ack = 0;
        String ackBy = "ackBy";
        Date ackAt = new Date();
        Date errorDate = new Date();
        DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
        Mockito.when((Object)dataSet.getValueAt(0, "ERROR_ID")).thenReturn((Object)"errorId");
        Mockito.when((Object)dataSet.getValueAt(0, "ERROR_TYPE")).thenReturn((Object)"Process");
        Mockito.when((Object)dataSet.getValueAt(0, "DEPLOYMENT_ID")).thenReturn((Object)"deploymentId");
        Mockito.when((Object)dataSet.getValueAt(0, "PROCESS_INST_ID")).thenReturn((Object)processInsId);
        Mockito.when((Object)dataSet.getValueAt(0, "PROCESS_ID")).thenReturn((Object)"processId");
        Mockito.when((Object)dataSet.getValueAt(0, "ACTIVITY_ID")).thenReturn((Object)activityId);
        Mockito.when((Object)dataSet.getValueAt(0, "ACTIVITY_NAME")).thenReturn((Object)"activityName");
        Mockito.when((Object)dataSet.getValueAt(0, "JOB_ID")).thenReturn((Object)jobId);
        Mockito.when((Object)dataSet.getValueAt(0, "ERROR_MSG")).thenReturn((Object)"errorMessage");
        Mockito.when((Object)dataSet.getValueAt(0, "ERROR_ACK")).thenReturn((Object)ack);
        Mockito.when((Object)dataSet.getValueAt(0, "ERROR_ACK_BY")).thenReturn((Object)"ackBy");
        Mockito.when((Object)dataSet.getValueAt(0, "ERROR_ACK_AT")).thenReturn((Object)ackAt);
        Mockito.when((Object)dataSet.getValueAt(0, "ERROR_DATE")).thenReturn((Object)errorDate);
        ExecutionErrorSummary es = this.presenter.createExecutionErrorSummaryFromDataSet(dataSet, Integer.valueOf(0));
        Assert.assertEquals((Object)"errorMessage", (Object)es.getErrorMessage());
        Assert.assertEquals((Object)"Process", (Object)es.getType().getType());
        Assert.assertEquals((Object)"errorMessage", (Object)es.getErrorMessage());
        Assert.assertEquals((Object)ackAt, (Object)es.getAcknowledgedAt());
        Assert.assertEquals((Object)"ackBy", (Object)es.getAcknowledgedBy());
        Assert.assertEquals((Object)(ack != 0 ? 1 : 0), (Object)es.isAcknowledged());
        Assert.assertEquals((Object)activityId, (Object)es.getActivityId());
        Assert.assertEquals((Object)"activityName", (Object)es.getActivityName());
        Assert.assertEquals((Object)"deploymentId", (Object)es.getDeploymentId());
        Assert.assertEquals((Object)"errorId", (Object)es.getErrorId());
        Assert.assertEquals((Object)"processId", (Object)es.getProcessId());
        Assert.assertEquals((Object)processInsId, (Object)es.getProcessInstanceId());
        Assert.assertEquals((Object)jobId, (Object)es.getJobId());
    }

    @Test
    public void testDefaultActiveSearchFilters() {
        this.presenter.setupDefaultActiveSearchFilters();
        ((ExecutionErrorListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((String)Mockito.eq((Object)Constants.INSTANCE.Acknowledged()), (String)Mockito.eq((Object)org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.No()), Mockito.eq((Object)"0"), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testActiveSearchFilters() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)place.getParameter(Mockito.anyString(), Mockito.anyString())).thenReturn(null);
        this.presenter.onStartup(place);
        this.presenter.setupActiveSearchFilters();
        ((ExecutionErrorListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((String)Mockito.eq((Object)Constants.INSTANCE.Acknowledged()), (String)Mockito.eq((Object)org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.No()), Mockito.eq((Object)"0"), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testActiveSearchFiltersProcessInstanceId() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        String processInstanceId = "1";
        Mockito.when((Object)place.getParameter("processInstanceId", null)).thenReturn((Object)"1");
        this.presenter.onStartup(place);
        this.presenter.setupActiveSearchFilters();
        ((ExecutionErrorListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((String)Mockito.eq((Object)Constants.INSTANCE.Process_Instance_Id()), (String)Mockito.eq((Object)"1"), Mockito.eq((Object)"1"), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testGoToJobErrorSummary() {
        String jobId = "1";
        this.presenter.goToJob(ExecutionErrorSummary.builder().jobId(Long.valueOf(jobId)).build());
        ArgumentCaptor captor = ArgumentCaptor.forClass(PlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)captor.capture());
        PlaceRequest request = (PlaceRequest)captor.getValue();
        Assert.assertEquals((Object)"Requests", (Object)request.getIdentifier());
        Assert.assertEquals((Object)jobId, (Object)request.getParameter("jobId", null));
    }

    @Test
    public void testGoProcessInstanceErrorSummary() {
        ExecutionErrorSummary errorSummary = ExecutionErrorSummary.builder().deploymentId("test_depId").processInstanceId(Long.valueOf("1")).processId("test_processId").build();
        this.presenter.goToProcessInstance(errorSummary);
        ArgumentCaptor captor = ArgumentCaptor.forClass(PlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)captor.capture());
        PlaceRequest request = (PlaceRequest)captor.getValue();
        Assert.assertEquals((Object)"ProcessInstances", (Object)request.getIdentifier());
        Assert.assertEquals((Object)errorSummary.getProcessInstanceId().toString(), (Object)request.getParameter("processInstanceId", null));
    }

    @Test
    public void testViewJobsActionCondition() {
        ((AuthorizationManager)Mockito.doAnswer((Answer)new PerspectiveAnswer("Requests")).when((Object)this.authorizationManager)).authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity));
        Assert.assertTrue((boolean)this.presenter.getViewJobActionCondition().test(ExecutionErrorSummary.builder().jobId(Long.valueOf(1L)).build()));
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.presenter.getViewJobActionCondition().test(new ExecutionErrorSummary()));
    }

    @Test
    public void testViewProcessInstanceActionCondition() {
        ((AuthorizationManager)Mockito.doAnswer((Answer)new PerspectiveAnswer("ProcessInstances")).when((Object)this.authorizationManager)).authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity));
        Assert.assertTrue((boolean)this.presenter.getViewProcessInstanceActionCondition().test(ExecutionErrorSummary.builder().processInstanceId(Long.valueOf(1L)).build()));
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.presenter.getViewProcessInstanceActionCondition().test(new ExecutionErrorSummary()));
    }

    @Test
    public void testGoTaskErrorSummary() {
        ((AuthorizationManager)Mockito.doAnswer((Answer)new PerspectiveAnswer("TaskAdmin")).when((Object)this.authorizationManager)).authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity));
        ExecutionErrorSummary errorSummary = ExecutionErrorSummary.builder().activityId(Long.valueOf("1")).build();
        this.presenter.goToTask(errorSummary);
        ArgumentCaptor captor = ArgumentCaptor.forClass(PlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)captor.capture());
        PlaceRequest request = (PlaceRequest)captor.getValue();
        Assert.assertEquals((Object)"TaskAdmin", (Object)request.getIdentifier());
        Assert.assertEquals((Object)errorSummary.getActivityId().toString(), (Object)request.getParameter("taskId", null));
    }

    @Test
    public void testViewTaskActionCondition() {
        ((AuthorizationManager)Mockito.doAnswer((Answer)new PerspectiveAnswer("TaskAdmin")).when((Object)this.authorizationManager)).authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity));
        Assert.assertTrue((boolean)this.presenter.getViewTaskActionCondition().test(ExecutionErrorSummary.builder().type(ExecutionErrorType.TASK).activityId(Long.valueOf(1L)).build()));
        Assert.assertFalse((boolean)this.presenter.getViewProcessInstanceActionCondition().test(new ExecutionErrorSummary()));
        Assert.assertFalse((boolean)this.presenter.getViewProcessInstanceActionCondition().test(ExecutionErrorSummary.builder().type(ExecutionErrorType.TASK).build()));
        Assert.assertFalse((boolean)this.presenter.getViewTaskActionCondition().test(ExecutionErrorSummary.builder().type(ExecutionErrorType.PROCESS).activityId(Long.valueOf(1L)).build()));
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.presenter.getViewTaskActionCondition().test(ExecutionErrorSummary.builder().type(ExecutionErrorType.TASK).activityId(Long.valueOf(1L)).build()));
    }

    @Test
    public void testDefaultAdvancedSearchFilterTypes() {
        this.presenter.setupAdvancedSearchView();
        ((ExecutionErrorListViewImpl)Mockito.verify((Object)this.viewMock)).addTextFilter((String)Mockito.eq((Object)Constants.INSTANCE.Id()), (String)Mockito.eq((Object)Constants.INSTANCE.FilterByErrorId()), (Consumer)Mockito.any(Consumer.class), (Consumer)Mockito.any(Consumer.class));
        ((ExecutionErrorListViewImpl)Mockito.verify((Object)this.viewMock)).addNumericFilter((String)Mockito.eq((Object)Constants.INSTANCE.Process_Instance_Id()), (String)Mockito.eq((Object)Constants.INSTANCE.FilterByProcessInstanceId()), (Consumer)Mockito.any(Consumer.class), (Consumer)Mockito.any(Consumer.class));
        ((ExecutionErrorListViewImpl)Mockito.verify((Object)this.viewMock)).addNumericFilter((String)Mockito.eq((Object)Constants.INSTANCE.JobId()), (String)Mockito.eq((Object)Constants.INSTANCE.FilterByJobId()), (Consumer)Mockito.any(Consumer.class), (Consumer)Mockito.any(Consumer.class));
        ((ExecutionErrorListViewImpl)Mockito.verify((Object)this.viewMock)).addSelectFilter((String)Mockito.eq((Object)Constants.INSTANCE.Type()), Mockito.anyMap(), Boolean.valueOf(Mockito.eq((boolean)false)), (Consumer)Mockito.any(Consumer.class), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testOnSelectionEvent() {
        String deploymentId = "evaluation.1.0.1";
        String errorId = "testErrorId";
        String processId = "Evaluation";
        Long processInstanceId = 1L;
        ExecutionErrorSummary errorSummary = ExecutionErrorSummary.builder().errorId(errorId).deploymentId(deploymentId).processId(processId).processInstanceId(processInstanceId).build();
        Mockito.when((Object)this.placeManager.getStatus((PlaceRequest)Mockito.any(DefaultPlaceRequest.class))).thenReturn((Object)PlaceStatus.CLOSE);
        this.presenter.setExecutionErrorSelectedEvent(this.executionErrorSelectedEventMock);
        this.presenter.selectExecutionError(errorSummary, Boolean.valueOf(true));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ExecutionErrorSelectedEvent.class);
        ((EventSourceMock)Mockito.verify(this.executionErrorSelectedEventMock)).fire(captor.capture());
        Assert.assertEquals((Object)deploymentId, (Object)((ExecutionErrorSelectedEvent)captor.getValue()).getDeploymentId());
        Assert.assertEquals((Object)errorId, (Object)((ExecutionErrorSelectedEvent)captor.getValue()).getErrorId());
    }

    protected class PerspectiveAnswer
    implements Answer<Boolean> {
        private String perspectiveId;

        public PerspectiveAnswer(String perspectiveId) {
            this.perspectiveId = perspectiveId;
        }

        public Boolean answer(InvocationOnMock invocation) throws Throwable {
            return this.perspectiveId.equals(((ResourceRef)invocation.getArguments()[0]).getIdentifier());
        }
    }
}

