/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.jobdetails;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.es.client.editors.events.JobSelectedEvent;
import org.jbpm.workbench.es.client.editors.jobdetails.JobDetailsPresenter;
import org.jbpm.workbench.es.client.editors.util.JobUtils;
import org.jbpm.workbench.es.model.ErrorSummary;
import org.jbpm.workbench.es.model.RequestDetails;
import org.jbpm.workbench.es.model.RequestParameterSummary;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.service.ExecutorService;
import org.jbpm.workbench.es.util.RequestStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class JobDetailsPresenterTest {
    @Mock
    private JobDetailsPresenter.JobDetailsView viewMock;
    @Mock
    private ExecutorService executorServiceMock;
    @Mock
    private EventSourceMock<ChangeTitleWidgetEvent> changeTitleWidgetEventMock;
    @InjectMocks
    private JobDetailsPresenter presenter;

    @Before
    public void setupMocks() {
        CallerMock callerMockExecutorService = new CallerMock((Object)this.executorServiceMock);
        this.presenter.setExecutorService((Caller)callerMockExecutorService);
    }

    @Test
    public void testStaleJobSelected() {
        String serverTemplate = "serverTemplate";
        RequestSummary job = JobUtils.createRequestSummary(RequestStatus.DONE);
        JobSelectedEvent event = new JobSelectedEvent("serverTemplate", job.getDeploymentId(), job.getJobId());
        Mockito.when((Object)this.executorServiceMock.getRequestDetails("serverTemplate", job.getDeploymentId(), job.getJobId())).thenReturn(null);
        this.presenter.onJobSelectedEvent(event);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.viewMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.changeTitleWidgetEventMock});
    }

    @Test
    public void testJobSelected() {
        String selectedServerTemplate = "serverTemplate";
        RequestSummary job = JobUtils.createRequestSummary();
        List<ErrorSummary> jobErrors = Collections.singletonList(JobUtils.createErrorSummary());
        List<RequestParameterSummary> jobParameters = Collections.singletonList(JobUtils.createRequestParameterSummary());
        RequestDetails requestDetails = new RequestDetails(job, jobErrors, jobParameters);
        JobSelectedEvent event = new JobSelectedEvent(selectedServerTemplate, job.getDeploymentId(), job.getJobId());
        Mockito.when((Object)this.executorServiceMock.getRequestDetails(selectedServerTemplate, job.getDeploymentId(), job.getJobId())).thenReturn((Object)requestDetails);
        this.presenter.onJobSelectedEvent(event);
        ArgumentCaptor requestSummaryCaptor = ArgumentCaptor.forClass(RequestSummary.class);
        ((JobDetailsPresenter.JobDetailsView)Mockito.verify((Object)this.viewMock)).setBasicDetails((RequestSummary)requestSummaryCaptor.capture());
        Assert.assertEquals((Object)job, (Object)requestSummaryCaptor.getValue());
        ArgumentCaptor parameterListCaptor = ArgumentCaptor.forClass(List.class);
        ((JobDetailsPresenter.JobDetailsView)Mockito.verify((Object)this.viewMock)).setParameters((List)parameterListCaptor.capture());
        Assert.assertEquals(jobParameters, (Object)parameterListCaptor.getValue());
        ArgumentCaptor errorsListCaptor = ArgumentCaptor.forClass(List.class);
        ((JobDetailsPresenter.JobDetailsView)Mockito.verify((Object)this.viewMock)).setErrors((List)errorsListCaptor.capture());
        Assert.assertEquals(jobErrors, (Object)errorsListCaptor.getValue());
        ArgumentCaptor captor = ArgumentCaptor.forClass(ChangeTitleWidgetEvent.class);
        ((EventSourceMock)Mockito.verify(this.changeTitleWidgetEventMock)).fire(captor.capture());
        Assert.assertEquals((Object)(job.getId() + " - " + job.getKey()), (Object)((ChangeTitleWidgetEvent)captor.getValue()).getTitle());
    }

    @Test
    public void getJobDetailTitleTest() {
        Long jobId = 1L;
        String key = "key";
        RequestSummary job = JobUtils.createRequestSummary(jobId, key, RequestStatus.QUEUED);
        Assert.assertEquals((Object)(job.getId() + " - " + job.getKey()), (Object)this.presenter.getJobDetailTitle(job));
        Assert.assertEquals((Object)(jobId + " - " + key), (Object)this.presenter.getJobDetailTitle(job));
        Assert.assertEquals((Object)"1 - key", (Object)this.presenter.getJobDetailTitle(job));
        job.setKey(null);
        Assert.assertEquals((Object)((Long)job.getId()).toString(), (Object)this.presenter.getJobDetailTitle(job));
        Assert.assertEquals((Object)jobId.toString(), (Object)this.presenter.getJobDetailTitle(job));
        Assert.assertEquals((Object)"1", (Object)this.presenter.getJobDetailTitle(job));
    }
}

