/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.dataset.AbstractDataSetReadyCallback;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.menu.PrimaryActionMenuBuilder;
import org.jbpm.workbench.common.client.menu.RefreshMenuBuilder;
import org.jbpm.workbench.common.client.util.DataSetUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsManager;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.es.client.editors.events.JobSelectedEvent;
import org.jbpm.workbench.es.client.editors.quicknewjob.NewJobPresenter;
import org.jbpm.workbench.es.client.editors.requestlist.JobListFilterSettingsManager;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListViewImpl;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.model.events.RequestChangedEvent;
import org.jbpm.workbench.es.service.ExecutorService;
import org.jbpm.workbench.es.util.RequestStatus;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="JobListScreen")
public class RequestListPresenter
extends AbstractMultiGridPresenter<RequestSummary, RequestListView> {
    private final org.jbpm.workbench.common.client.resources.i18n.Constants commonConstants = org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE;
    private Constants constants = Constants.INSTANCE;
    private NewJobPresenter newJobPresenter;
    private Command newJobCommand;
    @Inject
    private Caller<ExecutorService> executorServices;
    @Inject
    private Event<RequestChangedEvent> requestChangedEvent;
    @Inject
    private ErrorPopupPresenter errorPopup;
    @Inject
    private Event<JobSelectedEvent> jobSelectedEvent;

    public RequestListPresenter() {
    }

    public RequestListPresenter(RequestListViewImpl view, Caller<ExecutorService> executorServices, DataSetQueryHelper dataSetQueryHelper, Event<RequestChangedEvent> requestChangedEvent, Event<JobSelectedEvent> jobSelectedEvent, PlaceManager placeManager) {
        this.view = view;
        this.executorServices = executorServices;
        this.dataSetQueryHelper = dataSetQueryHelper;
        this.requestChangedEvent = requestChangedEvent;
        this.jobSelectedEvent = jobSelectedEvent;
        this.placeManager = placeManager;
    }

    @Inject
    protected void setNewJobPresenter(NewJobPresenter newJobPresenter) {
        this.newJobPresenter = newJobPresenter;
    }

    @Inject
    public void setFilterSettingsManager(JobListFilterSettingsManager filterSettingsManager) {
        super.setFilterSettingsManager((FilterSettingsManager)filterSettingsManager);
    }

    public void createListBreadcrumb() {
        this.setupListBreadcrumb(this.placeManager, this.commonConstants.Manage_Jobs());
    }

    public void setupDetailBreadcrumb(String detailLabel) {
        this.setupDetailBreadcrumb(this.placeManager, this.commonConstants.Manage_Jobs(), detailLabel, "JobDetailsScreen");
    }

    protected DataSetReadyCallback getDataSetReadyCallback(final Integer startRange, final FilterSettings tableSettings) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (ListView)this.view, tableSettings.getUUID()){

            public void callback(DataSet dataSet) {
                if (dataSet != null && RequestListPresenter.this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(tableSettings.getKey())) {
                    ArrayList<RequestSummary> myRequestSumaryFromDataSet = new ArrayList<RequestSummary>();
                    for (int i = 0; i < dataSet.getRowCount(); ++i) {
                        myRequestSumaryFromDataSet.add(RequestListPresenter.this.getRequestSummary(dataSet, i));
                    }
                    boolean lastPageExactCount = false;
                    if (dataSet.getRowCount() < ((RequestListView)RequestListPresenter.this.view).getListGrid().getPageSize()) {
                        lastPageExactCount = true;
                    }
                    RequestListPresenter.this.updateDataOnCallback(myRequestSumaryFromDataSet, startRange, startRange + myRequestSumaryFromDataSet.size(), lastPageExactCount);
                }
            }
        };
    }

    protected RequestSummary getRequestSummary(DataSet dataSet, Integer index) {
        return new RequestSummary(DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"id", (int)index), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"timestamp", (int)index), RequestStatus.valueOf((String)DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"status", (int)index)), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"commandName", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"message", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"businessKey", (int)index), DataSetUtils.getColumnIntValue((DataSet)dataSet, (String)"retries", (int)index), DataSetUtils.getColumnIntValue((DataSet)dataSet, (String)"executions", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processName", (int)index), DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"processInstanceId", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processInstanceDescription", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"deploymentId", (int)index));
    }

    public void cancelRequest(String deploymentId, Long requestId) {
        ((ExecutorService)this.executorServices.call(nothing -> {
            ((RequestListView)this.view).displayNotification(this.constants.RequestCanceled(requestId));
            this.requestChangedEvent.fire((Object)new RequestChangedEvent(requestId));
        })).cancelRequest(this.getSelectedServerTemplate(), deploymentId, requestId);
    }

    public void requeueRequest(String deploymentId, Long requestId) {
        ((ExecutorService)this.executorServices.call(nothing -> {
            ((RequestListView)this.view).displayNotification(this.constants.RequestRequeued(requestId));
            this.requestChangedEvent.fire((Object)new RequestChangedEvent(requestId));
        })).requeueRequest(this.getSelectedServerTemplate(), deploymentId, requestId);
    }

    protected Command getNewJobCommand() {
        if (this.newJobCommand == null) {
            this.newJobCommand = () -> {
                String selectedServerTemplate = this.getSelectedServerTemplate();
                if (selectedServerTemplate == null || selectedServerTemplate.trim().isEmpty()) {
                    ((RequestListView)this.view).displayNotification(this.constants.SelectServerTemplate());
                } else {
                    this.newJobPresenter.openNewJobDialog(selectedServerTemplate);
                }
            };
        }
        return this.newJobCommand;
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new PrimaryActionMenuBuilder(this.constants.New_Job(), this.getNewJobCommand())).endMenu()).build();
    }

    public void selectJob(RequestSummary job) {
        if (job.getStatus() != null) {
            this.setupDetailBreadcrumb(this.constants.JobBreadcrumb((Long)job.getId()));
            this.placeManager.goTo("JobDetailsScreen");
            this.jobSelectedEvent.fire((Object)new JobSelectedEvent(this.getSelectedServerTemplate(), job.getDeploymentId(), job.getJobId()));
        }
    }

    public void requestCreated(@Observes RequestChangedEvent event) {
        this.refreshGrid();
    }

    public void setupActiveSearchFilters() {
        Optional processInstIdSearch = this.getSearchParameter("processInstanceId");
        if (processInstIdSearch.isPresent()) {
            String processInstId = (String)processInstIdSearch.get();
            this.addActiveFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)Integer.valueOf(processInstId)), this.constants.Process_Instance_Id(), processInstId, Integer.valueOf(processInstId), v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)v)));
        } else {
            Optional jobSearch = this.getSearchParameter("jobId");
            if (jobSearch.isPresent()) {
                String jobId = (String)jobSearch.get();
                this.addActiveFilter(FilterFactory.equalsTo((String)"id", (Comparable)Integer.valueOf(jobId)), this.constants.JobId(), jobId, Integer.valueOf(jobId), v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"status", (Comparable)v)));
            } else {
                this.setupDefaultActiveSearchFilters();
            }
        }
    }

    public void setupDefaultActiveSearchFilters() {
        this.addActiveFilter(FilterFactory.equalsTo((String)"status", (Comparable)((Object)RequestStatus.RUNNING.name())), this.constants.Status(), this.constants.Running(), RequestStatus.RUNNING.name(), v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"status", (Comparable)((Object)v))));
    }

    public void openProcessInstanceView(String processInstanceId) {
        this.navigateToPerspective("ProcessInstances", "processInstanceId", processInstanceId);
    }

    public Predicate<RequestSummary> getCancelActionCondition() {
        return this.getActionConditionFromStatusList(new RequestStatus[]{RequestStatus.QUEUED, RequestStatus.RETRYING, RequestStatus.RUNNING});
    }

    public Predicate<RequestSummary> getRequeueActionCondition() {
        return this.getActionConditionFromStatusList(new RequestStatus[]{RequestStatus.ERROR, RequestStatus.RUNNING});
    }

    public Predicate<RequestSummary> getViewProcessActionCondition() {
        return job -> job.getProcessInstanceId() != null;
    }

    private Predicate<RequestSummary> getActionConditionFromStatusList(RequestStatus[] statusList) {
        return value -> Arrays.stream(statusList).anyMatch(s -> s.equals((Object)value.getStatus()));
    }

    public void bulkCancel(List<RequestSummary> jobsSelected) {
        if (jobsSelected == null || jobsSelected.isEmpty()) {
            return;
        }
        for (RequestSummary selected : jobsSelected) {
            if (!this.getCancelActionCondition().test(selected)) {
                ((RequestListView)this.view).displayNotification(this.constants.Job_Can_Not_Be_Cancelled(selected.getJobId()));
                continue;
            }
            this.cancelRequest(selected.getDeploymentId(), selected.getJobId());
        }
    }

    public void bulkRequeue(List<RequestSummary> jobsSelected) {
        if (jobsSelected == null || jobsSelected.isEmpty()) {
            return;
        }
        for (RequestSummary selected : jobsSelected) {
            if (!this.getRequeueActionCondition().test(selected)) {
                ((RequestListView)this.view).displayNotification(this.constants.Job_Can_Not_Be_Requeued(selected.getJobId()));
                continue;
            }
            this.requeueRequest(selected.getDeploymentId(), selected.getJobId());
        }
    }

    public static interface RequestListView
    extends MultiGridView<RequestSummary, RequestListPresenter> {
    }
}

