/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.util.ConditionalButtonActionCell;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListPresenter;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.RequestSummary;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

@Dependent
public class RequestListViewImpl
extends AbstractMultiGridView<RequestSummary, RequestListPresenter>
implements RequestListPresenter.RequestListView {
    private static final String REQUEST_LIST_PREFIX = "DS_RequestListGrid";
    protected static final String TAB_CANCELLED = "DS_RequestListGrid_6";
    protected static final String TAB_COMPLETED = "DS_RequestListGrid_5";
    protected static final String TAB_ERROR = "DS_RequestListGrid_4";
    protected static final String TAB_RETRYING = "DS_RequestListGrid_3";
    protected static final String TAB_RUNNING = "DS_RequestListGrid_2";
    protected static final String TAB_QUEUED = "DS_RequestListGrid_1";
    protected static final String TAB_ALL = "DS_RequestListGrid_0";
    private final Constants constants = Constants.INSTANCE;

    public List<String> getInitColumns() {
        return Arrays.asList("id", "businessKey", "commandName", "Actions");
    }

    public List<String> getBannedColumns() {
        return Arrays.asList("id", "commandName", "Actions");
    }

    public String getGridGlobalPreferencesKey() {
        return REQUEST_LIST_PREFIX;
    }

    public String getNewFilterPopupTitle() {
        return this.constants.New_JobList();
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        Column<RequestSummary, RequestSummary> actionsColumn = this.initActionsColumn();
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumn);
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(this.createNumberColumn("id", req -> req.getJobId()), this.constants.Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("businessKey", req -> req.getKey()), this.constants.BusinessKey()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("commandName", req -> req.getCommandName()), this.constants.Type()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("status", req -> req.getStatus()), this.constants.Status()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("timestamp", req -> DateUtils.getDateTimeStr((Date)req.getTime())), this.constants.Due_On()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processName", req -> req.getProcessName()), this.constants.Process_Name()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("processInstanceId", req -> req.getProcessInstanceId()), this.constants.Process_Instance_Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceDescription", req -> req.getProcessInstanceDescription()), this.constants.Process_Description()));
        columnMetas.add(new ColumnMeta(actionsColumn, this.constants.Actions()));
        extendedPagedTable.addColumns(columnMetas);
    }

    public void initSelectionModel(ExtendedPagedTable<RequestSummary> extendedPagedTable) {
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Jobs_Found());
    }

    private Column<RequestSummary, RequestSummary> initActionsColumn() {
        LinkedList<ConditionalButtonActionCell> cells = new LinkedList<ConditionalButtonActionCell>();
        cells.add(new ConditionalButtonActionCell(this.constants.Details(), job -> ((RequestListPresenter)this.presenter).showJobDetails((RequestSummary)job), ((RequestListPresenter)this.presenter).getDetailsActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.Cancel(), job -> {
            if (Window.confirm((String)this.constants.CancelJob())) {
                ((RequestListPresenter)this.presenter).cancelRequest(job.getJobId());
            }
        }, ((RequestListPresenter)this.presenter).getCancelActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.Requeue(), job -> {
            if (Window.confirm((String)this.constants.RequeueJob())) {
                ((RequestListPresenter)this.presenter).requeueRequest(job.getJobId());
            }
        }, ((RequestListPresenter)this.presenter).getRequeueActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.ViewProcessInstance(), job -> ((RequestListPresenter)this.presenter).openProcessInstanceView(Long.toString(job.getProcessInstanceId())), ((RequestListPresenter)this.presenter).getViewProcessActionCondition()));
        CompositeCell cell = new CompositeCell(cells);
        Column<RequestSummary, RequestSummary> actionsColumn = new Column<RequestSummary, RequestSummary>((Cell)cell){

            public RequestSummary getValue(RequestSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName("Actions");
        return actionsColumn;
    }

    public void initDefaultFilters() {
        super.initDefaultFilters();
        this.initTabFilter(((RequestListPresenter)this.presenter).createAllTabSettings(), TAB_ALL, this.constants.All(), this.constants.FilterAll(), "jbpmRequestList");
        this.initTabFilter(((RequestListPresenter)this.presenter).createQueuedTabSettings(), TAB_QUEUED, this.constants.Queued(), this.constants.FilterQueued(), "jbpmRequestList");
        this.initTabFilter(((RequestListPresenter)this.presenter).createRunningTabSettings(), TAB_RUNNING, this.constants.Running(), this.constants.FilterRunning(), "jbpmRequestList");
        this.initTabFilter(((RequestListPresenter)this.presenter).createRetryingTabSettings(), TAB_RETRYING, this.constants.Retrying(), this.constants.FilterRetrying(), "jbpmRequestList");
        this.initTabFilter(((RequestListPresenter)this.presenter).createErrorTabSettings(), TAB_ERROR, this.constants.Error(), this.constants.FilterError(), "jbpmRequestList");
        this.initTabFilter(((RequestListPresenter)this.presenter).createCompletedTabSettings(), TAB_COMPLETED, this.constants.Completed(), this.constants.FilterCompleted(), "jbpmRequestList");
        this.initTabFilter(((RequestListPresenter)this.presenter).createCancelledTabSettings(), TAB_CANCELLED, this.constants.Cancelled(), this.constants.FilterCancelled(), "jbpmRequestList");
    }
}

