/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import org.dashbuilder.dataset.DataSetLookup;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.basic.AbstractBasicFiltersPresenterTest;
import org.jbpm.workbench.common.client.filters.basic.BasicFiltersView;
import org.jbpm.workbench.es.client.editors.requestlist.JobListBasicFiltersPresenter;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class JobListBasicFiltersPresenterTest
extends AbstractBasicFiltersPresenterTest {
    @InjectMocks
    JobListBasicFiltersPresenter presenter;

    public JobListBasicFiltersPresenter getPresenter() {
        return this.presenter;
    }

    @Test
    public void testLoadFilters() {
        this.presenter.loadFilters();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.getView()});
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addMultiSelectFilter((String)Matchers.eq((Object)Constants.INSTANCE.Status()), (Map)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addDataSetSelectFilter((String)Matchers.eq((Object)Constants.INSTANCE.Process_Name()), (DataSetLookup)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addNumericFilter((String)Matchers.eq((Object)Constants.INSTANCE.Process_Instance_Id()), (String)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addTextFilter((String)Matchers.eq((Object)Constants.INSTANCE.BusinessKey()), (String)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addTextFilter((String)Matchers.eq((Object)Constants.INSTANCE.Type()), (String)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addTextFilter((String)Matchers.eq((Object)Constants.INSTANCE.Process_Instance_Description()), (String)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addDateRangeFilter((String)Matchers.eq((Object)Constants.INSTANCE.Due_On()), (String)Matchers.any(), (Boolean)Matchers.any(), (Consumer)Matchers.any());
    }

    @Test
    public void onActiveFilterAddedTest() {
        ActiveFilterItem activeFilterItemMock = (ActiveFilterItem)Mockito.mock(ActiveFilterItem.class);
        Mockito.when((Object)activeFilterItemMock.getKey()).thenReturn((Object)Constants.INSTANCE.JobId());
        this.presenter.onActiveFilterAdded(activeFilterItemMock);
        ((BasicFiltersView)Mockito.verify((Object)this.getView(), (VerificationMode)Mockito.never())).checkSelectFilter(Mockito.anyString(), Mockito.anyString());
        ((ActiveFilterItem)Mockito.verify((Object)activeFilterItemMock, (VerificationMode)Mockito.never())).getValue();
        Mockito.when((Object)activeFilterItemMock.getKey()).thenReturn((Object)Constants.INSTANCE.Status());
        Mockito.when((Object)activeFilterItemMock.getValue()).thenReturn(Arrays.asList(Constants.INSTANCE.Running(), Constants.INSTANCE.Queued()));
        this.presenter.onActiveFilterAdded(activeFilterItemMock);
        ((BasicFiltersView)Mockito.verify((Object)this.getView())).checkSelectFilter(Constants.INSTANCE.Status(), Constants.INSTANCE.Running());
        ((BasicFiltersView)Mockito.verify((Object)this.getView())).checkSelectFilter(Constants.INSTANCE.Status(), Constants.INSTANCE.Queued());
    }
}

