/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.quicknewjob;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.RequestParameterSummary;
import org.jbpm.workbench.es.model.events.RequestChangedEvent;
import org.jbpm.workbench.es.service.ExecutorService;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class NewJobPresenter {
    private final Constants constants = Constants.INSTANCE;
    private Caller<ExecutorService> executorServices;
    private Event<NotificationEvent> notification;
    private Event<RequestChangedEvent> requestCreatedEvent;
    private String serverTemplateId;
    @Inject
    protected NewJobView view;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void openNewJobDialog(String serverTemplateId) {
        this.serverTemplateId = serverTemplateId;
        this.view.show();
    }

    public void createJob(String jobName, Date dueDate, String jobType, String numberOfRetries, List<RequestParameterSummary> parameters) {
        if (this.validateForm(jobName, jobType, numberOfRetries)) {
            HashMap<String, String> jobCtxMap = new HashMap<String, String>();
            if (parameters != null) {
                for (RequestParameterSummary param : parameters) {
                    if (this.constants.ClickToEdit().equals(param.getKey()) || this.constants.ClickToEdit().equals(param.getValue())) continue;
                    jobCtxMap.put(param.getKey(), param.getValue());
                }
            }
            jobCtxMap.put("retries", numberOfRetries);
            jobCtxMap.put("businessKey", jobName);
            ((ExecutorService)this.executorServices.call(requestId -> {
                this.displayNotification(this.constants.RequestScheduled((Long)requestId));
                this.requestCreatedEvent.fire((Object)new RequestChangedEvent(requestId));
                this.view.hide();
            }, (message, throwable) -> {
                this.view.showBasicPane();
                if (this.isInvalidCommandTypeError(throwable)) {
                    this.view.showInvalidTypeErrorMessage();
                } else {
                    this.view.showInlineNotification(throwable.getCause().getMessage());
                }
                return false;
            })).scheduleRequest(this.serverTemplateId, jobType, dueDate, jobCtxMap);
        } else {
            this.view.showBasicPane();
        }
    }

    private boolean validateForm(String jobName, String jobType, String jobRetries) {
        boolean valid = true;
        this.view.cleanErrorMessages();
        if (jobName.isEmpty()) {
            this.view.showEmptyNameErrorMessage();
            valid = false;
        }
        if (jobType.isEmpty()) {
            this.view.showEmptyTypeErrorMessage();
            valid = false;
        }
        if (jobRetries.isEmpty()) {
            this.view.showEmptyRetriesErrorMessage();
            valid = false;
        }
        return valid;
    }

    private boolean isInvalidCommandTypeError(Throwable throwable) {
        String message = "";
        if (throwable.getMessage() != null) {
            message = throwable.getMessage();
        } else if (throwable.getCause() != null && throwable.getCause().getMessage() != null) {
            message = throwable.getCause().getMessage();
        }
        return message.contains("Invalid command type");
    }

    private void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Inject
    public void setNotification(Event<NotificationEvent> notification) {
        this.notification = notification;
    }

    @Inject
    public void setRequestChangedEvent(Event<RequestChangedEvent> requestChangedEvent) {
        this.requestCreatedEvent = requestChangedEvent;
    }

    @Inject
    public void setExecutorService(Caller<ExecutorService> executorService) {
        this.executorServices = executorService;
    }

    public static interface NewJobView
    extends UberElement<NewJobPresenter> {
        public void show();

        public void hide();

        public void showBasicPane();

        public void cleanErrorMessages();

        public void showEmptyNameErrorMessage();

        public void showInvalidTypeErrorMessage();

        public void showEmptyTypeErrorMessage();

        public void showEmptyRetriesErrorMessage();

        public void showInlineNotification(String var1);
    }
}

