/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.quicknewjob;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.SoftAssertions;
import org.jbpm.workbench.es.client.editors.quicknewjob.NewJobPresenter;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.RequestParameterSummary;
import org.jbpm.workbench.es.model.events.RequestChangedEvent;
import org.jbpm.workbench.es.service.ExecutorService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewJobPresenterTest {
    private String serverTemplateId = "serverTemplateId";
    private String JOB_NAME = "JOB_NAME_1";
    private String JOB_TYPE = "org.jbpm.executor.commands.PrintOutCommand";
    private String JOB_RETRIES = "5";
    @Mock
    private CallerMock<ExecutorService> executorServices;
    @Mock
    EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    EventSourceMock<RequestChangedEvent> requestChangedEvent;
    @Mock
    private ExecutorService executorServicesMock;
    @Mock
    private NewJobPresenter.NewJobView view;
    @InjectMocks
    private NewJobPresenter presenter;

    @Before
    public void setupMocks() {
        this.executorServices = new CallerMock((Object)this.executorServicesMock);
        this.presenter.setExecutorService(this.executorServices);
        this.presenter.setNotification(this.notificationEvent);
        this.presenter.setRequestChangedEvent(this.requestChangedEvent);
        this.presenter.openNewJobDialog(this.serverTemplateId);
    }

    @Test
    public void testScheduleJobSuccess_basicParametersOnly() {
        Date dueDate = new Date();
        Long firstJobId = 1L;
        Long secondJobId = 2L;
        Mockito.when((Object)this.executorServicesMock.scheduleRequest((String)Mockito.eq((Object)this.serverTemplateId), (String)Mockito.eq((Object)this.JOB_TYPE), (Date)Mockito.eq((Object)dueDate), (Map)Mockito.any())).thenReturn((Object)firstJobId, (Object[])new Long[]{secondJobId});
        this.presenter.createJob("firstJob", dueDate, this.JOB_TYPE, this.JOB_RETRIES, Collections.emptyList());
        this.presenter.createJob("secondJob", dueDate, this.JOB_TYPE, this.JOB_RETRIES, null);
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).show();
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).cleanErrorMessages();
        ArgumentCaptor captor = ArgumentCaptor.forClass(NotificationEvent.class);
        ((EventSourceMock)Mockito.verify(this.notificationEvent, (VerificationMode)Mockito.times((int)2))).fire(captor.capture());
        Assert.assertEquals((long)2L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)NotificationEvent.NotificationType.DEFAULT, (Object)((NotificationEvent)captor.getAllValues().get(0)).getType());
        Assert.assertEquals((Object)NotificationEvent.NotificationType.DEFAULT, (Object)((NotificationEvent)captor.getAllValues().get(1)).getType());
        Assert.assertEquals((Object)Constants.INSTANCE.RequestScheduled(firstJobId), (Object)((NotificationEvent)captor.getAllValues().get(0)).getNotification());
        Assert.assertEquals((Object)Constants.INSTANCE.RequestScheduled(secondJobId), (Object)((NotificationEvent)captor.getAllValues().get(1)).getNotification());
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)2))).fire(Mockito.any(RequestChangedEvent.class));
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).hide();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testScheduleJobSuccess_withAdvancedParameters() {
        String editMessage = "ClickToEdit";
        String paramKey = "paramKey";
        String paramValue = "paramValue";
        Date dueOnDate = new Date();
        SoftAssertions softly = new SoftAssertions();
        ((ExecutorService)Mockito.doAnswer(invocation -> {
            softly.assertThat(invocation.getArguments()[0]).isEqualTo((Object)this.serverTemplateId);
            softly.assertThat(invocation.getArguments()[1]).isEqualTo((Object)this.JOB_TYPE);
            softly.assertThat(invocation.getArguments()[2]).isEqualTo((Object)dueOnDate);
            HashMap ctxValues = (HashMap)invocation.getArguments()[3];
            softly.assertThat((Map)ctxValues).hasSize(3);
            softly.assertThat(((String)ctxValues.get("businessKey")).equals(this.JOB_NAME));
            softly.assertThat(((String)ctxValues.get("retries")).equals(this.JOB_RETRIES));
            softly.assertThat(((String)ctxValues.get("paramKey")).equals("paramValue"));
            return null;
        }).when((Object)this.executorServicesMock)).scheduleRequest(Mockito.anyString(), Mockito.anyString(), (Date)Mockito.any(Date.class), (Map)Mockito.any(Map.class));
        this.presenter.createJob(this.JOB_NAME, dueOnDate, this.JOB_TYPE, this.JOB_RETRIES, Arrays.asList(new RequestParameterSummary("paramKey", "paramValue"), new RequestParameterSummary("paramKeyOnly", "ClickToEdit"), new RequestParameterSummary("ClickToEdit", "paramValueOnly"), new RequestParameterSummary("ClickToEdit", "ClickToEdit")));
        softly.assertAll();
    }

    @Test
    public void testScheduleJobFailure_unknownError() {
        String genericErrorMessage = "Unknown error";
        ((ExecutorService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(new RuntimeException("Unknown error"))}).when((Object)this.executorServicesMock)).scheduleRequest(Mockito.anyString(), Mockito.anyString(), (Date)Mockito.any(Date.class), (Map)Mockito.any(Map.class));
        this.presenter.createJob(this.JOB_NAME, new Date(), this.JOB_TYPE, this.JOB_RETRIES, Collections.emptyList());
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).show();
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).cleanErrorMessages();
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).showBasicPane();
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).showInlineNotification((String)Mockito.eq((Object)"Unknown error"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testScheduleJobFailure_invalidClassError() {
        ((ExecutorService)Mockito.doAnswer(invocation -> {
            throw new Exception("Invalid command type");
        }).when((Object)this.executorServicesMock)).scheduleRequest(Mockito.anyString(), Mockito.anyString(), (Date)Mockito.any(Date.class), (Map)Mockito.any(Map.class));
        this.presenter.createJob(this.JOB_NAME, new Date(), this.JOB_TYPE, this.JOB_RETRIES, Collections.emptyList());
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).show();
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).cleanErrorMessages();
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).showBasicPane();
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).showInvalidTypeErrorMessage();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testScheduleJobFailure_emptyNameError() {
        this.presenter.createJob("", new Date(), this.JOB_TYPE, this.JOB_RETRIES, Collections.emptyList());
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).show();
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).cleanErrorMessages();
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).showEmptyNameErrorMessage();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.executorServicesMock});
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).showBasicPane();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testScheduleJobFailure_emptyTypeError() {
        this.presenter.createJob(this.JOB_NAME, new Date(), "", this.JOB_RETRIES, Collections.emptyList());
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).show();
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).cleanErrorMessages();
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).showEmptyTypeErrorMessage();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.executorServicesMock});
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).showBasicPane();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testScheduleJobFailure_emptyRetriesError() {
        this.presenter.createJob(this.JOB_NAME, new Date(), this.JOB_TYPE, "", Collections.emptyList());
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).show();
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).cleanErrorMessages();
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).showEmptyRetriesErrorMessage();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.executorServicesMock});
        ((NewJobPresenter.NewJobView)Mockito.verify((Object)this.view)).showBasicPane();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }
}

