/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.jobdetails;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.es.client.editors.events.JobSelectedEvent;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.ErrorSummary;
import org.jbpm.workbench.es.model.RequestParameterSummary;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.service.ExecutorService;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@Dependent
@WorkbenchScreen(identifier="JobDetailsScreen", preferredWidth=655)
public class JobDetailsPresenter
implements RefreshMenuBuilder.SupportsRefresh {
    @Inject
    public JobDetailsView view;
    @Inject
    PlaceManager placeManager;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    private PlaceRequest place;
    private String serverTemplateId;
    private String deploymentId;
    private Long jobId;
    @Inject
    private Caller<ExecutorService> executorServices;

    @WorkbenchPartView
    public UberElement<JobDetailsPresenter> getView() {
        return this.view;
    }

    @DefaultPosition
    public Position getPosition() {
        return CompassPosition.EAST;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.Job_Details();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    public void onJobSelectedEvent(@Observes JobSelectedEvent event) {
        this.serverTemplateId = event.getServerTemplateId();
        this.deploymentId = event.getDeploymentId();
        this.jobId = event.getJobId();
        this.refreshJobDetailsDataRemote(this.serverTemplateId, this.deploymentId, this.jobId);
    }

    public void onRefresh() {
        this.refreshJobDetailsDataRemote(this.serverTemplateId, this.deploymentId, this.jobId);
    }

    public void refreshJobDetailsDataRemote(String serverTemplateId, String deploymentId, Long jobId) {
        ((ExecutorService)this.executorServices.call(requestDetails -> {
            if (requestDetails != null) {
                this.view.setBasicDetails(requestDetails.getRequest());
                this.view.setParameters(requestDetails.getParams());
                List errors = requestDetails.getErrors();
                if (errors != null && errors.size() > 0) {
                    this.view.setErrors(errors);
                }
                this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, this.getJobDetailTitle(requestDetails.getRequest())));
            }
        })).getRequestDetails(serverTemplateId, deploymentId, jobId);
    }

    protected String getJobDetailTitle(RequestSummary summary) {
        String title = ((Long)summary.getId()).toString();
        if (summary.getKey() != null) {
            title = title + " - " + summary.getKey();
        }
        return title;
    }

    @Inject
    public void setExecutorService(Caller<ExecutorService> executorServices) {
        this.executorServices = executorServices;
    }

    @Inject
    public void setChangeTitleWidgetEvent(Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent) {
        this.changeTitleWidgetEvent = changeTitleWidgetEvent;
    }

    public static interface JobDetailsView
    extends UberElement<JobDetailsPresenter> {
        public void setBasicDetails(RequestSummary var1);

        public void setParameters(List<RequestParameterSummary> var1);

        public void setErrors(List<ErrorSummary> var1);
    }
}

