/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.errordetails;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.es.client.editors.errordetails.ExecutionErrorDetailsPresenter;
import org.jbpm.workbench.es.client.editors.errordetails.ExecutionErrorDetailsViewImpl;
import org.jbpm.workbench.es.client.editors.events.ExecutionErrorSelectedEvent;
import org.jbpm.workbench.es.model.ExecutionErrorSummary;
import org.jbpm.workbench.es.service.ExecutorService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ExecutionErrorDetailsPresenterTest {
    private final String serverTemplateId = "serverTemplateTest";
    private final String deploymentId = "deploymentIdTest";
    private final String errorId = "1";
    @Mock
    protected ExecutorService executorServiceMock;
    protected Caller<ExecutorService> executorService;
    @Mock
    private ExecutionErrorDetailsViewImpl viewMock;
    @Mock
    private EventSourceMock<ChangeTitleWidgetEvent> changeTitleWidgetEventMock;
    @InjectMocks
    private ExecutionErrorDetailsPresenter presenter;
    private ExecutionErrorSummary testError = ExecutionErrorDetailsPresenterTest.createTestError("1", "deploymentIdTest");

    private static ExecutionErrorSummary createTestError(String errorId, String deploymentId) {
        return ExecutionErrorSummary.builder().errorId(errorId).deploymentId(deploymentId).build();
    }

    @Before
    public void setupMocks() {
        this.executorService = new CallerMock((Object)this.executorServiceMock);
        this.presenter.setExecutorService(this.executorService);
        this.presenter.setChangeTitleWidgetEvent(this.changeTitleWidgetEventMock);
        Mockito.when((Object)this.executorServiceMock.getError("serverTemplateTest", "deploymentIdTest", "1")).thenReturn((Object)this.testError);
    }

    @Test
    public void testRefreshErrorDetails() {
        this.presenter.refreshExecutionErrorDataRemote("serverTemplateTest", "deploymentIdTest", "1");
        this.assertRefresErrorDetails();
    }

    @Test
    public void testErrorSelection() {
        this.presenter.onExecutionErrorSelectedEvent(new ExecutionErrorSelectedEvent("serverTemplateTest", "deploymentIdTest", "1"));
        this.assertRefresErrorDetails();
    }

    private void assertRefresErrorDetails() {
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).getError((String)Mockito.eq((Object)"serverTemplateTest"), (String)Mockito.eq((Object)"deploymentIdTest"), (String)Mockito.eq((Object)"1"));
        ((ExecutionErrorDetailsViewImpl)Mockito.verify((Object)this.viewMock)).setValue((ExecutionErrorSummary)Mockito.eq((Object)this.testError));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ChangeTitleWidgetEvent.class);
        ((EventSourceMock)Mockito.verify(this.changeTitleWidgetEventMock)).fire((Object)((ChangeTitleWidgetEvent)captor.capture()));
        Assert.assertEquals((Object)(this.testError.getProcessId() + " - " + this.testError.getProcessInstanceId() + " (" + this.testError.getDeploymentId() + ")"), (Object)((ChangeTitleWidgetEvent)captor.getValue()).getTitle());
    }

    @Test
    public void testErrorDetailTitleGeneration() {
        ExecutionErrorSummary testError = ExecutionErrorDetailsPresenterTest.createTestError("1", "deploymentIdTest");
        String title = ExecutionErrorDetailsPresenter.getErrorDetailTitle((ExecutionErrorSummary)testError);
        Assert.assertEquals((Object)(testError.getProcessId() + " - " + testError.getProcessInstanceId() + " (" + testError.getDeploymentId() + ")"), (Object)title);
    }
}

