/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend.provider.process;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.jbpm.workbench.forms.display.api.KieWorkbenchFormRenderingSettings;
import org.jbpm.workbench.forms.display.backend.provider.AbstractFormProvidingEngineTest;
import org.jbpm.workbench.forms.display.backend.provider.AbstractKieWorkbenchFormsProvider;
import org.jbpm.workbench.forms.display.backend.provider.ProcessFormsValuesProcessor;
import org.jbpm.workbench.forms.display.backend.provider.model.Invoice;
import org.jbpm.workbench.forms.display.backend.provider.model.InvoiceLine;
import org.jbpm.workbench.forms.service.providing.ProcessRenderingSettings;
import org.jbpm.workbench.forms.service.providing.model.ProcessDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContextManager;
import org.kie.workbench.common.forms.jbpm.service.bpmn.DynamicBPMNFormGenerator;
import org.kie.workbench.common.forms.serialization.FormDefinitionSerializer;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class AbstractStartProcessFormTest<PROVIDER extends AbstractKieWorkbenchFormsProvider>
extends AbstractFormProvidingEngineTest<ProcessRenderingSettings, ProcessFormsValuesProcessor, PROVIDER> {
    @Mock
    protected ProcessDefinition process;

    @Test
    public void testFormProvider() {
        KieWorkbenchFormRenderingSettings result = this.workbenchFormsProvider.render(this.generateSettings());
        this.checkRenderingSettings(result);
    }

    @Override
    protected ProcessRenderingSettings generateSettings() {
        Mockito.when((Object)this.process.getId()).thenReturn((Object)"invoices");
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("invoice", Invoice.class.getName());
        return new ProcessRenderingSettings(this.process, formData, this.getFormContent(), this.marshallerContext);
    }

    @Override
    protected ProcessFormsValuesProcessor getProcessorInstance(FormDefinitionSerializer formSerializer, BackendFormRenderingContextManager contextManager, DynamicBPMNFormGenerator dynamicBPMNFormGenerator) {
        return new ProcessFormsValuesProcessor(formSerializer, contextManager, dynamicBPMNFormGenerator);
    }

    @Override
    protected Map<String, Object> getFormValues() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> client = new HashMap<String, Object>();
        client.put("id", new Long(1234L));
        client.put("name", "John Snow");
        client.put("address", "Winterfell");
        ArrayList lines = new ArrayList();
        HashMap<String, Object> line = new HashMap<String, Object>();
        line.put("product", "Really Dangerous Sword");
        line.put("quantity", 1);
        line.put("price", 100.5);
        line.put("total", 100.5);
        lines.add(line);
        HashMap<String, Object> invoice = new HashMap<String, Object>();
        invoice.put("client", client);
        invoice.put("lines", lines);
        invoice.put("total", 100.5);
        invoice.put("comments", "Everything was perfect");
        invoice.put("date", new Date());
        result.put("invoice", invoice);
        return result;
    }

    @Override
    protected void checkRuntimeValues(Map<String, Object> result) {
        TestCase.assertNotNull((String)"There should be an invoice on the result Map", (Object)result.get("invoice"));
        Assert.assertTrue((String)"There should be an invoice on the result Map", (boolean)(result.get("invoice") instanceof Invoice));
        Invoice invoice = (Invoice)result.get("invoice");
        TestCase.assertNotNull((String)"Invoice should have a client", (Object)invoice.getClient());
        Assert.assertEquals((Object)invoice.getClient().getId(), (Object)new Long(1234L));
        Assert.assertEquals((Object)"John Snow", (Object)invoice.getClient().getName());
        Assert.assertEquals((Object)"Winterfell", (Object)invoice.getClient().getAddress());
        TestCase.assertNotNull((Object)invoice.getDate());
        TestCase.assertNotNull((Object)invoice.getComments());
        Assert.assertEquals((Object)invoice.getTotal(), (Object)new Double(100.5));
        TestCase.assertNotNull(invoice.getLines());
        Assert.assertTrue((invoice.getLines().size() == 1 ? 1 : 0) != 0);
        InvoiceLine line = invoice.getLines().get(0);
        Assert.assertEquals((Object)"Really Dangerous Sword", (Object)line.getProduct());
        Assert.assertEquals((Object)new Integer(1), (Object)line.getQuantity());
        Assert.assertEquals((Object)new Double(100.5), (Object)line.getPrice());
        Assert.assertEquals((Object)new Double(100.5), (Object)line.getTotal());
    }
}

