/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jbpm.workbench.forms.display.backend.provider.KieWorkbenchFormsValuesProcessor;
import org.jbpm.workbench.forms.service.providing.TaskRenderingSettings;
import org.jbpm.workbench.forms.service.providing.model.TaskDefinition;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContext;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContextManager;
import org.kie.workbench.common.forms.dynamic.service.shared.RenderMode;
import org.kie.workbench.common.forms.jbpm.model.authoring.JBPMVariable;
import org.kie.workbench.common.forms.jbpm.model.authoring.task.TaskFormModel;
import org.kie.workbench.common.forms.jbpm.service.bpmn.DynamicBPMNFormGenerator;
import org.kie.workbench.common.forms.jbpm.service.bpmn.util.BPMNVariableUtils;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.serialization.FormDefinitionSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class TaskFormValuesProcessor
extends KieWorkbenchFormsValuesProcessor<TaskRenderingSettings> {
    private static final Logger logger = LoggerFactory.getLogger(TaskFormValuesProcessor.class);

    @Inject
    public TaskFormValuesProcessor(FormDefinitionSerializer formSerializer, BackendFormRenderingContextManager contextManager, DynamicBPMNFormGenerator dynamicBPMNFormGenerator) {
        super(formSerializer, contextManager, dynamicBPMNFormGenerator);
    }

    @Override
    protected String getFormName(TaskRenderingSettings settings) {
        return settings.getTask().getFormName();
    }

    @Override
    protected Map<String, Object> getOutputValues(Map<String, Object> values, FormDefinition form, TaskRenderingSettings settings) {
        if (this.isValid(form)) {
            TaskDefinition task = settings.getTask();
            task.getTaskInputDefinitions().keySet().forEach(key -> {
                if (!task.getTaskOutputDefinitions().containsKey(key)) {
                    values.remove(key);
                }
            });
            return values;
        }
        throw new IllegalArgumentException("Form not valid for task");
    }

    @Override
    protected void prepareContext(TaskRenderingSettings settings, BackendFormRenderingContext context) {
        context.getRenderingContext().setRenderMode(!"InProgress".equals(settings.getTask().getStatus()) ? RenderMode.READ_ONLY_MODE : RenderMode.EDIT_MODE);
    }

    @Override
    protected Map<String, Object> generateRawFormData(TaskRenderingSettings settings, FormDefinition form) {
        HashMap<String, Object> formData = new HashMap<String, Object>();
        if (this.isValid(form)) {
            Map inputs = settings.getInputs();
            Map outputs = settings.getOutputs();
            formData.putAll(inputs);
            if (settings.getTask().isOutputIncluded()) {
                formData.putAll(outputs);
            }
        }
        return formData;
    }

    @Override
    protected Collection<FormDefinition> generateDefaultFormsForContext(TaskRenderingSettings settings) {
        ArrayList variables = new ArrayList();
        TaskDefinition task = settings.getTask();
        HashMap<String, String> taskData = new HashMap<String, String>();
        taskData.putAll(task.getTaskInputDefinitions());
        taskData.putAll(task.getTaskOutputDefinitions());
        taskData.forEach((name, type) -> {
            if (BPMNVariableUtils.isValidInputName((String)name)) {
                variables.add(new JBPMVariable(name, type));
            }
        });
        TaskFormModel formModel = new TaskFormModel(task.getProcessId(), task.getFormName(), variables);
        Collection forms = this.dynamicBPMNFormGenerator.generateTaskForms(formModel, settings.getMarshallerContext().getClassloader());
        taskData.keySet().removeAll(task.getTaskOutputDefinitions().keySet());
        boolean done = false;
        Iterator it = forms.iterator();
        while (it.hasNext() && !done) {
            FormDefinition form = (FormDefinition)it.next();
            if (!form.getName().equals(this.getFormName(settings) + "-taskform")) continue;
            form.getFields().forEach(field -> field.setReadOnly(Boolean.valueOf(taskData.containsKey(field.getBinding()))));
            done = true;
        }
        return forms;
    }

    @Override
    protected boolean isValid(FormDefinition rootForm) {
        return rootForm != null && rootForm.getModel() instanceof TaskFormModel;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

