/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend.provider;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jbpm.workbench.forms.display.impl.StaticHTMLFormRenderingSettings;
import org.jbpm.workbench.forms.service.providing.FormProvider;
import org.jbpm.workbench.forms.service.providing.ProcessRenderingSettings;
import org.jbpm.workbench.forms.service.providing.TaskRenderingSettings;

public abstract class FreemakerFormProvider
implements FormProvider<StaticHTMLFormRenderingSettings> {
    protected abstract InputStream getProcessTemplateInputStream(ProcessRenderingSettings var1);

    protected abstract InputStream getTaskTemplateInputStream(TaskRenderingSettings var1);

    public StaticHTMLFormRenderingSettings render(ProcessRenderingSettings settings) {
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("process", settings.getProcess());
        renderContext.put("outputs", settings.getProcessData());
        renderContext.put("marshallerContext", settings.getMarshallerContext());
        return this.renderForm(settings.getProcess().getName(), this.getProcessTemplateInputStream(settings), renderContext);
    }

    public StaticHTMLFormRenderingSettings render(TaskRenderingSettings settings) {
        Map outputs;
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("task", settings.getTask());
        renderContext.put("marshallerContext", settings.getMarshallerContext());
        Map inputs = settings.getInputs();
        if (inputs != null && !inputs.isEmpty()) {
            renderContext.put("inputs", inputs);
            renderContext.putAll(inputs);
        }
        if ((outputs = settings.getOutputs()) != null && !outputs.isEmpty()) {
            renderContext.put("outputs", outputs);
            renderContext.putAll(outputs);
            settings.getTask().setOutputIncluded(true);
        }
        return this.renderForm(settings.getTask().getName(), this.getTaskTemplateInputStream(settings), renderContext);
    }

    protected StaticHTMLFormRenderingSettings renderForm(String name, InputStream src, Map<String, Object> renderContext) {
        if (src == null) {
            return null;
        }
        String htmlTemplate = "";
        StringWriter writer = null;
        InputStreamReader source = null;
        try {
            Configuration cfg = new Configuration();
            BeansWrapper defaultInstance = new BeansWrapper();
            defaultInstance.setSimpleMapWrapper(true);
            cfg.setObjectWrapper((ObjectWrapper)defaultInstance);
            cfg.setTemplateUpdateDelay(0);
            source = new InputStreamReader(src);
            Template temp = new Template(name, (Reader)source, cfg);
            writer = new StringWriter();
            temp.process(renderContext, (Writer)writer);
            writer.flush();
            htmlTemplate = writer.getBuffer().toString();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Failed to process form template", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                IOUtils.closeQuietly(source);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((Reader)source);
        return new StaticHTMLFormRenderingSettings(htmlTemplate);
    }
}

