/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.inject.Instance;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.jbpm.workbench.forms.display.FormRenderingSettings;
import org.jbpm.workbench.forms.display.api.KieServerFormRenderingSettings;
import org.jbpm.workbench.forms.display.api.KieWorkbenchFormRenderingSettings;
import org.jbpm.workbench.forms.display.api.TaskFormPermissionDeniedException;
import org.jbpm.workbench.forms.display.backend.FormServiceEntryPointImpl;
import org.jbpm.workbench.forms.display.backend.provider.DefaultKieWorkbenchFormsProvider;
import org.jbpm.workbench.forms.display.backend.provider.KieWorkbenchFormsProvider;
import org.jbpm.workbench.forms.display.backend.provider.ProcessFormsValuesProcessor;
import org.jbpm.workbench.forms.display.backend.provider.TaskFormValuesProcessor;
import org.jbpm.workbench.forms.display.backend.provider.util.FormContentReader;
import org.jbpm.workbench.forms.service.providing.FormProvider;
import org.jbpm.workbench.forms.service.providing.ProcessRenderingSettings;
import org.jbpm.workbench.forms.service.providing.TaskRenderingSettings;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.TaskInputsDefinition;
import org.kie.server.api.model.definition.TaskOutputsDefinition;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.client.DocumentServicesClient;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.UIServicesClient;
import org.kie.server.client.UserTaskServicesClient;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.kie.soup.project.datamodel.commons.util.RawMVELEvaluator;
import org.kie.workbench.common.forms.data.modeller.service.ext.ModelReaderService;
import org.kie.workbench.common.forms.data.modeller.service.impl.ext.dmo.runtime.RuntimeDMOModelReader;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.BackendFormRenderingContextManagerImpl;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.FieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.FieldValueMarshallerRegistry;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.FieldValueMarshallerRegistryImpl;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.TextAreaFormFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.models.MultipleSubFormFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.models.SubFormFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.time.DateMultipleInputFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.time.DateMultipleSelectorFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.time.LocalDateFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.validation.ContextModelConstraintsExtractor;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.validation.impl.ContextModelConstraintsExtractorImpl;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContextManager;
import org.kie.workbench.common.forms.fields.test.TestFieldManager;
import org.kie.workbench.common.forms.fields.test.TestMetaDataEntryManager;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.BPMNFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.runtime.BPMNRuntimeFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.impl.DynamicBPMNFormGeneratorImpl;
import org.kie.workbench.common.forms.jbpm.service.bpmn.DynamicBPMNFormGenerator;
import org.kie.workbench.common.forms.service.shared.FieldManager;
import org.kie.workbench.common.forms.service.shared.meta.processing.MetaDataEntryManager;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FieldSerializer;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FormDefinitionSerializerImpl;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FormModelSerializer;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class FormServiceEntryPointImplTest {
    private KieWorkbenchFormsProvider kieWorkbenchFormsProvider;
    private DefaultKieWorkbenchFormsProvider defaultProvider;
    @Mock
    private DocumentServicesClient documentServicesClient;
    @Mock
    private UIServicesClient uiServicesClient;
    @Mock
    private UserTaskServicesClient userTaskServicesClient;
    @Mock
    private ProcessServicesClient processServicesClient;
    @Mock
    private KieServicesClient kieServicesClient;
    @Mock
    private ModelReaderService<ClassLoader> modelReaderService;
    private FieldValueMarshallerRegistry registry;
    private DynamicBPMNFormGenerator dynamicBPMNFormGenerator;
    private BackendFormRenderingContextManagerImpl backendFormRenderingContextManager;
    private BPMNRuntimeFormGeneratorService runtimeFormGeneratorService;
    private FormServiceEntryPointImpl serviceEntryPoint;
    private String formContent;

    @Before
    public void init() {
        SubFormFieldValueMarshaller subFormFieldValueMarshaller = new SubFormFieldValueMarshaller();
        MultipleSubFormFieldValueMarshaller multipleSubFormFieldValueMarshaller = new MultipleSubFormFieldValueMarshaller();
        List<FieldValueMarshaller> marshallers = Arrays.asList(subFormFieldValueMarshaller, multipleSubFormFieldValueMarshaller, new DateMultipleInputFieldValueMarshaller(), new DateMultipleSelectorFieldValueMarshaller(), new LocalDateFieldValueMarshaller(), new TextAreaFormFieldValueMarshaller());
        Instance marshallersInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)marshallersInstance.iterator()).then(proc -> marshallers.iterator());
        this.registry = new FieldValueMarshallerRegistryImpl(marshallersInstance);
        subFormFieldValueMarshaller.setRegistry(this.registry);
        multipleSubFormFieldValueMarshaller.setRegistry(this.registry);
        this.backendFormRenderingContextManager = new BackendFormRenderingContextManagerImpl(this.registry, (ContextModelConstraintsExtractor)new ContextModelConstraintsExtractorImpl());
        Mockito.when((Object)this.modelReaderService.getModelReader((Object)((ClassLoader)Mockito.any()))).thenReturn((Object)new RuntimeDMOModelReader(this.getClass().getClassLoader(), (MVELEvaluator)new RawMVELEvaluator()));
        this.runtimeFormGeneratorService = new BPMNRuntimeFormGeneratorService(this.modelReaderService, (FieldManager)new TestFieldManager());
        this.dynamicBPMNFormGenerator = new DynamicBPMNFormGeneratorImpl((BPMNFormGeneratorService)this.runtimeFormGeneratorService);
        FormDefinitionSerializerImpl serializer = new FormDefinitionSerializerImpl(new FieldSerializer(), new FormModelSerializer(), (MetaDataEntryManager)new TestMetaDataEntryManager());
        ProcessFormsValuesProcessor processValuesProcessor = new ProcessFormsValuesProcessor((FormDefinitionSerializer)serializer, (BackendFormRenderingContextManager)this.backendFormRenderingContextManager, this.dynamicBPMNFormGenerator);
        TaskFormValuesProcessor taskValuesProcessor = new TaskFormValuesProcessor((FormDefinitionSerializer)serializer, (BackendFormRenderingContextManager)this.backendFormRenderingContextManager, this.dynamicBPMNFormGenerator);
        this.kieWorkbenchFormsProvider = new KieWorkbenchFormsProvider(processValuesProcessor, taskValuesProcessor);
        this.defaultProvider = (DefaultKieWorkbenchFormsProvider)Mockito.spy((Object)new DefaultKieWorkbenchFormsProvider(processValuesProcessor, taskValuesProcessor));
        Mockito.when((Object)this.kieServicesClient.getClassLoader()).thenReturn((Object)this.getClass().getClassLoader());
        Instance instance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)instance.iterator()).then(result -> Arrays.asList(this.kieWorkbenchFormsProvider).iterator());
        this.serviceEntryPoint = new FormServiceEntryPointImpl(instance, (FormProvider)this.defaultProvider){

            protected <T> T getClient(String serverTemplateId, String containerId, Class<T> clientType) {
                if (clientType.equals(DocumentServicesClient.class)) {
                    return (T)FormServiceEntryPointImplTest.this.documentServicesClient;
                }
                if (clientType.equals(UIServicesClient.class)) {
                    return (T)FormServiceEntryPointImplTest.this.uiServicesClient;
                }
                if (clientType.equals(UserTaskServicesClient.class)) {
                    return (T)FormServiceEntryPointImplTest.this.userTaskServicesClient;
                }
                if (clientType.equals(ProcessServicesClient.class)) {
                    return (T)FormServiceEntryPointImplTest.this.processServicesClient;
                }
                return null;
            }

            protected KieServicesClient getKieServicesClient(String serverTemplateId, String containerId) {
                return FormServiceEntryPointImplTest.this.kieServicesClient;
            }
        };
        ProcessDefinition processDefinition = new ProcessDefinition();
        processDefinition.setId("invoices");
        processDefinition.setName("invoices");
        processDefinition.setContainerId("localhost");
        processDefinition.setPackageName("org.jbpm.test");
        Mockito.when((Object)this.processServicesClient.getProcessDefinition(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)processDefinition);
        Mockito.when((Object)this.processServicesClient.getUserTaskInputDefinitions(Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)new TaskInputsDefinition());
        Mockito.when((Object)this.processServicesClient.getUserTaskOutputDefinitions(Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)new TaskOutputsDefinition());
        TaskInstance taskInstance = new TaskInstance();
        taskInstance.setId(new Long(12L));
        taskInstance.setName("modify");
        taskInstance.setFormName("modify");
        taskInstance.setDescription("modify");
        taskInstance.setProcessId("invoices");
        taskInstance.setInputData(new HashMap());
        taskInstance.setOutputData(new HashMap());
        Mockito.when((Object)this.userTaskServicesClient.getTaskInstance(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)taskInstance);
    }

    @Test
    public void testRenderProcessForm() {
        this.formContent = FormContentReader.getStartProcessForms();
        Mockito.when((Object)this.uiServicesClient.getProcessRawForm(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)this.formContent);
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayProcess("template", "domain", "invoices", false);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClient)).getProcessDefinition(Mockito.anyString(), Mockito.anyString());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient)).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getProcessRawForm(Mockito.anyString(), Mockito.anyString());
        ((DefaultKieWorkbenchFormsProvider)Mockito.verify((Object)this.defaultProvider, (VerificationMode)Mockito.never())).render((ProcessRenderingSettings)Mockito.any(ProcessRenderingSettings.class));
        this.checkRenderingSettings(settings);
    }

    @Test
    public void testRenderProcessDefaultForm() {
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayProcess("template", "domain", "invoices", false);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClient)).getProcessDefinition(Mockito.anyString(), Mockito.anyString());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient, (VerificationMode)Mockito.times((int)2))).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getProcessRawForm(Mockito.anyString(), Mockito.anyString());
        ((DefaultKieWorkbenchFormsProvider)Mockito.verify((Object)this.defaultProvider)).render((ProcessRenderingSettings)Mockito.any(ProcessRenderingSettings.class));
        this.checkRenderingSettings(settings);
    }

    @Test
    public void testRenderProcessFormFromWrongFormContent() {
        this.formContent = "this form content is wrong and a default form should be generated";
        Mockito.when((Object)this.uiServicesClient.getProcessRawForm(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)this.formContent);
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayProcess("template", "domain", "invoices", false);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClient)).getProcessDefinition(Mockito.anyString(), Mockito.anyString());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient, (VerificationMode)Mockito.times((int)2))).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getProcessRawForm(Mockito.anyString(), Mockito.anyString());
        ((DefaultKieWorkbenchFormsProvider)Mockito.verify((Object)this.defaultProvider)).render((ProcessRenderingSettings)Mockito.any(ProcessRenderingSettings.class));
        this.checkRenderingSettings(settings);
    }

    @Test
    public void testRenderProcessDefaultFormWithException() {
        Mockito.when((Object)this.uiServicesClient.getProcessRawForm(Mockito.anyString(), Mockito.anyString())).thenThrow(new Throwable[]{new KieServicesException("Unable to find form")});
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayProcess("template", "domain", "invoices", false);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClient)).getProcessDefinition(Mockito.anyString(), Mockito.anyString());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient)).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getProcessRawForm(Mockito.anyString(), Mockito.anyString());
        ((DefaultKieWorkbenchFormsProvider)Mockito.verify((Object)this.defaultProvider)).render((ProcessRenderingSettings)Mockito.any(ProcessRenderingSettings.class));
        this.checkRenderingSettings(settings);
    }

    @Test
    public void testRenderTaskForm() {
        this.formContent = FormContentReader.getTaskForms();
        Mockito.when((Object)this.uiServicesClient.getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()))).thenReturn((Object)this.formContent);
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayTask("template", "domain", 12L);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient)).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()));
        ((DefaultKieWorkbenchFormsProvider)Mockito.verify((Object)this.defaultProvider, (VerificationMode)Mockito.never())).render((TaskRenderingSettings)Mockito.any(TaskRenderingSettings.class));
        this.checkRenderingSettings(settings);
    }

    @Test
    public void testRenderTaskDefaultForm() {
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayTask("template", "domain", 12L);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient, (VerificationMode)Mockito.times((int)2))).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()));
        ((DefaultKieWorkbenchFormsProvider)Mockito.verify((Object)this.defaultProvider)).render((TaskRenderingSettings)Mockito.any(TaskRenderingSettings.class));
        this.checkRenderingSettings(settings);
    }

    @Test(expected=TaskFormPermissionDeniedException.class)
    public void testRenderTaskFormWithPermissionException() {
        Mockito.when((Object)this.uiServicesClient.getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()))).thenThrow(new Throwable[]{new KieServicesHttpException("", Integer.valueOf(Response.Status.UNAUTHORIZED.getStatusCode()), "", "")});
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayTask("template", "domain", 12L);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient, (VerificationMode)Mockito.times((int)2))).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()));
        this.checkRenderingSettings(settings);
    }

    @Test
    public void testRenderTaskFormWithException() {
        Mockito.when((Object)this.uiServicesClient.getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()))).thenThrow(new Throwable[]{new RuntimeException("Unable to find form")});
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayTask("template", "domain", 12L);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient)).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()));
        ((DefaultKieWorkbenchFormsProvider)Mockito.verify((Object)this.defaultProvider)).render((TaskRenderingSettings)Mockito.any(TaskRenderingSettings.class));
        this.checkRenderingSettings(settings);
    }

    @Test
    public void testRenderTaskDefaultFormWithException() {
        Mockito.when((Object)this.uiServicesClient.getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()))).thenThrow(new Throwable[]{new KieServicesException("Unable to find form")});
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayTask("template", "domain", 12L);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient)).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()));
        ((DefaultKieWorkbenchFormsProvider)Mockito.verify((Object)this.defaultProvider)).render((TaskRenderingSettings)Mockito.any(TaskRenderingSettings.class));
        this.checkRenderingSettings(settings);
    }

    @Test
    public void testRenderTaskFormFromWrongFormContent() {
        this.formContent = "this form content is wrong and a default form should be generated";
        Mockito.when((Object)this.uiServicesClient.getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()))).thenReturn((Object)this.formContent);
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayTask("template", "domain", 12L);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient, (VerificationMode)Mockito.times((int)2))).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()));
        this.checkRenderingSettings(settings);
    }

    @Test
    public void testKieServerRenderProcessForm() {
        this.serviceEntryPoint.setKieServerFormRenderer(true);
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayProcess("template", "domain", "invoices", false);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClient, (VerificationMode)Mockito.never())).getProcessDefinition(Mockito.anyString(), Mockito.anyString());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient, (VerificationMode)Mockito.never())).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient, (VerificationMode)Mockito.never())).getProcessRawForm(Mockito.anyString(), Mockito.anyString());
        ((DefaultKieWorkbenchFormsProvider)Mockito.verify((Object)this.defaultProvider, (VerificationMode)Mockito.never())).render((ProcessRenderingSettings)Mockito.any(ProcessRenderingSettings.class));
        this.checkKieServerRenderingSettings(settings);
    }

    @Test
    public void testKieServerRenderTaskForm() {
        this.serviceEntryPoint.setKieServerFormRenderer(true);
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayTask("template", "domain", 12L);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient, (VerificationMode)Mockito.never())).getTaskInstance(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient, (VerificationMode)Mockito.never())).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient, (VerificationMode)Mockito.never())).getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()));
        ((DefaultKieWorkbenchFormsProvider)Mockito.verify((Object)this.defaultProvider, (VerificationMode)Mockito.never())).render((TaskRenderingSettings)Mockito.any(TaskRenderingSettings.class));
        this.checkKieServerRenderingSettings(settings);
    }

    protected void checkRenderingSettings(FormRenderingSettings settings) {
        Assert.assertNotNull((String)"Settings cannot be null", (Object)settings);
        Assert.assertTrue((String)"Settings must be WB Forms", (boolean)(settings instanceof KieWorkbenchFormRenderingSettings));
        KieWorkbenchFormRenderingSettings wbSettings = (KieWorkbenchFormRenderingSettings)settings;
        Assert.assertNotNull((String)"Rendering context shouldn't be empty", (Object)wbSettings.getRenderingContext());
        Assert.assertNotNull((String)"There should be a default FormDefinition", (Object)wbSettings.getRenderingContext().getRootForm());
    }

    protected void checkKieServerRenderingSettings(FormRenderingSettings settings) {
        Assert.assertNotNull((String)"Settings cannot be null", (Object)settings);
        Assert.assertTrue((String)"Settings must be KieServer Forms", (boolean)(settings instanceof KieServerFormRenderingSettings));
        KieServerFormRenderingSettings ksSettings = (KieServerFormRenderingSettings)settings;
        Assert.assertNotNull((String)"URL shouldn't be empty", (Object)ksSettings.getUrl());
    }

    protected String getFormContent() {
        try {
            return IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/forms/invoices-taskform.frm"));
        }
        catch (IOException ex) {
            Assert.fail((String)"Exception thrown getting form content");
            return "";
        }
    }
}

