/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.client.display.task;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.forms.client.display.api.HumanTaskFormDisplayer;
import org.jbpm.workbench.forms.client.display.util.ActionRequest;
import org.jbpm.workbench.forms.client.display.util.JSNIHelper;
import org.jbpm.workbench.forms.client.i18n.Constants;
import org.jbpm.workbench.forms.display.FormDisplayerConfig;
import org.jbpm.workbench.forms.display.FormRenderingSettings;
import org.jbpm.workbench.forms.display.view.FormContentResizeListener;
import org.jbpm.workbench.ht.model.TaskKey;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.model.events.TaskCompletedEvent;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mvp.Command;

public abstract class AbstractHumanTaskFormDisplayer<S extends FormRenderingSettings>
implements HumanTaskFormDisplayer<S> {
    public static final String ACTION_CLAIM_TASK = "claimTask";
    public static final String ACTION_START_TASK = "startTask";
    public static final String ACTION_RELEASE_TASK = "releaseTask";
    public static final String ACTION_SAVE_TASK = "saveTask";
    public static final String ACTION_COMPLETE_TASK = "completeTask";
    protected long taskId = -1L;
    protected S renderingSettings;
    protected String opener;
    protected String taskName;
    protected String serverTemplateId;
    protected String deploymentId;
    protected FormPanel container = (FormPanel)GWT.create(FormPanel.class);
    protected ButtonGroup buttonsContainer = (ButtonGroup)GWT.create(ButtonGroup.class);
    protected FlowPanel formContainer = (FlowPanel)GWT.create(FlowPanel.class);
    protected FormContentResizeListener resizeListener;
    protected Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    protected ErrorPopupPresenter errorPopup;
    @Inject
    protected Caller<TaskService> taskService;
    @Inject
    protected Event<TaskRefreshedEvent> taskRefreshed;
    @Inject
    protected Event<TaskCompletedEvent> taskCompleted;
    @Inject
    protected User identity;
    @Inject
    protected JSNIHelper jsniHelper;
    private Command onClose;
    private Command onRefresh;

    protected abstract void initDisplayer();

    protected abstract void completeFromDisplayer();

    protected abstract void saveStateFromDisplayer();

    protected abstract void startFromDisplayer();

    protected abstract void claimFromDisplayer();

    protected abstract void releaseFromDisplayer();

    @PostConstruct
    protected void init() {
        this.container.getElement().setId("form-data");
        this.container.add((Widget)this.formContainer);
    }

    @Override
    public void init(FormDisplayerConfig<TaskKey, S> config, Command onCloseCommand, Command onRefreshCommand, FormContentResizeListener resizeListener) {
        if (this.renderingSettings != null) {
            this.clearRenderingSettings();
            this.clearStatus();
        }
        this.serverTemplateId = ((TaskKey)config.getKey()).getServerTemplateId();
        this.taskId = ((TaskKey)config.getKey()).getTaskId();
        this.deploymentId = ((TaskKey)config.getKey()).getDeploymentId();
        this.renderingSettings = config.getRenderingSettings();
        this.opener = config.getFormOpener();
        this.resizeListener = resizeListener;
        this.onClose = onCloseCommand;
        this.onRefresh = onRefreshCommand;
        if (this.renderingSettings == null) {
            return;
        }
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<TaskSummary>(){

            public void callback(TaskSummary task) {
                if (task == null) {
                    return;
                }
                AbstractHumanTaskFormDisplayer.this.buttonsContainer.clear();
                AbstractHumanTaskFormDisplayer.this.taskName = task.getName();
                AbstractHumanTaskFormDisplayer.this.deploymentId = task.getDeploymentId();
                if (AbstractHumanTaskFormDisplayer.this.opener != null) {
                    AbstractHumanTaskFormDisplayer.this.injectEventListener(AbstractHumanTaskFormDisplayer.this);
                } else {
                    if (task.getStatus().equals("Ready")) {
                        Button claimButton = new Button();
                        claimButton.setType(ButtonType.PRIMARY);
                        claimButton.setText(AbstractHumanTaskFormDisplayer.this.constants.Claim());
                        claimButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                AbstractHumanTaskFormDisplayer.this.claimFromDisplayer();
                            }
                        });
                        AbstractHumanTaskFormDisplayer.this.buttonsContainer.add((Widget)claimButton);
                    }
                    if (task.getStatus().equals("Reserved") && task.getActualOwner().equals(AbstractHumanTaskFormDisplayer.this.identity.getIdentifier())) {
                        Button releaseButton = new Button();
                        releaseButton.setText(AbstractHumanTaskFormDisplayer.this.constants.Release());
                        releaseButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                AbstractHumanTaskFormDisplayer.this.releaseFromDisplayer();
                            }
                        });
                        AbstractHumanTaskFormDisplayer.this.buttonsContainer.add((Widget)releaseButton);
                        Button startButton = new Button();
                        startButton.setType(ButtonType.PRIMARY);
                        startButton.setText(AbstractHumanTaskFormDisplayer.this.constants.Start());
                        startButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                AbstractHumanTaskFormDisplayer.this.startFromDisplayer();
                            }
                        });
                        AbstractHumanTaskFormDisplayer.this.buttonsContainer.add((Widget)startButton);
                    } else if (task.getStatus().equals("InProgress") && task.getActualOwner().equals(AbstractHumanTaskFormDisplayer.this.identity.getIdentifier())) {
                        Button saveButton = new Button();
                        saveButton.setText(AbstractHumanTaskFormDisplayer.this.constants.Save());
                        saveButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                AbstractHumanTaskFormDisplayer.this.saveStateFromDisplayer();
                            }
                        });
                        AbstractHumanTaskFormDisplayer.this.buttonsContainer.add((Widget)saveButton);
                        Button releaseButton = new Button();
                        releaseButton.setText(AbstractHumanTaskFormDisplayer.this.constants.Release());
                        releaseButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                AbstractHumanTaskFormDisplayer.this.releaseFromDisplayer();
                            }
                        });
                        AbstractHumanTaskFormDisplayer.this.buttonsContainer.add((Widget)releaseButton);
                        Button completeButton = new Button();
                        completeButton.setType(ButtonType.PRIMARY);
                        completeButton.setText(AbstractHumanTaskFormDisplayer.this.constants.Complete());
                        completeButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                AbstractHumanTaskFormDisplayer.this.completeFromDisplayer();
                            }
                        });
                        AbstractHumanTaskFormDisplayer.this.buttonsContainer.add((Widget)completeButton);
                    }
                }
                AbstractHumanTaskFormDisplayer.this.initDisplayer();
            }
        }, this.getUnexpectedErrorCallback())).getTask(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId));
    }

    protected void clearRenderingSettings() {
        this.renderingSettings = null;
    }

    @Override
    public void complete(Map<String, Object> params) {
        ((TaskService)this.taskService.call(this.getCompleteTaskRemoteCallback(), this.getUnexpectedErrorCallback())).completeTask(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId), params);
    }

    @Override
    public void claim() {
        ((TaskService)this.taskService.call(this.getClaimTaskCallback(), this.getUnexpectedErrorCallback())).claimTask(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId));
    }

    @Override
    public void release() {
        ((TaskService)this.taskService.call(this.getReleaseTaskRemoteCallback(), this.getUnexpectedErrorCallback())).releaseTask(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId));
    }

    @Override
    public void saveState(Map<String, Object> state) {
        ((TaskService)this.taskService.call(this.getSaveTaskStateCallback(), this.getUnexpectedErrorCallback())).saveTaskContent(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId), state);
    }

    @Override
    public void start() {
        ((TaskService)this.taskService.call(this.getStartTaskRemoteCallback(), this.getUnexpectedErrorCallback())).startTask(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId));
    }

    @Override
    public Panel getContainer() {
        return this.container;
    }

    @Override
    public IsWidget getFooter() {
        return this.buttonsContainer;
    }

    protected RemoteCallback getStartTaskRemoteCallback() {
        return nothing -> {
            this.taskRefreshed.fire((Object)new TaskRefreshedEvent(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId)));
            this.jsniHelper.notifySuccessMessage(this.opener, this.constants.TaskStarted(this.taskId));
            this.refresh();
        };
    }

    protected RemoteCallback getClaimTaskCallback() {
        return nothing -> {
            this.taskRefreshed.fire((Object)new TaskRefreshedEvent(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId)));
            this.jsniHelper.notifySuccessMessage(this.opener, this.constants.TaskClaimed(this.taskId));
            this.refresh();
        };
    }

    protected RemoteCallback getSaveTaskStateCallback() {
        return contentId -> {
            this.taskRefreshed.fire((Object)new TaskRefreshedEvent(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId)));
            this.jsniHelper.notifySuccessMessage(this.opener, this.constants.TaskSaved(this.taskId));
            this.refresh();
        };
    }

    protected RemoteCallback getReleaseTaskRemoteCallback() {
        return nothing -> {
            this.taskRefreshed.fire((Object)new TaskRefreshedEvent(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId)));
            this.jsniHelper.notifySuccessMessage(this.opener, this.constants.TaskReleased(this.taskId));
            this.refresh();
        };
    }

    protected RemoteCallback<Void> getCompleteTaskRemoteCallback() {
        return nothing -> {
            this.taskCompleted.fire((Object)new TaskCompletedEvent(this.serverTemplateId, this.deploymentId, this.taskId));
            this.jsniHelper.notifySuccessMessage(this.opener, this.constants.TaskCompleted(this.taskId));
            this.close();
        };
    }

    protected ErrorCallback<Message> getUnexpectedErrorCallback() {
        return (message, throwable) -> {
            String notification = this.constants.UnexpectedError(throwable.getMessage());
            this.errorPopup.showMessage(notification);
            this.jsniHelper.notifyErrorMessage(this.opener, notification);
            return true;
        };
    }

    @Override
    public void addOnCloseCallback(Command callback) {
        this.onClose = callback;
    }

    @Override
    public void addOnRefreshCallback(Command callback) {
        this.onRefresh = callback;
    }

    protected void refresh() {
        if (this.onRefresh != null) {
            this.onRefresh.execute();
        }
    }

    @Override
    public void close() {
        if (this.onClose != null) {
            this.onClose.execute();
        }
        this.clearStatus();
    }

    protected void clearStatus() {
        this.taskId = -1L;
        this.renderingSettings = null;
        this.opener = null;
        this.taskName = null;
        this.deploymentId = null;
        this.serverTemplateId = null;
        this.buttonsContainer.clear();
        this.formContainer.clear();
        this.onClose = null;
        this.onRefresh = null;
        this.resizeListener = null;
    }

    protected void eventListener(String origin, String request) {
        if (origin == null || !origin.endsWith("//" + this.opener)) {
            return;
        }
        ActionRequest actionRequest = (ActionRequest)JsonUtils.safeEval((String)request);
        if (ACTION_CLAIM_TASK.equals(actionRequest.getAction())) {
            this.claimFromDisplayer();
        } else if (ACTION_START_TASK.equals(actionRequest.getAction())) {
            this.startFromDisplayer();
        } else if (ACTION_RELEASE_TASK.equals(actionRequest.getAction())) {
            this.releaseFromDisplayer();
        } else if (ACTION_SAVE_TASK.equals(actionRequest.getAction())) {
            this.saveStateFromDisplayer();
        } else if (ACTION_COMPLETE_TASK.equals(actionRequest.getAction())) {
            this.completeFromDisplayer();
        }
    }

    private native void injectEventListener(AbstractHumanTaskFormDisplayer var1);

    @Override
    public String getOpener() {
        return this.opener;
    }
}

