/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.modeler.backend.server;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.formModeler.api.client.FormRenderContextManager;
import org.jbpm.workbench.forms.modeler.service.FormModelerProcessStarterEntryPoint;
import org.jbpm.workbench.ht.service.TaskService;
import org.jbpm.workbench.pr.service.ProcessService;

@Service
@ApplicationScoped
public class FormModelerProcessStarterEntryPointImpl
implements FormModelerProcessStarterEntryPoint {
    @Inject
    private FormRenderContextManager formRenderContextManager;
    @Inject
    private ProcessService processService;
    @Inject
    private TaskService taskService;

    public Long startProcessFromRenderContext(String ctxUID, String serverTemplateId, String domainId, String processId, String correlationKey, Long parentProcessInstanceId) {
        Map params = this.formRenderContextManager.getFormRenderContext(ctxUID).getOutputData();
        this.formRenderContextManager.removeContext(ctxUID);
        return this.processService.startProcess(serverTemplateId, domainId, processId, correlationKey, params);
    }

    public Long saveTaskStateFromRenderContext(String ctxUID, String serverTemplateId, String containerId, Long taskId, boolean clearStatus) {
        Map params = this.formRenderContextManager.getFormRenderContext(ctxUID).getOutputData();
        if (clearStatus) {
            this.formRenderContextManager.removeContext(ctxUID);
        }
        this.taskService.saveTaskContent(serverTemplateId, containerId, taskId, params);
        return -1L;
    }

    public Long saveTaskStateFromRenderContext(String ctxUID, String serverTemplateId, String containerId, Long taskId) {
        return this.saveTaskStateFromRenderContext(ctxUID, serverTemplateId, containerId, taskId, false);
    }

    public void completeTaskFromContext(String ctxUID, String serverTemplateId, String containerId, Long taskId) {
        Map params = this.formRenderContextManager.getFormRenderContext(ctxUID).getOutputData();
        this.formRenderContextManager.removeContext(ctxUID);
        this.taskService.completeTask(serverTemplateId, containerId, taskId, params);
    }

    public void clearContext(String ctxUID) {
        this.formRenderContextManager.removeContext(ctxUID);
    }
}

