/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.dd;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jbpm.workbench.wi.backend.server.dd.DDEditorServiceImpl;
import org.jbpm.workbench.wi.backend.server.dd.DeploymentDescriptorImpl;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.workbench.wi.dd.validation.DeploymentDescriptorValidationMessage;
import org.jgroups.util.UUID;
import org.junit.Test;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;

public class DDEditorServiceTest
extends DDEditorServiceImpl {
    private static Random random = new Random();

    private static ObjectModel getObjectModelParameter(String resolver) {
        return new ObjectModel(resolver, UUID.randomUUID().toString(), new Object[]{Integer.toString(random.nextInt(100000))});
    }

    @Test
    public void marshalUnmarshalTest() throws Exception {
        HashMap depDescFields = new HashMap();
        HashMap depDescModelFields = new HashMap();
        Map[] fieldMaps = new Map[]{depDescFields, depDescModelFields};
        Field[][] fields = new Field[][]{DeploymentDescriptorImpl.class.getDeclaredFields(), DeploymentDescriptorModel.class.getDeclaredFields()};
        for (int i = 0; i < fieldMaps.length; ++i) {
            for (Field field : fields[i]) {
                fieldMaps[i].put(field.getName(), field);
            }
        }
        DeploymentDescriptorImpl origDepDesc = new DeploymentDescriptorImpl();
        origDepDesc.setAuditMode(AuditMode.JMS);
        origDepDesc.setAuditPersistenceUnit("audit-persist");
        origDepDesc.setClasses(Collections.singletonList("class1"));
        origDepDesc.setLimitSerializationClasses(Boolean.valueOf(true));
        origDepDesc.setPersistenceMode(PersistenceMode.JPA);
        origDepDesc.setPersistenceUnit("save-thingy");
        origDepDesc.setRequiredRoles(Collections.singletonList("roles"));
        origDepDesc.setRuntimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE);
        String resolver = "config-resolver";
        origDepDesc.setConfiguration(Collections.singletonList(new NamedObjectModel(resolver, "config-name", "classname", new Object[]{DDEditorServiceTest.getObjectModelParameter(resolver)})));
        resolver = "env-resolver";
        origDepDesc.setEnvironmentEntries(Collections.singletonList(new NamedObjectModel(resolver, "env-name", "classname", new Object[]{DDEditorServiceTest.getObjectModelParameter(resolver)})));
        resolver = "event-resolver";
        origDepDesc.setEventListeners(Collections.singletonList(new ObjectModel(resolver, "listener-id", new Object[]{DDEditorServiceTest.getObjectModelParameter(resolver)})));
        resolver = "glob-resolver";
        origDepDesc.setGlobals(Collections.singletonList(new NamedObjectModel(resolver, "glob-name", "classname", new Object[]{DDEditorServiceTest.getObjectModelParameter(resolver)})));
        resolver = "marsh-resolver";
        origDepDesc.setMarshallingStrategies(Collections.singletonList(new ObjectModel(resolver, "marsh-id", new Object[]{DDEditorServiceTest.getObjectModelParameter(resolver)})));
        resolver = "task-resolver";
        origDepDesc.setTaskEventListeners(Collections.singletonList(new ObjectModel(resolver, "listener-id", new Object[]{DDEditorServiceTest.getObjectModelParameter(resolver)})));
        resolver = "work-resolver";
        origDepDesc.setWorkItemHandlers(Collections.singletonList(new NamedObjectModel(resolver, "item-name", "handler-classname", new Object[]{DDEditorServiceTest.getObjectModelParameter(resolver)})));
        DeploymentDescriptorModel origModel = this.marshal((DeploymentDescriptor)origDepDesc);
        DeploymentDescriptor copyDepDesc = this.unmarshal(null, origModel);
        Assertions.assertThat((Object)origDepDesc).isEqualToIgnoringGivenFields((Object)copyDepDesc, new String[]{"mappedRoles"});
        DeploymentDescriptorModel copyModel = this.marshal(copyDepDesc);
        Assertions.assertThat((Object)origModel).isEqualToComparingFieldByFieldRecursively((Object)copyModel);
    }

    @Test
    public void testValidateEmptyResolver() {
        List validationMessages = this.validateObjectModels(null, Collections.singletonList(new NamedObjectModel(null, "item-name", "handler-classname", new Object[0])));
        Assertions.assertThat((List)validationMessages).hasSize(1);
        ValidationMessage error = (ValidationMessage)validationMessages.get(0);
        Assertions.assertThat((Comparable)error.getLevel()).isEqualTo((Object)Level.ERROR);
        Assertions.assertThat((String)error.getText()).startsWith((CharSequence)"No resolver selected");
        validationMessages = this.validateObjectModels(null, Collections.singletonList(new NamedObjectModel("", "item-name", "handler-classname", new Object[0])));
        Assertions.assertThat((int)validationMessages.size()).isEqualTo(1);
        error = (ValidationMessage)validationMessages.get(0);
        Assertions.assertThat((Comparable)error.getLevel()).isEqualTo((Object)Level.ERROR);
        Assertions.assertThat((String)error.getText()).startsWith((CharSequence)"Not valid resolver selected");
        Assertions.assertThat((Object)error).isInstanceOf(DeploymentDescriptorValidationMessage.class);
        Assertions.assertThat((String)((DeploymentDescriptorValidationMessage)error).getKey()).isEqualTo((Object)"DDValidationNotValidResolver");
    }

    @Test
    public void testValidateReflectionResolver() {
        List validationMessages = this.validateObjectModels(null, Collections.singletonList(new NamedObjectModel("reflection", "item-name", "java.lang.String", new Object[0])));
        Assertions.assertThat((List)validationMessages).isEmpty();
    }

    @Test
    public void testValidateReflectionResolverInvalid() {
        List validationMessages = this.validateObjectModels(null, Collections.singletonList(new NamedObjectModel("reflection", "item-name", "handler-classname", new Object[0])));
        Assertions.assertThat((List)validationMessages).hasSize(1);
        ValidationMessage error = (ValidationMessage)validationMessages.get(0);
        Assertions.assertThat((Comparable)error.getLevel()).isEqualTo((Object)Level.ERROR);
        Assertions.assertThat((String)error.getText()).startsWith((CharSequence)"Identifier is not valid Java class which is required by reflection resolver");
        Assertions.assertThat((Object)error).isInstanceOf(DeploymentDescriptorValidationMessage.class);
        Assertions.assertThat((String)((DeploymentDescriptorValidationMessage)error).getKey()).isEqualTo((Object)"DDValidationNotValidReflectionIdentifier");
    }

    @Test
    public void testValidateReflectionResolverMissingIdentifier() {
        List validationMessages = this.validateObjectModels(null, Collections.singletonList(new NamedObjectModel("reflection", "item-name", "", new Object[0])));
        Assertions.assertThat((List)validationMessages).hasSize(2);
        ValidationMessage error = (ValidationMessage)validationMessages.get(0);
        Assertions.assertThat((Comparable)error.getLevel()).isEqualTo((Object)Level.ERROR);
        Assertions.assertThat((String)error.getText()).startsWith((CharSequence)"Identifier cannot be empty");
        Assertions.assertThat((Object)error).isInstanceOf(DeploymentDescriptorValidationMessage.class);
        Assertions.assertThat((String)((DeploymentDescriptorValidationMessage)error).getKey()).isEqualTo((Object)"DDValidationMissingIdentifier");
        error = (ValidationMessage)validationMessages.get(1);
        Assertions.assertThat((Comparable)error.getLevel()).isEqualTo((Object)Level.ERROR);
        Assertions.assertThat((String)error.getText()).startsWith((CharSequence)"Identifier is not valid Java class which is required by reflection resolver");
        Assertions.assertThat((Object)error).isInstanceOf(DeploymentDescriptorValidationMessage.class);
        Assertions.assertThat((String)((DeploymentDescriptorValidationMessage)error).getKey()).isEqualTo((Object)"DDValidationNotValidReflectionIdentifier");
    }

    @Test
    public void testValidateReflectionResolverNameEmpty() {
        List validationMessages = this.validateObjectModels(null, Collections.singletonList(new NamedObjectModel("reflection", "", "java.lang.String", new Object[0])));
        Assertions.assertThat((List)validationMessages).hasSize(1);
        ValidationMessage error = (ValidationMessage)validationMessages.get(0);
        Assertions.assertThat((Comparable)error.getLevel()).isEqualTo((Object)Level.ERROR);
        Assertions.assertThat((String)error.getText()).startsWith((CharSequence)"Name cannot be empty");
        Assertions.assertThat((Object)error).isInstanceOf(DeploymentDescriptorValidationMessage.class);
        Assertions.assertThat((String)((DeploymentDescriptorValidationMessage)error).getKey()).isEqualTo((Object)"DDValidationMissingName");
    }

    @Test
    public void testValidateMvelResolver() {
        List validationMessages = this.validateObjectModels(null, Collections.singletonList(new NamedObjectModel("mvel", "item-name", "new String()", new Object[0])));
        Assertions.assertThat((List)validationMessages).isEmpty();
    }

    @Test
    public void testValidateMvelResolverWithValidParameters() {
        List validationMessages = this.validateObjectModels(null, Collections.singletonList(new NamedObjectModel("mvel", "item-name", "java.util.Arrays.asList(ksession, taskService, runtimeManager, classLoader, entityManagerFactory);", new Object[0])));
        Assertions.assertThat((List)validationMessages).isEmpty();
        List secondValidationMessages = this.validateObjectModels(null, Collections.singletonList(new NamedObjectModel("mvel", "item-name", "org.jbpm.process.workitem.bpmn2.ServiceTaskHandler(ksession, classLoader)", new Object[0])));
        Assertions.assertThat((List)secondValidationMessages).isEmpty();
    }

    @Test
    public void testValidateMvelResolverWithInvalidParameters() {
        List validationMessages = this.validateObjectModels(null, Collections.singletonList(new NamedObjectModel("mvel", "item-name", "java.util.Arrays.asList(invalidParamExpr[);", new Object[0])));
        Assertions.assertThat((List)validationMessages).hasSize(1);
        ValidationMessage error = (ValidationMessage)validationMessages.get(0);
        Assertions.assertThat((Comparable)error.getLevel()).isEqualTo((Object)Level.WARNING);
        Assertions.assertThat((String)error.getText()).startsWith((CharSequence)"Could not compile mvel expression");
        Assertions.assertThat((Object)error).isInstanceOf(DeploymentDescriptorValidationMessage.class);
        Assertions.assertThat((String)((DeploymentDescriptorValidationMessage)error).getKey()).isEqualTo((Object)"DDValidationNotValidMvelIdentifier");
    }

    @Test
    public void testValidateMvelResolverInvalid() {
        List validationMessages = this.validateObjectModels(null, Collections.singletonList(new NamedObjectModel("mvel", "item-name", "org.jbpm.process.workitem.bpmn2.ServiceTaskHandler(ksession, classLoader", new Object[0])));
        Assertions.assertThat((List)validationMessages).hasSize(1);
        ValidationMessage error = (ValidationMessage)validationMessages.get(0);
        Assertions.assertThat((Comparable)error.getLevel()).isEqualTo((Object)Level.WARNING);
        Assertions.assertThat((String)error.getText()).startsWith((CharSequence)"Could not compile mvel expression");
        Assertions.assertThat((Object)error).isInstanceOf(DeploymentDescriptorValidationMessage.class);
        Assertions.assertThat((String)((DeploymentDescriptorValidationMessage)error).getKey()).isEqualTo((Object)"DDValidationNotValidMvelIdentifier");
    }
}

