/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.workitem;

import org.jbpm.workbench.wi.backend.server.workitem.WorkbenchRepositoryEventListener;
import org.junit.Assert;
import org.junit.Test;

public class WorkbenchRepositoryEventListenerTest {
    @Test
    public void testVersionResolveNoRangeOnFinal() {
        WorkbenchRepositoryEventListener listener = new WorkbenchRepositoryEventListener();
        String version = "7.16.0.Final";
        String resolved = listener.resolveVersion(version, false);
        Assert.assertEquals((Object)version, (Object)resolved);
    }

    @Test
    public void testVersionResolveNoRangeOnSnapshot() {
        WorkbenchRepositoryEventListener listener = new WorkbenchRepositoryEventListener();
        String version = "7.16.0-SNAPSHOT";
        String resolved = listener.resolveVersion(version, false);
        Assert.assertEquals((Object)version, (Object)resolved);
    }

    @Test
    public void testVersionResolveRangeOnFinal() {
        WorkbenchRepositoryEventListener listener = new WorkbenchRepositoryEventListener();
        String version = "7.16.0.Final";
        String resolved = listener.resolveVersion(version, true);
        Assert.assertEquals((Object)"[7.16,)", (Object)resolved);
    }

    @Test
    public void testVersionResolveRangeOnSnapshot() {
        WorkbenchRepositoryEventListener listener = new WorkbenchRepositoryEventListener();
        String version = "7.16.0-SNAPSHOT";
        String resolved = listener.resolveVersion(version, true);
        Assert.assertEquals((Object)"[7.16,)", (Object)resolved);
    }

    @Test
    public void testVersionResolveRangeOnShortFinal() {
        WorkbenchRepositoryEventListener listener = new WorkbenchRepositoryEventListener();
        String version = "7.Final";
        String resolved = listener.resolveVersion(version, true);
        Assert.assertEquals((Object)"[7,)", (Object)resolved);
    }
}

