/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.workitem;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.jbpm.process.workitem.repository.RepositoryEventListener;
import org.jbpm.process.workitem.repository.RepositoryStorage;
import org.jbpm.process.workitem.repository.service.RepoData;
import org.jbpm.process.workitem.repository.service.RepoService;
import org.jbpm.workbench.wi.backend.server.workitem.RepositoryStorageVFSImpl;
import org.jbpm.workbench.wi.backend.server.workitem.ServiceTaskServiceImpl;
import org.jbpm.workbench.wi.workitems.model.ServiceTaskSummary;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;

@RunWith(value=MockitoJUnitRunner.class)
public class ServiceTaskServiceImplTest {
    private static final String GAV = "org.jbpm.workitem.test:workitem.test:1.0";
    private static final String WORKITEMNAME = "Test";
    @Mock
    private IOService ioService;
    @Mock
    private FileSystem fileSystem;
    @Mock
    private RepositoryEventListener eventListener;
    private RepoData service;
    private RepositoryStorageVFSImpl storage;
    private RepoService repoService;
    private ServiceTaskServiceImpl serviceTaskServiceImpl;
    private int serviceTaskSize = 0;
    @Mock
    private GuvnorM2Repository m2Repository;

    @Before
    public void init() {
        this.storage = new RepositoryStorageVFSImpl(this.ioService, this.fileSystem);
        this.storage.init();
        this.repoService = new RepoService((RepositoryStorage)this.storage, new RepositoryEventListener[]{this.eventListener});
        this.serviceTaskServiceImpl = new ServiceTaskServiceImpl();
        this.serviceTaskServiceImpl.setRepoService(this.repoService);
        this.serviceTaskServiceImpl.setM2Repository(this.m2Repository);
        this.serviceTaskSize = this.repoService.getServices().size();
        File file = new File(ServiceTaskServiceImplTest.class.getResource("/workitem.test-1.0.jar").getFile());
        Mockito.when((Object)this.m2Repository.getArtifactFileFromRepository(new GAV(GAV))).thenReturn((Object)file);
    }

    private void loadServices(String name, List<RepoData> currentServices) {
        this.service = new RepoData();
        this.service.setName(name);
        this.service.setModule("module");
        this.service.getInstalledOn().add("myspace/myproject");
        currentServices.add(this.service);
        this.storage.synchronizeServices(currentServices);
    }

    @Test
    public void testAddServiceTasksByCreated() {
        ArrayList<RepoData> currentServices = new ArrayList<RepoData>();
        this.loadServices("Test1", currentServices);
        Assert.assertEquals((long)(this.serviceTaskSize + 1), (long)this.serviceTaskServiceImpl.getServiceTasks().size());
        Map resultMap = this.serviceTaskServiceImpl.addServiceTasks(GAV);
        Assert.assertEquals((long)(this.serviceTaskSize + 2), (long)this.serviceTaskServiceImpl.getServiceTasks().size());
        Assert.assertEquals((Object)WORKITEMNAME, ((List)resultMap.get("Created")).get(0));
        Assert.assertTrue((boolean)((List)resultMap.get("Skipped")).isEmpty());
        Optional<ServiceTaskSummary> optional = this.serviceTaskServiceImpl.getServiceTasks().stream().filter(serviceTaskSummary -> serviceTaskSummary.getName().equals(WORKITEMNAME)).findFirst();
        Assert.assertTrue((boolean)optional.isPresent());
    }

    @Test
    public void testAddServiceTasksBySkipped() {
        ArrayList<RepoData> currentServices = new ArrayList<RepoData>();
        this.loadServices(WORKITEMNAME, currentServices);
        Assert.assertEquals((long)(this.serviceTaskSize + 1), (long)this.serviceTaskServiceImpl.getServiceTasks().size());
        Map resultMap = this.serviceTaskServiceImpl.addServiceTasks(GAV);
        Assert.assertEquals((long)(this.serviceTaskSize + 1), (long)this.serviceTaskServiceImpl.getServiceTasks().size());
        Assert.assertEquals((Object)WORKITEMNAME, ((List)resultMap.get("Skipped")).get(0));
        Assert.assertTrue((boolean)((List)resultMap.get("Created")).isEmpty());
        Optional<ServiceTaskSummary> optional = this.serviceTaskServiceImpl.getServiceTasks().stream().filter(serviceTaskSummary -> serviceTaskSummary.getName().equals(WORKITEMNAME)).findFirst();
        Assert.assertTrue((boolean)optional.isPresent());
    }

    @Test
    public void testRemoveServiceTask() {
        ArrayList<RepoData> currentServices = new ArrayList<RepoData>();
        String stName = "Test1";
        this.loadServices(stName, currentServices);
        RepoData rd = (RepoData)currentServices.get(0);
        ServiceTaskSummary st = new ServiceTaskSummary();
        st.setName(rd.getName());
        st.setId(rd.getId());
        st.setInstalledOn(Collections.emptySet());
        Assert.assertEquals((long)(this.serviceTaskSize + 1), (long)this.serviceTaskServiceImpl.getServiceTasks().size());
        Assert.assertEquals((Object)stName, (Object)this.serviceTaskServiceImpl.removeServiceTask(st));
        List afterRemoveAction = this.serviceTaskServiceImpl.getServiceTasks();
        Assert.assertEquals((long)this.serviceTaskSize, (long)afterRemoveAction.size());
        Optional<ServiceTaskSummary> optionalServiceTaskSummary = afterRemoveAction.stream().filter(s -> s.getName().equals(stName)).findFirst();
        Assert.assertFalse((boolean)optionalServiceTaskSummary.isPresent());
    }
}

